/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.zb;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.other.BsCommonExample;
import com.ruoyi.system.domain.zb.ZbAutoRecord;
import com.ruoyi.system.domain.zb.ZbAutoRecordExample;
import com.ruoyi.system.domain.zb.ZbReportRecord;
import com.ruoyi.system.domain.zb.ZbWeekReportExample;
import com.ruoyi.system.domain.zb.request.WeekReportSaveRequest;
import com.ruoyi.system.mapper.other.BsCommonMapper;
import com.ruoyi.system.mapper.zb.ZbAutoRecordMapper;
import com.ruoyi.system.mapper.zb.ZbWeekReportMapper;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.zb.ReportRecordService;
import com.ruoyi.system.service.zb.WeekReportService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5468\u62a5"})
@RestController
@RequestMapping(value={"/api/zb/report"})
public class WeekReportController
extends BaseController {
    @Autowired
    private WeekReportService weekReportService;
    @Autowired
    private ZbWeekReportMapper weekReportMapper;
    @Autowired
    private ReportRecordService reportRecordService;
    @Autowired
    private ZbAutoRecordMapper autoRecordMapper;
    @Autowired
    private BsCommonMapper bsCommonMapper;
    @Autowired
    private ISysUserService sysUserService;

    @PostMapping(value={"/save"})
    public AjaxResult save(@RequestBody WeekReportSaveRequest request) {
        request.setCreateTime(new Date());
        request.setCreateUser(this.getUserId());
        if (request.getPublishFlag() == 1) {
            ZbWeekReportExample example = new ZbWeekReportExample();
            ZbWeekReportExample.Criteria criteria = example.createCriteria();
            criteria.andValidEqualTo(Byte.valueOf((byte)1));
            criteria.andEndDateGreaterThanOrEqualTo(request.getStartDate());
            if (this.weekReportMapper.countByExample(example) > 0L) {
                return AjaxResult.error((String)"\u5f00\u59cb\u65e5\u671f\u5df2\u7ecf\u5b58\u5728\u4e8e\u5176\u4f59\u5468\u62a5\u586b\u62a5\u65f6\u95f4\u4e2d\uff01\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            }
        }
        this.weekReportService.save(request);
        return AjaxResult.success();
    }

    @PostMapping(value={"/update"})
    public AjaxResult update(@RequestBody WeekReportSaveRequest request) {
        request.setUpdateTime(new Date());
        request.setUpdateUser(this.getUserId());
        if (request.getPublishFlag() == 1) {
            ZbWeekReportExample example = new ZbWeekReportExample();
            ZbWeekReportExample.Criteria criteria = example.createCriteria();
            criteria.andValidEqualTo(Byte.valueOf((byte)1));
            criteria.andIdNotEqualTo(request.getId());
            criteria.andEndDateGreaterThanOrEqualTo(request.getStartDate());
            if (this.weekReportMapper.countByExample(example) > 0L) {
                return AjaxResult.error((String)"\u5f00\u59cb\u65e5\u671f\u5df2\u7ecf\u5b58\u5728\u4e8e\u5176\u4f59\u5468\u62a5\u586b\u62a5\u65f6\u95f4\u4e2d\uff01\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            }
        }
        this.weekReportService.update(request);
        return AjaxResult.success();
    }

    @GetMapping(value={"/cancelAuto"})
    public AjaxResult cancelAuto() {
        this.weekReportService.cancelAuto();
        return AjaxResult.success();
    }

    @GetMapping(value={"/hasPublished"})
    public AjaxResult hasPublished() {
        ZbAutoRecordExample example = new ZbAutoRecordExample();
        ZbAutoRecordExample.Criteria criteria = example.createCriteria();
        criteria.andValidEqualTo(Byte.valueOf((byte)1));
        if (this.autoRecordMapper.countByExample(example) > 0L) {
            return AjaxResult.success((Object)true);
        }
        return AjaxResult.success((Object)false);
    }

    @GetMapping(value={"/latestDetail"})
    public AjaxResult latestDetail() {
        ZbAutoRecordExample example = new ZbAutoRecordExample();
        ZbAutoRecordExample.Criteria criteria = example.createCriteria();
        criteria.andValidEqualTo(Byte.valueOf((byte)1));
        List autoRecordList = this.autoRecordMapper.selectByExample(example);
        ZbAutoRecord autoRecord = (ZbAutoRecord)autoRecordList.get(0);
        return AjaxResult.success((Object)this.weekReportService.simpleDetail(autoRecord.getLastReportId()));
    }

    @GetMapping(value={"/simpleDetail/{id}"})
    public AjaxResult simpleDetail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.weekReportService.simpleDetail(id));
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.weekReportService.reportWithUserDetail(id, this.getUserId()));
    }

    @GetMapping(value={"/user/page"})
    public AjaxResult page(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="recordId") String recordId) {
        List canSeeList = this.weekReportService.canSeeUserList(this.getUserId(), recordId);
        if (CollectionUtils.isEmpty((Collection)canSeeList)) {
            return AjaxResult.success((Object)new PageInfo(new ArrayList()));
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = this.reportRecordService.pageFinishedUser(recordId, canSeeList);
        return AjaxResult.success((Object)pageInfo);
    }

    @GetMapping(value={"/page"})
    public AjaxResult page(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="title", required=false) String title, @RequestParam(value="year", required=false) String year, @RequestParam(value="week", required=false) String week) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = this.weekReportService.page(title, year, week, this.getUserId());
        return AjaxResult.success((Object)pageInfo);
    }

    @GetMapping(value={"/finishCondition/{reportId}"})
    public AjaxResult finishedCondition(@PathVariable(value="reportId") String reportId) {
        return AjaxResult.success((Object)this.reportRecordService.finishCondition(reportId, this.getUserId()));
    }

    @PostMapping(value={"/record/save"})
    public AjaxResult save(@RequestBody ZbReportRecord request) {
        if (StringUtils.isBlank((CharSequence)request.getId())) {
            request.setSubmitTime(new Date());
        }
        request.setUserId(this.getUserId());
        SysUser sysUser = this.sysUserService.selectUserById(this.getUserId());
        request.setDepId(sysUser.getDeptId().toString());
        this.reportRecordService.save(request);
        return AjaxResult.success();
    }

    @GetMapping(value={"/app/page"})
    public AjaxResult specialWorkPage(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="title", required=false) String title) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = this.weekReportService.pageForApp(this.getUserId(), title, pageNum, pageSize);
        return AjaxResult.success((Object)pageInfo);
    }

    @GetMapping(value={"/app/detail/{id}"})
    public AjaxResult appDetail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.reportRecordService.weekReportDetail(id, this.getUserId()));
    }

    @GetMapping(value={"/app/detail/permission/{id}"})
    public AjaxResult appDetailOtherInfo(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.reportRecordService.appReportDetail(this.getLoginUser().getUser(), id));
    }

    @GetMapping(value={"/reportDictList"})
    public AjaxResult userTree() {
        BsCommonExample bsCommonExample = new BsCommonExample();
        BsCommonExample.Criteria criteria = bsCommonExample.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andCodeLike("week_report_summary");
        criteria.andParentIdIsNull();
        List commonList = this.bsCommonMapper.selectByExample(bsCommonExample);
        return AjaxResult.success(commonList.get(0));
    }
}

