/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.zb;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.zb.enums.ZbSpecialWorkEnum;
import com.ruoyi.system.domain.zb.request.SpecialWorkSaveRequest;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.zb.SpecialWorkService;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e13\u9879\u5de5\u4f5c"})
@RestController
@RequestMapping(value={"/api/zb/work"})
public class SpecialWorkController
extends BaseController {
    @Autowired
    private SpecialWorkService specialWorkService;
    @Autowired
    private GridRegionUserService gridRegionUserService;

    @PostMapping(value={"/special/save"})
    public AjaxResult saveSpecialWork(@RequestBody SpecialWorkSaveRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getUserIdList())) {
            return AjaxResult.error((String)"\u53d1\u5e03\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        request.setType(ZbSpecialWorkEnum.SPECIAL_WORK.getCode());
        this.sameSave(request);
        return AjaxResult.success();
    }

    private void sameSave(SpecialWorkSaveRequest request) {
        SysUser sysUser = this.getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateUserName(sysUser.getNickName());
        request.setValid(Byte.valueOf((byte)1));
        GridRegionUser gridRegionUser = this.gridRegionUserService.selectByUserId(sysUser.getUserId());
        if (gridRegionUser != null) {
            request.setWgCode(gridRegionUser.getWgId());
        }
        this.specialWorkService.save(request);
    }

    @GetMapping(value={"/delete"})
    public AjaxResult deleteSpecialWork(@RequestParam(value="id") String id) {
        this.specialWorkService.delete(id);
        return AjaxResult.success();
    }

    @PostMapping(value={"/special/update"})
    public AjaxResult updateSpecialWork(@RequestBody SpecialWorkSaveRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getUserIdList()) || StringUtils.isBlank((CharSequence)request.getId())) {
            return AjaxResult.error((String)"\u53c2\u6570\u9519\u8bef\uff01");
        }
        request.setType(ZbSpecialWorkEnum.SPECIAL_WORK.getCode());
        this.sameUpdate(request);
        return AjaxResult.success();
    }

    private void sameUpdate(SpecialWorkSaveRequest request) {
        SysUser sysUser = this.getLoginUser().getUser();
        request.setUpdateUser(sysUser.getUserId());
        request.setUpdateUserName(sysUser.getNickName());
        request.setUpdateTime(new Date());
        this.specialWorkService.update(request);
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.specialWorkService.detail(id));
    }

    @GetMapping(value={"/special/page"})
    public AjaxResult specialWorkPage(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="title", required=false) String title, @RequestParam(value="userName", required=false) String userName) {
        SysUser sysUser = this.getLoginUser().getUser();
        String userId = "";
        if (!sysUser.isAdmin()) {
            userId = sysUser.getUserId();
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = this.specialWorkService.page(title, userName, ZbSpecialWorkEnum.SPECIAL_WORK.getCode(), userId);
        return AjaxResult.success((Object)pageInfo);
    }
}

