/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.zb;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.system.domain.zb.vo.DutyWorkConfigVO;
import com.ruoyi.system.service.zb.DutyWorkService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u503c\u73ed"})
@RestController
@RequestMapping(value={"/api/zb/duty"})
public class DutyWorkController
extends BaseController {
    @Autowired
    private DutyWorkService dutyWorkService;

    @PostMapping(value={"/save"})
    public AjaxResult save(@RequestBody DutyWorkConfigVO request) {
        SysUser sysUser = this.getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateUserName(sysUser.getNickName());
        this.dutyWorkService.save(request);
        return AjaxResult.success();
    }

    @PostMapping(value={"/update"})
    public AjaxResult update(@RequestBody DutyWorkConfigVO request) {
        SysUser sysUser = this.getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateUserName(sysUser.getNickName());
        this.dutyWorkService.update(request);
        return AjaxResult.success();
    }

    @GetMapping(value={"/page"})
    public AjaxResult dutyPage(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="title", required=false) String title) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = this.dutyWorkService.dutyRecordPage(title);
        return AjaxResult.success((Object)pageInfo);
    }

    @GetMapping(value={"/config/detail"})
    public AjaxResult detail() {
        return AjaxResult.success((Object)this.dutyWorkService.configDetail());
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.dutyWorkService.dutyWorkDetail(id));
    }
}

