/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.visit;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.zqt.ZQTreeNode;
import com.ruoyi.system.domain.visit.VisitFreePlanModel;
import com.ruoyi.system.domain.visit.enums.VisitTypeEnum;
import com.ruoyi.system.domain.visit.ext.VisitFreeInterviewExt;
import com.ruoyi.system.domain.visit.ext.VisitFreePlanModelExt;
import com.ruoyi.system.service.visit.VisitFreeInterviewService;
import com.ruoyi.system.service.visit.VisitFreePlanModelService;
import com.ruoyi.system.service.visit.VisitFreePlanService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d70\u8bbf\u7ba1\u7406 - \u66f4\u65b0\u8d70\u8bbf"})
@RestController
@RequestMapping(value={"/api/visit/updatePlan"})
public class VisitUpdatePlanController {
    @Autowired
    VisitFreePlanModelService visitFreePlanModelService;
    @Autowired
    VisitFreeInterviewService visitFreeInterviewService;
    @Autowired
    VisitFreePlanService visitFreePlanService;

    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public AjaxResult list(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="planAllNum", required=false) Long planAllNum, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="planType", required=false) String planType, @RequestParam(value="planTitle", required=false) String planTitle) {
        try {
            PageInfo pageInfo = this.visitFreePlanModelService.freePlanModelPage(VisitTypeEnum.UPDATE_VISIT.getCode(), pageNum, pageSize, planAllNum, startTime, endTime, planType, planTitle, null, null);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @RequestMapping(value={"/freePlanPage"}, method={RequestMethod.GET})
    public AjaxResult freePlanPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="hasDone", required=false) String hasDone, @RequestParam(value="planTitle", required=false) String planTitle) {
        SysUser sysUser = SecurityUtils.getLoginUser().getUser();
        PageInfo pageInfo = this.visitFreePlanModelService.freePlanPage(sysUser, VisitTypeEnum.UPDATE_VISIT.getCode(), pageNum, pageSize, wgCode, hasDone, planTitle);
        return AjaxResult.success((Object)pageInfo);
    }

    @RequestMapping(value={"/interviewPage"}, method={RequestMethod.GET})
    public AjaxResult interviewPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="wgCodes", required=false) List<String> wgCodes, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="type", required=false) String type, @RequestParam(value="planModelId", required=false) String planModelId) {
        try {
            PageInfo pageInfo = this.visitFreeInterviewService.freeInterviewPage(VisitTypeEnum.FREE_VISIT.getCode(), pageNum, pageSize, wgCodes, startTime, endTime, type, planModelId, wgCode);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/addPlanModel"})
    public AjaxResult add(@RequestBody VisitFreePlanModelExt visitFreePlanModelExt) {
        visitFreePlanModelExt.setVisitType(VisitTypeEnum.UPDATE_VISIT.getCode());
        return this.visitFreePlanModelService.addVisitFreePlanModel(visitFreePlanModelExt);
    }

    @PutMapping(value={"/update"})
    public AjaxResult update(@RequestBody VisitFreePlanModelExt visitFreePlanModelExt) {
        visitFreePlanModelExt.setVisitType(VisitTypeEnum.UPDATE_VISIT.getCode());
        return this.visitFreePlanModelService.updateVisitFreePlanModel(visitFreePlanModelExt);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public AjaxResult delete(@RequestBody VisitFreePlanModel planModel) {
        this.visitFreePlanModelService.delete(planModel.getId());
        return AjaxResult.success((String)"success");
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public AjaxResult info(@RequestParam(value="id") String id) {
        VisitFreePlanModelExt visitPlanExt = this.visitFreePlanModelService.info(id);
        return AjaxResult.success((Object)visitPlanExt);
    }

    @RequestMapping(value={"/Tree"}, method={RequestMethod.GET})
    public AjaxResult Tree(@RequestParam(value="id") String id) {
        ZQTreeNode treeNode = this.visitFreePlanModelService.freePlanTree(id);
        return AjaxResult.success((Object)treeNode);
    }

    @PostMapping(value={"/addInterview"})
    public AjaxResult addInterview(@RequestBody VisitFreeInterviewExt visitFreeInterviewExt) {
        visitFreeInterviewExt.setVisitType(VisitTypeEnum.UPDATE_VISIT.getCode());
        return this.visitFreeInterviewService.addVisitFreeInterview(visitFreeInterviewExt);
    }

    @GetMapping(value={"/interviewCountStatistic"})
    public AjaxResult interviewCountStatistic() {
        Map result = this.visitFreeInterviewService.interviewCountStatistic(VisitTypeEnum.UPDATE_VISIT.getCode());
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/freePlanInterviewStatistic"}, method={RequestMethod.GET})
    public AjaxResult freePlanInterviewStatistic(@RequestParam(value="planModelId") String planModelId, @RequestParam(value="wgCodes", required=false) List<String> wgCodes, @RequestParam(value="wgCode", required=false) String wgCode) {
        Map result = this.visitFreeInterviewService.freePlanInterviewStatistic(planModelId, wgCodes, wgCode);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/modelDoneStatistic"}, method={RequestMethod.GET})
    public AjaxResult modelDoneStatistic(@RequestParam(value="planModelId") String planModelId) {
        Map result = this.visitFreePlanService.modelHasDone(planModelId);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/freeInterviewStatistic"}, method={RequestMethod.GET})
    public AjaxResult freeInterviewStatistic() {
        Map result = this.visitFreeInterviewService.freeInterviewStatistic(VisitTypeEnum.UPDATE_VISIT.getCode());
        return AjaxResult.success((Object)result);
    }
}

