/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.visit;

import com.alibaba.fastjson2.JSON;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTreeNode;
import com.ruoyi.system.domain.visit.VisitPlanTask;
import com.ruoyi.system.domain.visit.ext.VisitPlanExt;
import com.ruoyi.system.domain.visit.ext.VisitPlanTaskExt;
import com.ruoyi.system.domain.visit.vo.VisitPlanRate;
import com.ruoyi.system.service.visit.VisitPlanService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d70\u8bbf\u7ba1\u7406 - \u7efc\u5408\u6267\u6cd5\u8d70\u8bbf"})
@RestController
@RequestMapping(value={"/api/visit/plan"})
public class VisitPlanController {
    @Autowired
    private VisitPlanService visitPlanService;

    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public AjaxResult list(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="planFl") String planFl, @RequestParam(value="planTitle", required=false) String planTitle, @RequestParam(value="planType", required=false) String planType, @RequestParam(value="planTime", required=false) String planTime, @RequestParam(value="planObjType", required=false) String planObjType) {
        try {
            PageInfo pageInfo = this.visitPlanService.selectByPage(pageNum, pageSize, planTitle, planType, planTime, planObjType, planFl);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody VisitPlanExt wszfPlanExt) {
        this.visitPlanService.save(wszfPlanExt);
        return AjaxResult.success((String)"success");
    }

    @PostMapping(value={"/update"})
    public AjaxResult update(@RequestBody VisitPlanExt wszfPlanExt) {
        this.visitPlanService.update(wszfPlanExt);
        return AjaxResult.success((String)"success");
    }

    @PostMapping(value={"/updateRecordId"})
    public AjaxResult updateRecordId(@RequestBody VisitPlanTask planTask) {
        this.visitPlanService.updateTaskRecordId(planTask.getId(), planTask.getYlzd3());
        return AjaxResult.success((String)"success");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public AjaxResult delete(@RequestParam(value="id") String id) {
        this.visitPlanService.delete(id);
        return AjaxResult.success((String)"success");
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public AjaxResult info(@RequestParam(value="id") String id) {
        VisitPlanExt visitPlanExt = this.visitPlanService.info(id);
        return AjaxResult.success((Object)visitPlanExt);
    }

    @RequestMapping(value={"/planTaskPage"}, method={RequestMethod.GET})
    public AjaxResult planTaskPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="planId") String planId, @RequestParam(value="planTaskStatus", required=false) String planTaskStatus, @RequestParam(value="objWgCode", required=false) String objWgCode, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="objType", required=false) String objType, @RequestParam(value="objName", required=false) String objName) {
        try {
            PageInfo pageInfo = this.visitPlanService.planTaskPage(pageNum, pageSize, planId, planTaskStatus, objWgCode, startTime, endTime, objType, objName);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @RequestMapping(value={"/planTaskPageApp"}, method={RequestMethod.GET})
    public AjaxResult planTaskPageApp(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="userId", required=false) String userId, @RequestParam(value="planFl") String planFl, @RequestParam(value="objName", required=false) String objName, @RequestParam(value="planTaskStatus", required=false) String planTaskStatus, @RequestParam(value="objType", required=false) String objType) {
        try {
            PageInfo pageInfo = this.visitPlanService.planTaskPageApp(pageNum, pageSize, userId, planTaskStatus, objName, objType, planFl);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @RequestMapping(value={"/getPlanWgTree"}, method={RequestMethod.GET})
    public AjaxResult getPlanWgTree(@RequestParam(value="planId") String planId) {
        try {
            ZQTreeNode result = this.visitPlanService.getPlanWgTree(planId);
            return AjaxResult.success((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @RequestMapping(value={"/infoTj"}, method={RequestMethod.GET})
    public AjaxResult infoTj(String wgCode, @RequestParam(value="planId") String planId) {
        Map result = this.visitPlanService.infoTj(wgCode, planId);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/aqzfPcTj"}, method={RequestMethod.GET})
    public AjaxResult aqzfPcTj() {
        Map result = this.visitPlanService.aqzfPcTj();
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/app/aqzfTj"}, method={RequestMethod.GET})
    public AjaxResult appAqzfTj(@RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="objType") String objType, @RequestParam(value="wgCode") String wgCode) {
        Map result = this.visitPlanService.appAqzfTj(startDate, endDate, objType, wgCode);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/rhzfPcTj"}, method={RequestMethod.GET})
    public AjaxResult rhzfPcTj(String wgCode) {
        Map result = this.visitPlanService.rhzfPcTj(wgCode);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/nearSevenDayTaskNum"}, method={RequestMethod.GET})
    @ResponseBody
    public String nearSevenDayTaskNum(String wgCode, String startTime) {
        List result = null;
        try {
            result = this.visitPlanService.nearSevenDayTaskNum(wgCode, startTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"\u4efb\u52a1\u6570\u91cf\u83b7\u53d6\u51fa\u9519"));
        }
        return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)result));
    }

    @RequestMapping(value={"/selectAqzfTj"}, method={RequestMethod.GET})
    @ResponseBody
    public String selectAqzfTj(String wgCode, String year, String month) {
        List result = null;
        try {
            result = this.visitPlanService.selectAqzfTj(wgCode, year + "-" + month);
            if (result.size() >= 5) {
                result = result.subList(0, 5);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"\u4efb\u52a1\u6570\u91cf\u83b7\u53d6\u51fa\u9519"));
        }
        return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)result));
    }

    @RequestMapping(value={"/planTaskInfo"}, method={RequestMethod.GET})
    public AjaxResult planTaskInfo(@RequestParam(value="id") String id) {
        VisitPlanTaskExt wszfPlanTaskExt = this.visitPlanService.planTaskInfo(id);
        return AjaxResult.success((Object)wszfPlanTaskExt);
    }

    @PostMapping(value={"/updatePlanTask"})
    public AjaxResult updatePlanTask(@RequestBody VisitPlanTaskExt wszfPlanTask) {
        this.visitPlanService.updatePlanTask(wszfPlanTask);
        return AjaxResult.success((String)"success");
    }

    @RequestMapping(value={"/countPlanTaskByUserId"}, method={RequestMethod.GET})
    public AjaxResult countPlanTaskByUserId(@RequestParam(value="userId") String userId) {
        Map result = this.visitPlanService.countPlanTaskByUserId(userId);
        return AjaxResult.success((Object)result);
    }

    @GetMapping(value={"/tj/rate"})
    public AjaxResult getPlanRate(VisitPlanRate wszfPlanRate) {
        return AjaxResult.success((Object)this.visitPlanService.getPlatRate(wszfPlanRate));
    }

    @RequestMapping(value={"/getPatrolRecordPage"}, method={RequestMethod.GET})
    public AjaxResult getPatrolRecordPage(@RequestParam(value="objId") String objId, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize) {
        PageInfo result = this.visitPlanService.getPatrolRecordPage(objId, pageNum, pageSize);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/getYhzgPage"}, method={RequestMethod.GET})
    public AjaxResult getYhzgPage(@RequestParam(value="objId") String objId, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize) {
        PageInfo result = this.visitPlanService.getYhzgPage(objId, pageNum, pageSize);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/planTaskForPage"}, method={RequestMethod.GET})
    public AjaxResult planTaskForPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="planFl") String planFl, @RequestParam(value="wgCode", required=false) String wgCode) {
        try {
            PageInfo pageInfo = this.visitPlanService.planTaskForPage(pageNum, pageSize, wgCode, planFl);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @RequestMapping(value={"/updateByPlanTask"}, method={RequestMethod.GET})
    public AjaxResult updateByPlanTask(@RequestParam(value="userId") String userId, @RequestParam(value="planTaskStatus") String planTaskStatus, @RequestParam(value="planTaskFeedback", required=false) String planTaskFeedback, @RequestParam(value="updateTime", required=false) String updateTime, @RequestParam(value="qddkdz", required=false) String qddkdz, @RequestParam(value="otherappAttachments", required=false) String otherappAttachments, @RequestParam(value="objId") String objId) {
        this.visitPlanService.updateByPlanTask(userId, planTaskStatus, planTaskFeedback, objId, updateTime, otherappAttachments, qddkdz);
        return AjaxResult.success((String)"success");
    }

    @GetMapping(value={"/visit/count"})
    public AjaxResult interviewCount(@RequestParam(value="objType") String objType, @RequestParam(value="objId") String objId) {
        return AjaxResult.success((Object)this.visitPlanService.latestVisitCount(objType, objId));
    }
}

