/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.visit;

import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.uuid.IdUtils;
import com.ruoyi.system.domain.form.MdForm;
import com.ruoyi.system.domain.grid.GridCompany;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.GridRegionUserExample;
import com.ruoyi.system.domain.visit.dr.VisitDrCheckHistory;
import com.ruoyi.system.domain.visit.dr.VisitDrCheckHistoryAttach;
import com.ruoyi.system.domain.visit.dr.VisitDrCheckHistoryAttachExample;
import com.ruoyi.system.domain.visit.dr.VisitDrCheckHistoryExample;
import com.ruoyi.system.domain.visit.dr.VisitDrCheckHistoryForm;
import com.ruoyi.system.domain.visit.dr.VisitDrCheckHistoryFormAttach;
import com.ruoyi.system.domain.visit.dr.VisitDrCheckHistoryFormAttachExample;
import com.ruoyi.system.domain.visit.dr.VisitDrCheckHistoryFormExample;
import com.ruoyi.system.domain.visit.dr.VisitDrCompanyDataPool;
import com.ruoyi.system.domain.visit.dr.VisitDrRule;
import com.ruoyi.system.domain.visit.dr.VisitDrRuleExample;
import com.ruoyi.system.domain.visit.dr.VisitDrTask;
import com.ruoyi.system.domain.visit.dr.VisitDrTaskCompany;
import com.ruoyi.system.domain.visit.dr.VisitDrTaskCompanyExample;
import com.ruoyi.system.domain.visit.dr.VisitDrTaskExample;
import com.ruoyi.system.domain.visit.dr.VisitDrTaskUser;
import com.ruoyi.system.domain.visit.dr.VisitDrTaskUserExample;
import com.ruoyi.system.domain.visit.dr.VisitDrUserDataPool;
import com.ruoyi.system.domain.visit.dr.ext.VisitDrCheckFormExt;
import com.ruoyi.system.domain.visit.dr.ext.VisitDrDetailForApp;
import com.ruoyi.system.domain.visit.dr.ext.VisitDrGroup;
import com.ruoyi.system.domain.visit.dr.ext.VisitDrMap;
import com.ruoyi.system.domain.visit.dr.params.VisitDrCheckResultParams;
import com.ruoyi.system.domain.visit.dr.params.VisitDrParamIds;
import com.ruoyi.system.mapper.visit.dr.VisitDrCompanyDataPoolMapper;
import com.ruoyi.system.mapper.visit.dr.VisitDrUserDataPoolMapper;
import com.ruoyi.system.service.form.FormManager;
import com.ruoyi.system.service.form.MdFormService;
import com.ruoyi.system.service.grid.GridCompanyService;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.other.BsCommonService;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.visit.dr.VisitDrCheckHistoryAttachService;
import com.ruoyi.system.service.visit.dr.VisitDrCheckHistoryFormAttachService;
import com.ruoyi.system.service.visit.dr.VisitDrCheckHistoryFormService;
import com.ruoyi.system.service.visit.dr.VisitDrCheckHistoryService;
import com.ruoyi.system.service.visit.dr.VisitDrRuleService;
import com.ruoyi.system.service.visit.dr.VisitDrTaskCompanyService;
import com.ruoyi.system.service.visit.dr.VisitDrTaskService;
import com.ruoyi.system.service.visit.dr.VisitDrTaskUserService;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d70\u8bbf\u7ba1\u7406 - \u53cc\u968f\u673a\u8d70\u8bbf"})
@RestController
@RequestMapping(value={"/api/visit/doubleRandom"})
public class VisitDoubleRandomController
extends BaseController {
    @Autowired
    VisitDrRuleService visitDrRuleService;
    @Autowired
    VisitDrCompanyDataPoolMapper visitDrCompanyDataPoolMapper;
    @Autowired
    VisitDrUserDataPoolMapper visitDrUserDataPoolMapper;
    @Autowired
    VisitDrTaskService visitDrTaskService;
    @Autowired
    VisitDrTaskUserService visitDrTaskUserService;
    @Autowired
    VisitDrTaskCompanyService visitDrTaskCompanyService;
    @Autowired
    VisitDrCheckHistoryService visitDrCheckHistoryService;
    @Autowired
    VisitDrCheckHistoryFormService visitDrCheckHistoryFormService;
    @Autowired
    VisitDrCheckHistoryFormAttachService visitDrCheckHistoryFormAttachService;
    @Autowired
    VisitDrCheckHistoryAttachService visitDrCheckHistoryAttachService;
    @Autowired
    VisitDrCheckHistoryAttachService attachService;
    @Autowired
    GridCompanyService gridCompanyService;
    @Autowired
    GridRegionUserService gridRegionUserService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private BsCommonService bsCommonService;
    @Autowired
    private FormManager formManager;
    @Autowired
    private MdFormService mdFormService;

    @PostMapping(value={"/addVisitDrRule"})
    public AjaxResult addVisitDrRule(@RequestBody VisitDrRule rule) {
        int addResult;
        String ruleId = IdUtils.fastSimpleUUID();
        rule.setId(ruleId);
        AjaxResult result = this.validation(rule);
        if (!result.isSuccess()) {
            return result;
        }
        AjaxResult r = this.generateCompanyDataPool(rule, ruleId);
        if (!r.isSuccess()) {
            return r;
        }
        AjaxResult re = this.generateUserDataPool(rule, ruleId);
        if (!re.isSuccess()) {
            return re;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getTemplateId())) {
            rule.setExtfieldTen(rule.getTemplateId());
            ArrayList<String> formIds = new ArrayList<String>();
            List<String> templateIds = Arrays.asList(rule.getTemplateId().split(","));
            for (String templateId : templateIds) {
                String formId = this.formManager.saveFormTemplateWithWST(templateId, rule.getCreateBy());
                formIds.add(formId);
            }
            rule.setChooseForm(StringUtils.join(formIds, (String)","));
        }
        if ((addResult = this.visitDrRuleService.insertSelective((Object)rule)) > 0) {
            return AjaxResult.success((String)"\u6dfb\u52a0\u6210\u529f", (Object)ruleId);
        }
        this.visitDrCompanyDataPoolMapper.deleteAllDataByRuleId(ruleId);
        this.visitDrUserDataPoolMapper.deleteAllDataByRuleId(ruleId);
        return AjaxResult.success();
    }

    @GetMapping(value={"/getUserAndCompany"})
    public AjaxResult getUserAndCompany(@RequestParam(value="ruleId", required=false) String ruleId) {
        VisitDrMap map = new VisitDrMap();
        GridRegionUserExample userExample = new GridRegionUserExample();
        GridRegionUserExample.Criteria ca = userExample.createCriteria();
        ca.andIsValidEqualTo("1");
        List regionUsers = this.gridRegionUserService.selectByExample((Object)userExample);
        ArrayList users = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)regionUsers)) {
            regionUsers.forEach(e -> {
                SysUser sysUser = this.sysUserService.selectUserById(e.getUserId());
                if (sysUser != null) {
                    users.add(sysUser);
                } else {
                    SysUser user = new SysUser();
                    user.setAvatar("");
                    user.setUserId(e.getUserId());
                    user.setNickName(e.getYlzd1());
                    users.add(user);
                }
            });
        }
        map.setUserList(users);
        List comList = this.gridCompanyService.selectCompanyForDoubleRandomLimit();
        map.setComList(comList);
        return AjaxResult.success((Object)map);
    }

    @GetMapping(value={"/visitDrStop"})
    public AjaxResult visitDrStop(@RequestParam(value="ruleId") String ruleId) {
        int i;
        VisitDrRule rule = (VisitDrRule)this.visitDrRuleService.selectByPrimaryKey(ruleId);
        int currentGroupNum = Integer.parseInt(rule.getChoosePeopleGroup());
        List companylist = this.visitDrCompanyDataPoolMapper.selectDataByRuleId(ruleId);
        List userlist = this.visitDrUserDataPoolMapper.selectDataByRuleId(ruleId);
        ArrayList<VisitDrGroup> groupsList = new ArrayList<VisitDrGroup>();
        int peoples = userlist.size() / currentGroupNum;
        int companys = companylist.size() / currentGroupNum;
        for (i = 0; i < currentGroupNum; ++i) {
            VisitDrGroup ssjGroup = new VisitDrGroup();
            ssjGroup.setCurrentGroup(String.valueOf(i + 1));
            ssjGroup.setCurrentGroupForms(rule.getChooseForm());
            ArrayList userGroup = new ArrayList();
            for (int j = 0; j < peoples; ++j) {
                int random = this.getRandom(userlist.size());
                userGroup.add(userlist.get(random));
                userlist.remove(random);
            }
            ssjGroup.setUerPoolList(userGroup);
            ArrayList companyGroup = new ArrayList();
            for (int j = 0; j < companys; ++j) {
                int random = this.getRandom(companylist.size());
                companyGroup.add(companylist.get(random));
                companylist.remove(random);
            }
            ssjGroup.setCompanyPoolList(companyGroup);
            groupsList.add(ssjGroup);
        }
        for (i = 0; i < userlist.size(); ++i) {
            ((VisitDrGroup)groupsList.get(i)).getUerPoolList().add(userlist.get(i));
        }
        for (i = 0; i < companylist.size(); ++i) {
            ((VisitDrGroup)groupsList.get(i)).getCompanyPoolList().add(companylist.get(i));
        }
        if (groupsList.size() > 0) {
            this.createTask(ruleId, groupsList, rule.getChooseTime(), rule);
            return AjaxResult.success(groupsList);
        }
        return AjaxResult.error((int)400, (String)"\u5206\u7ec4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
    }

    @GetMapping(value={"/tuiSong"})
    public AjaxResult tuiSong(@RequestParam(value="ruleId") String ruleId) {
        int result = 0;
        VisitDrRuleExample ruleExample = new VisitDrRuleExample();
        VisitDrRuleExample.Criteria ruleCriteria = ruleExample.createCriteria();
        ruleCriteria.andIdEqualTo(ruleId);
        VisitDrRule ruleModel = (VisitDrRule)this.visitDrRuleService.selectFirstByExample((Object)ruleExample);
        VisitDrTaskExample example = new VisitDrTaskExample();
        VisitDrTaskExample.Criteria criteria = example.createCriteria();
        criteria.andRuleIdEqualTo(ruleId);
        List list = this.visitDrTaskService.selectByExample((Object)example);
        for (VisitDrTask l : list) {
            VisitDrTaskUserExample userExample = new VisitDrTaskUserExample();
            VisitDrTaskUserExample.Criteria userCriteria = userExample.createCriteria();
            userCriteria.andTaskIdEqualTo(l.getId());
            List userList = this.visitDrTaskUserService.selectByExample((Object)userExample);
            String userIdStrs = "";
            String userNameStrs = "";
            for (int a = 0; a < userList.size(); ++a) {
                if (a == userList.size() - 1) {
                    userIdStrs = userIdStrs + ((VisitDrTaskUser)userList.get(a)).getUserId();
                    userNameStrs = userNameStrs + ((VisitDrTaskUser)userList.get(a)).getUserName();
                    continue;
                }
                userIdStrs = userIdStrs + ((VisitDrTaskUser)userList.get(a)).getUserId() + ",";
                userNameStrs = userNameStrs + ((VisitDrTaskUser)userList.get(a)).getUserName() + ",";
            }
            VisitDrTaskCompanyExample companyExample = new VisitDrTaskCompanyExample();
            VisitDrTaskCompanyExample.Criteria companyCriteria = companyExample.createCriteria();
            companyCriteria.andTaskIdEqualTo(l.getId());
            List companyList = this.visitDrTaskCompanyService.selectByExample((Object)companyExample);
            for (VisitDrTaskCompany company : companyList) {
                String[] strs;
                VisitDrCheckHistory checkHistory = new VisitDrCheckHistory();
                checkHistory.setId(IdUtils.fastSimpleUUID());
                checkHistory.setRuleId(ruleId);
                checkHistory.setTaskId(l.getId());
                checkHistory.setTitle(ruleModel.getTitle());
                checkHistory.setCompanyId(company.getCompanyId());
                checkHistory.setCompanyName(company.getCompanyName());
                checkHistory.setZhCreditLevel(company.getExtfieldOne());
                checkHistory.setChooseType(ruleModel.getChooseType());
                checkHistory.setChooseForm(ruleModel.getChooseForm());
                checkHistory.setChooseTime(ruleModel.getChooseTime());
                checkHistory.setTaskUserIds(userIdStrs);
                checkHistory.setTaskUsers(userNameStrs);
                checkHistory.setCheckUsers(userNameStrs);
                checkHistory.setCreateBy(ruleModel.getCreateBy());
                checkHistory.setCreateTime(ruleModel.getCreateTime());
                checkHistory.setExtfieldOne(company.getExtfieldTwo());
                checkHistory.setResult("\u672a\u5f00\u59cb\u68c0\u67e5");
                result += this.visitDrCheckHistoryService.insert((Object)checkHistory);
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ruleModel.getChooseForm())) continue;
                for (String fo : strs = ruleModel.getChooseForm().split(",")) {
                    VisitDrCheckHistoryForm biaodan = new VisitDrCheckHistoryForm();
                    biaodan.setId(IdUtils.fastSimpleUUID());
                    biaodan.setHistoryId(checkHistory.getId());
                    biaodan.setFormType(fo);
                    this.visitDrCheckHistoryFormService.insert((Object)biaodan);
                }
            }
        }
        if (result > 0) {
            return AjaxResult.success((String)("\u63a8\u9001\u6210\u529f,\u6210\u529f" + result + "\u6761\u6570\u636e"));
        }
        return AjaxResult.error((int)400, (String)"\u63a8\u9001\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
    }

    @GetMapping(value={"/getVisitDrTaskList"})
    public AjaxResult getVisitDrTaskList(@RequestParam(value="loginUserId", required=false) String loginUserId, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="title", required=false) String title, @RequestParam(value="checkType", required=false) String checkType, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="checkResult", required=false) String checkResult, @RequestParam(value="companyName", required=false) String companyName, @RequestParam(value="companyId", required=false) String companyId, @RequestParam(value="taskUsers", required=false) String taskUsers) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        VisitDrCheckHistoryExample checkHistoryExample = new VisitDrCheckHistoryExample();
        VisitDrCheckHistoryExample.Criteria criteria = checkHistoryExample.createCriteria();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)loginUserId)) {
            criteria.andTaskUserIdsLike("%" + loginUserId + "%");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)title)) {
            criteria.andTitleLike("%" + title + "%");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checkType)) {
            criteria.andChooseTypeEqualTo(checkType);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
            criteria.andChooseTimeBetween(startTime, endTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checkResult)) {
            if ("\u672a\u5f00\u59cb\u68c0\u67e5".equals(checkResult)) {
                criteria.andResultEqualTo(checkResult);
            } else {
                criteria.andResultNotEqualTo("\u672a\u5f00\u59cb\u68c0\u67e5");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)companyName)) {
            criteria.andCompanyNameLike("%" + companyName + "%");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)companyId)) {
            criteria.andCompanyIdEqualTo(companyId);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)taskUsers)) {
            criteria.andTaskUsersLike("%" + taskUsers + "%");
        }
        checkHistoryExample.setOrderByClause(" create_time desc");
        List list = this.visitDrCheckHistoryService.selectByExample((Object)checkHistoryExample);
        PageInfo pageInfo = new PageInfo(list);
        return AjaxResult.success((Object)pageInfo);
    }

    @GetMapping(value={"/getVisitDrTaskList_old"})
    public AjaxResult getVisitDrTaskList_old(@RequestParam(value="loginUserId", required=false) String loginUserId, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="title", required=false) String title) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        VisitDrCheckHistoryExample checkHistoryExample = new VisitDrCheckHistoryExample();
        VisitDrCheckHistoryExample.Criteria criteria = checkHistoryExample.createCriteria();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)loginUserId)) {
            criteria.andTaskUserIdsLike("%" + loginUserId + "%");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)title)) {
            criteria.andTitleLike("%" + title + "%");
        }
        checkHistoryExample.setOrderByClause(" create_time desc");
        List list = this.visitDrCheckHistoryService.selectByExample((Object)checkHistoryExample);
        PageInfo pageInfo = new PageInfo(list);
        return AjaxResult.success((Object)pageInfo);
    }

    @GetMapping(value={"/getVisitDrTaskDetail"})
    public AjaxResult getVisitDrTaskDetail(@RequestParam(value="checkId") String checkId) {
        VisitDrCheckHistory checkHistory = (VisitDrCheckHistory)this.visitDrCheckHistoryService.selectByPrimaryKey(checkId);
        VisitDrTaskUserExample userExample = new VisitDrTaskUserExample();
        VisitDrTaskUserExample.Criteria userCriteria = userExample.createCriteria();
        userCriteria.andTaskIdEqualTo(checkHistory.getTaskId());
        List userList = this.visitDrTaskUserService.selectByExample((Object)userExample);
        if (checkHistory != null) {
            checkHistory.setUserList(userList);
        }
        ArrayList<VisitDrCheckFormExt> formExtList = new ArrayList<VisitDrCheckFormExt>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checkHistory.getChooseForm())) {
            List<String> formIds = Arrays.asList(checkHistory.getChooseForm().split(","));
            for (String formId : formIds) {
                VisitDrCheckHistoryFormExample example = new VisitDrCheckHistoryFormExample();
                VisitDrCheckHistoryFormExample.Criteria criteria = example.createCriteria();
                criteria.andHistoryIdEqualTo(checkId);
                criteria.andFormTypeEqualTo(formId);
                VisitDrCheckHistoryForm form = (VisitDrCheckHistoryForm)this.visitDrCheckHistoryFormService.selectFirstByExample((Object)example);
                if (form == null) continue;
                VisitDrCheckFormExt formExt = new VisitDrCheckFormExt();
                BeanUtils.copyProperties((Object)form, (Object)formExt);
                MdForm mdForm = (MdForm)this.mdFormService.selectByPrimaryKey(formId);
                formExt.setFormName(mdForm == null ? "" : mdForm.getName());
                formExtList.add(formExt);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checkHistory.getChooseType())) {
            String name = this.bsCommonService.getName(checkHistory.getChooseType());
            checkHistory.setChooseTypeValue(name);
        }
        VisitDrCheckHistoryAttachExample attachExample = new VisitDrCheckHistoryAttachExample();
        VisitDrCheckHistoryAttachExample.Criteria attachCriter = attachExample.createCriteria();
        attachCriter.andCheckIdEqualTo(checkHistory.getId());
        List attachList = this.attachService.selectByExample((Object)attachExample);
        if (attachList.size() > 0) {
            checkHistory.setCheckHistoryAttachList(attachList);
        }
        VisitDrDetailForApp visitDrDetailForApp = new VisitDrDetailForApp();
        BeanUtils.copyProperties((Object)checkHistory, (Object)visitDrDetailForApp);
        visitDrDetailForApp.setCheckHistoryFormList(formExtList);
        return AjaxResult.success((Object)visitDrDetailForApp);
    }

    @PostMapping(value={"/submitCheckResult"})
    public AjaxResult submitCheckResult(@RequestBody VisitDrCheckResultParams checkResult) {
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checkResult.getCheckId())) {
            return AjaxResult.error((int)400, (String)"\u68c0\u67e5\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VisitDrCheckHistory checkModel = (VisitDrCheckHistory)this.visitDrCheckHistoryService.selectByPrimaryKey(checkResult.getCheckId());
        if (checkResult.getCheckHistoryAttachList() != null && checkResult.getCheckHistoryAttachList().size() > 0) {
            for (VisitDrCheckHistoryAttach checkHistoryAttach : checkResult.getCheckHistoryAttachList()) {
                checkHistoryAttach.setId(IdUtils.fastSimpleUUID());
                checkHistoryAttach.setCheckId(checkResult.getCheckId());
                checkHistoryAttach.setCreateTime(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.visitDrCheckHistoryAttachService.insert((Object)checkHistoryAttach);
            }
        }
        if (checkResult.getCheckHistoryFormList() != null && checkResult.getCheckHistoryFormList().size() > 0) {
            for (VisitDrCheckHistoryForm checkHistoryForm : checkResult.getCheckHistoryFormList()) {
                VisitDrCheckHistoryForm checkHistoryFormModel = (VisitDrCheckHistoryForm)this.visitDrCheckHistoryFormService.selectByPrimaryKey(checkHistoryForm.getId());
                checkHistoryFormModel.setCheckContent(checkHistoryForm.getCheckContent());
                checkHistoryFormModel.setCheckResult(checkHistoryForm.getCheckResult());
                checkHistoryFormModel.setRemark(checkHistoryForm.getRemark());
                this.visitDrCheckHistoryFormService.updateByPrimaryKey((Object)checkHistoryFormModel);
                if (checkHistoryForm.getAttaches() == null || checkHistoryForm.getAttaches().size() <= 0) continue;
                for (VisitDrCheckHistoryFormAttach formAttach : checkHistoryForm.getAttaches()) {
                    formAttach.setId(IdUtils.fastSimpleUUID());
                    formAttach.setFormTypeId(checkHistoryForm.getId());
                    formAttach.setCreateTime(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                    this.visitDrCheckHistoryFormAttachService.insert((Object)formAttach);
                }
            }
        }
        checkModel.setCheckedObject(checkResult.getCheckedObject());
        checkModel.setTelephone(checkResult.getTelephone());
        checkModel.setAddress(checkResult.getAddress());
        checkModel.setCheckUsers(checkResult.getCheckUsers());
        checkModel.setCheckTime(checkResult.getCheckTime());
        checkModel.setExtfieldTwo(checkResult.getExtfieldTwo());
        checkModel.setExtfieldThree(checkResult.getExtfieldThree());
        checkModel.setExtfieldFour(checkResult.getExtfieldFour());
        checkModel.setResult(checkResult.getResult());
        checkModel.setExtfieldFive(checkResult.getExtfieldFive());
        this.visitDrCheckHistoryService.updateByPrimaryKey((Object)checkModel);
        return AjaxResult.success();
    }

    @RequestMapping(value={"delVisitDrRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult delVisitDrRecord(@RequestBody VisitDrParamIds paramIds) {
        try {
            int a = this.visitDrCheckHistoryService.deleteByPrimaryKeys(paramIds.getIds());
            for (String id : paramIds.getIds()) {
                VisitDrCheckHistoryAttachExample example1 = new VisitDrCheckHistoryAttachExample();
                VisitDrCheckHistoryAttachExample.Criteria criteria1 = example1.createCriteria();
                criteria1.andCheckIdEqualTo(id);
                this.visitDrCheckHistoryAttachService.deleteByExample((Object)example1);
                VisitDrCheckHistoryFormExample example2 = new VisitDrCheckHistoryFormExample();
                VisitDrCheckHistoryFormExample.Criteria criteria2 = example2.createCriteria();
                criteria2.andHistoryIdEqualTo(id);
                List lists = this.visitDrCheckHistoryFormService.selectByExample((Object)example2);
                this.visitDrCheckHistoryFormService.deleteByExample((Object)example2);
                if (lists == null || lists.size() <= 0) continue;
                for (VisitDrCheckHistoryForm list : lists) {
                    VisitDrCheckHistoryFormAttachExample example3 = new VisitDrCheckHistoryFormAttachExample();
                    VisitDrCheckHistoryFormAttachExample.Criteria criteria3 = example3.createCriteria();
                    criteria3.andFormTypeIdEqualTo(list.getId());
                    this.visitDrCheckHistoryFormAttachService.deleteByExample((Object)example3);
                }
            }
            if (a > 0) {
                return AjaxResult.success((String)"\u5220\u9664\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
        return AjaxResult.error((int)500, (String)"\u5220\u9664\u5931\u8d25");
    }

    private void createTask(String ruleId, List<VisitDrGroup> groupsList, String time, VisitDrRule rule) {
        for (VisitDrGroup group : groupsList) {
            VisitDrTask task = new VisitDrTask();
            String taskId = IdUtils.fastSimpleUUID();
            task.setId(taskId);
            task.setRuleId(ruleId);
            task.setGroupNum(group.getCurrentGroup());
            task.setCreateTime(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
            task.setIsCheck("0");
            task.setIsValid("0");
            task.setCheckTime(time);
            task.setCreateBy(rule.getCreateBy());
            task.setCreateTime(rule.getCreateTime());
            for (VisitDrUserDataPool user : group.getUerPoolList()) {
                VisitDrTaskUser ssjTaskUser = new VisitDrTaskUser();
                ssjTaskUser.setId(IdUtils.fastSimpleUUID());
                ssjTaskUser.setTaskId(taskId);
                ssjTaskUser.setUserId(user.getUserId());
                ssjTaskUser.setUserName(user.getUserName());
                ssjTaskUser.setUserCode(user.getUserCode());
                ssjTaskUser.setUserImg(user.getUserImg());
                ssjTaskUser.setAddTime(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.visitDrTaskUserService.insert((Object)ssjTaskUser);
            }
            for (VisitDrCompanyDataPool company : group.getCompanyPoolList()) {
                VisitDrTaskCompany ssjTaskCompany = new VisitDrTaskCompany();
                ssjTaskCompany.setId(IdUtils.fastSimpleUUID());
                ssjTaskCompany.setTaskId(taskId);
                ssjTaskCompany.setCompanyId(company.getCompanyId());
                ssjTaskCompany.setCompanyName(company.getCompanyName());
                ssjTaskCompany.setExtfieldOne(company.getExtfieldOne());
                ssjTaskCompany.setExtfieldTwo(company.getExtfieldTwo());
                ssjTaskCompany.setAddTime(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.visitDrTaskCompanyService.insert((Object)ssjTaskCompany);
            }
            this.visitDrTaskService.insert((Object)task);
            this.visitDrCompanyDataPoolMapper.deleteAllDataByRuleId(ruleId);
            this.visitDrUserDataPoolMapper.deleteAllDataByRuleId(ruleId);
        }
    }

    private int getRandom(int i) {
        Random r = new Random();
        return r.nextInt(i);
    }

    private AjaxResult generateCompanyDataPool(VisitDrRule rule, String ruleId) {
        this.visitDrCompanyDataPoolMapper.deleteAllDataByRuleId(ruleId);
        List list = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getChooseCompanyType())) {
            this.doRandom(rule, list);
        } else {
            list = this.gridCompanyService.selectByRandom(Integer.parseInt(rule.getChooseCompanyNum()), null);
        }
        if (list.size() != Integer.parseInt(rule.getChooseCompanyNum())) {
            for (int i = 0; i <= 20; ++i) {
                list.clear();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getChooseCompanyType())) {
                    this.doRandom(rule, list);
                    continue;
                }
                list = this.gridCompanyService.selectByRandom(Integer.parseInt(rule.getChooseCompanyNum()), null);
                if (list.size() >= Integer.parseInt(rule.getChooseCompanyNum())) break;
            }
        }
        if (list.size() < Integer.parseInt(rule.getChooseCompanyNum())) {
            return AjaxResult.error((int)400, (String)"\u7b26\u5408\u6761\u4ef6\u7684\u4f01\u4e1a\u5c0f\u4e8e\u62bd\u53d6\u4f01\u4e1a\u6570\u91cf");
        }
        for (GridCompany company : list) {
            VisitDrCompanyDataPool dataPool = new VisitDrCompanyDataPool();
            dataPool.setId(IdUtils.fastSimpleUUID());
            dataPool.setRuleId(ruleId);
            dataPool.setCompanyId(company.getId());
            dataPool.setCompanyName(company.getCompanyName());
            dataPool.setExtfieldTwo(company.getCreditCode());
            this.visitDrCompanyDataPoolMapper.insert(dataPool);
        }
        return AjaxResult.success();
    }

    private void doRandom(VisitDrRule rule, List<GridCompany> list) {
        String[] typeStringList;
        for (String chooseType : typeStringList = rule.getChooseCompanyType().split(",")) {
            List listTemp = this.gridCompanyService.selectByRandom(Integer.parseInt(rule.getChooseCompanyNum()) - list.size(), chooseType);
            list.addAll(listTemp);
            if (list.size() >= Integer.parseInt(rule.getChooseCompanyNum())) break;
        }
    }

    private AjaxResult generateUserDataPool(VisitDrRule rule, String ruleId) {
        this.visitDrUserDataPoolMapper.deleteAllDataByRuleId(ruleId);
        List list = this.gridRegionUserService.selectRandom(Integer.parseInt(rule.getChoosePeopleNum()));
        if (list.size() < Integer.parseInt(rule.getChoosePeopleNum())) {
            this.visitDrCompanyDataPoolMapper.deleteAllDataByRuleId(ruleId);
            return AjaxResult.build((int)400, (String)"\u7b26\u5408\u6761\u4ef6\u7684\u6267\u6cd5\u4eba\u5458\u5c0f\u4e8e\u62bd\u53d6\u6267\u6cd5\u4eba\u5458\u6570\u91cf");
        }
        for (GridRegionUser user : list) {
            SysUser sysUser = this.sysUserService.selectUserById(user.getUserId());
            VisitDrUserDataPool dataPool = new VisitDrUserDataPool();
            dataPool.setId(IdUtils.fastSimpleUUID());
            dataPool.setRuleId(ruleId);
            dataPool.setUserCode(user.getUserId());
            dataPool.setUserId(user.getUserId());
            dataPool.setUserImg(sysUser != null ? sysUser.getAvatar() : "");
            dataPool.setUserName(user.getYlzd1());
            this.visitDrUserDataPoolMapper.insert(dataPool);
        }
        return AjaxResult.success();
    }

    private AjaxResult validation(VisitDrRule rule) {
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getTitle())) {
            return AjaxResult.error((int)400, (String)"\u8bf7\u8f93\u5165\u6807\u9898");
        }
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getChoosePeopleNum())) {
            return AjaxResult.error((int)400, (String)"\u6267\u6cd5\u4eba\u5458\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GridRegionUserExample userExample = new GridRegionUserExample();
        GridRegionUserExample.Criteria ca = userExample.createCriteria();
        ca.andIsValidEqualTo("1");
        int userCount = this.gridRegionUserService.countByExample((Object)userExample);
        if (Integer.parseInt(rule.getChoosePeopleNum()) > userCount) {
            return AjaxResult.build((int)400, (String)"\u8f93\u5165\u7684\u6267\u6cd5\u4eba\u5458\u6570\u5927\u4e8e\u7b26\u5408\u6761\u4ef6\u7684\u6267\u6cd5\u4eba\u5458\u6570");
        }
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getChoosePeopleGroup())) {
            return AjaxResult.error((int)400, (String)"\u7ec4\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Integer.parseInt(rule.getChoosePeopleGroup()) > Integer.parseInt(rule.getChoosePeopleNum())) {
            return AjaxResult.error((int)400, (String)"\u7ec4\u6570\u4e0d\u80fd\u5927\u4e8e\u6267\u6cd5\u4eba\u5458\u6570");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getIsChooseCreditRatio()) && rule.getIsChooseCreditRatio().equals("1")) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getCreditA())) {
                return AjaxResult.error((int)400, (String)"\u7efc\u5408\u4fe1\u7528\u6bd4\u4f8b\u4e3aA\u7684\u767e\u5206\u6bd4\u503c\u53ef\u4ee5\u4e3a0,\u4f46\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getCreditB())) {
                return AjaxResult.error((int)400, (String)"\u7efc\u5408\u4fe1\u7528\u6bd4\u4f8b\u4e3aA\u7684\u767e\u5206\u6bd4\u503c\u53ef\u4ee5\u4e3a0,\u4f46\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getCreditC())) {
                return AjaxResult.error((int)400, (String)"\u7efc\u5408\u4fe1\u7528\u6bd4\u4f8b\u4e3aA\u7684\u767e\u5206\u6bd4\u503c\u53ef\u4ee5\u4e3a0,\u4f46\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getCreditD())) {
                return AjaxResult.error((int)400, (String)"\u7efc\u5408\u4fe1\u7528\u6bd4\u4f8b\u4e3aA\u7684\u767e\u5206\u6bd4\u503c\u53ef\u4ee5\u4e3a0,\u4f46\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Integer.parseInt(rule.getCreditA()) + Integer.parseInt(rule.getCreditB()) + Integer.parseInt(rule.getCreditC()) + Integer.parseInt(rule.getCreditD()) != 100) {
                return AjaxResult.error((int)400, (String)"\u7efc\u5408\u4fe1\u7528\u6bd4\u4f8b\u4e3aABCD\u7684\u767e\u5206\u6bd4\u503c\u76f8\u52a0\u8981\u4e3a100");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rule.getChooseCompanyNum())) {
            return AjaxResult.error((int)400, (String)"\u62bd\u67e5\u4f01\u4e1a\u5bf9\u8c61\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Integer.parseInt(rule.getChooseCompanyNum()) < Integer.parseInt(rule.getChoosePeopleGroup())) {
            return AjaxResult.error((int)400, (String)"\u62bd\u67e5\u4f01\u4e1a\u5bf9\u8c61\u6570\u4e0d\u80fd\u5c0f\u4e8e\u5206\u7ec4\u6570");
        }
        return AjaxResult.success();
    }

    @GetMapping(value={"/app/checkStatistics"})
    public AjaxResult getAppCheckStatistics(@RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate) {
        LoginUser sysUser = this.getLoginUser();
        VisitDrCheckHistoryExample checkHistoryExample = new VisitDrCheckHistoryExample();
        VisitDrCheckHistoryExample.Criteria criteria = checkHistoryExample.createCriteria();
        criteria.andCheckUsersLike("%" + sysUser.getUser().getNickName() + "%");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startDate)) {
            criteria.andChooseTimeBetween(startDate, endDate);
        }
        int all = this.visitDrCheckHistoryService.countByExample((Object)checkHistoryExample);
        criteria.andResultNotEqualTo("\u672a\u5f00\u59cb\u68c0\u67e5");
        int done = this.visitDrCheckHistoryService.countByExample((Object)checkHistoryExample);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("all", all);
        map.put("done", done);
        return AjaxResult.success(map);
    }
}

