/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.video;

import cn.hutool.core.util.IdUtil;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.video.VideoDeviceChannel;
import com.ruoyi.system.domain.video.VideoDeviceInfo;
import com.ruoyi.system.domain.video.ext.DevicePageRequest;
import com.ruoyi.system.domain.video.ext.DevicePageResponse;
import com.ruoyi.system.domain.video.ext.HlsUrlRequest;
import com.ruoyi.system.domain.video.ext.HlsUrlResponse;
import com.ruoyi.system.service.video.IccCutPicService;
import com.ruoyi.system.service.video.IccInfoService;
import com.ruoyi.system.service.video.IccPreviewService;
import com.ruoyi.system.service.video.IccTokenService;
import com.ruoyi.system.service.video.VideoDeviceChannelService;
import com.ruoyi.system.service.video.VideoDeviceInfoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/video/data"})
public class IccInfoController {
    @Autowired
    private VideoDeviceChannelService videoDeviceChannelService;
    @Autowired
    private VideoDeviceInfoService videoDeviceInfoService;
    @Autowired
    private IccTokenService iccTokenService;
    @Autowired
    private IccPreviewService iccPreview;
    @Autowired
    private IccCutPicService iccCutPic;
    @Autowired
    private IccInfoService iccInfo;

    @RequestMapping(value={"/info"})
    public AjaxResult getDevicePage(DevicePageRequest devicePageRequest) {
        DevicePageResponse devicePageResponse = this.iccInfo.getDevicePage(devicePageRequest);
        List data = devicePageResponse.getData().getPageData();
        for (int i = 0; i < data.size(); ++i) {
            DevicePageResponse.PageVO.DeviceInfoVO deviceInfoVO = (DevicePageResponse.PageVO.DeviceInfoVO)data.get(i);
            VideoDeviceInfo videoDeviceInfo = new VideoDeviceInfo();
            String deviceId = IdUtil.simpleUUID();
            videoDeviceInfo.setDeviceId(deviceId);
            videoDeviceInfo.setDeviceName(deviceInfoVO.getDeviceName());
            videoDeviceInfo.setDeviceCode(deviceInfoVO.getDeviceCode());
            videoDeviceInfo.setDeviceIp(deviceInfoVO.getDeviceIp());
            videoDeviceInfo.setDevicePort(deviceInfoVO.getDevicePort());
            this.videoDeviceInfoService.InsertVideoDeviceInfo(videoDeviceInfo);
            List channel = ((DevicePageResponse.PageVO.DeviceInfoVO.UnitVO)((DevicePageResponse.PageVO.DeviceInfoVO)data.get(i)).getUnits().get(0)).getChannels();
            for (int j = 0; j < channel.size(); ++j) {
                DevicePageResponse.PageVO.DeviceInfoVO.UnitVO.ChannelVO channelVO = (DevicePageResponse.PageVO.DeviceInfoVO.UnitVO.ChannelVO)channel.get(j);
                VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
                videoDeviceChannel.setChannelCode(channelVO.getChannelCode());
                videoDeviceChannel.setChannelName(channelVO.getChannelName());
                videoDeviceChannel.setChannelSeq(channelVO.getChannelSeq());
                videoDeviceChannel.setChannelSn(channelVO.getChannelSn());
                videoDeviceChannel.setChannelType(channelVO.getChannelType());
                videoDeviceChannel.setCapability(channelVO.getCapability());
                videoDeviceChannel.setParentId(deviceId);
                videoDeviceChannel.setChannelId(IdUtil.simpleUUID());
                this.videoDeviceChannelService.InsertVideoDeviceChannel(videoDeviceChannel);
            }
        }
        return AjaxResult.success((Object)devicePageResponse);
    }

    @RequestMapping(value={"/update"})
    public AjaxResult updateInfo() throws Exception {
        VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
        List videoDeviceChannelList = this.videoDeviceChannelService.selectVideoDeviceChannelList(videoDeviceChannel);
        String code = "";
        String url = "";
        String img = "";
        for (int i = 0; i < videoDeviceChannelList.size(); ++i) {
            code = ((VideoDeviceChannel)videoDeviceChannelList.get(i)).getChannelCode();
            HlsUrlRequest hlsUrlRequest = new HlsUrlRequest();
            hlsUrlRequest.setData(new HlsUrlRequest.Data());
            hlsUrlRequest.getData().setChannelId(code);
            hlsUrlRequest.getData().setType("hls");
            hlsUrlRequest.getData().setStreamType("1");
            HlsUrlResponse hlsUrlResponse = this.iccPreview.getHlsUrl(hlsUrlRequest);
            hlsUrlRequest.getData().setStreamType("2");
            url = hlsUrlResponse.getData().getUrl() + "?token=" + this.iccTokenService.getToken();
            img = this.iccCutPic.remoteCapture(Long.valueOf(2L), code);
            VideoDeviceChannel videoDeviceChannel1 = new VideoDeviceChannel();
            videoDeviceChannel1.setChannelCode(code);
            videoDeviceChannel1.setUrl(url);
            videoDeviceChannel1.setImg(img);
            this.videoDeviceChannelService.UpdateVideoDeviceChannel(videoDeviceChannel1);
        }
        return AjaxResult.success();
    }
}

