/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.video;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.system.domain.video.VideoDeviceChannel;
import com.ruoyi.system.domain.video.ext.ChannelCount;
import com.ruoyi.system.domain.video.ext.Position;
import com.ruoyi.system.service.video.VideoDeviceChannelService;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/video"})
public class IccController
extends BaseController {
    @Autowired
    VideoDeviceChannelService videoDeviceChannelService;

    @GetMapping(value={"/list"})
    public AjaxResult getList(String name, String type) {
        VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
        videoDeviceChannel.setChannelName(name);
        videoDeviceChannel.setType(type);
        List res = this.videoDeviceChannelService.selectVideoDeviceChannelList(videoDeviceChannel);
        return AjaxResult.success((Object)res);
    }

    @GetMapping(value={"/url"})
    public TableDataInfo getVideoList(String name, String type, String status) {
        this.startPage();
        VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
        videoDeviceChannel.setChannelName(name);
        videoDeviceChannel.setType(type);
        videoDeviceChannel.setStatus(status);
        List res = this.videoDeviceChannelService.selectChannelList(videoDeviceChannel);
        return this.getDataTable(res);
    }

    @PostMapping(value={"/update"})
    public AjaxResult updateName(@RequestBody VideoDeviceChannel videoDeviceChannel) {
        this.videoDeviceChannelService.UpdateVideoDeviceChannel(videoDeviceChannel);
        return AjaxResult.success();
    }

    @GetMapping(value={"/count"})
    public AjaxResult getVideoCount(String type) {
        ChannelCount count = new ChannelCount();
        int online = this.videoDeviceChannelService.getVideoCount(type);
        int all = this.videoDeviceChannelService.getCount(type);
        count.setOnline(Integer.valueOf(online));
        count.setOffline(Integer.valueOf(all - online));
        return AjaxResult.success((Object)count);
    }

    @GetMapping(value={"/token"})
    public AjaxResult getVideoToken() throws Exception {
        String token = this.videoDeviceChannelService.getVideoToken();
        return AjaxResult.success((String)token);
    }

    @PostMapping(value={"/position"})
    public AjaxResult getVideoPosition(@RequestBody Position position) {
        int i;
        List<String> list = Arrays.asList(position.getIds());
        int[] index_now = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            int position_now;
            String channelId = list.get(i);
            index_now[i] = position_now = this.videoDeviceChannelService.positionById(channelId);
        }
        Arrays.sort(index_now);
        for (i = 0; i < list.size(); ++i) {
            this.videoDeviceChannelService.position(list.get(i), index_now[i]);
        }
        return AjaxResult.success();
    }
}

