/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.task;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.DateUtil;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.task.TkRoundMatter;
import com.ruoyi.system.domain.task.TkRoundMatterExample;
import com.ruoyi.system.domain.task.TkRoundPlan;
import com.ruoyi.system.domain.task.TkRoundPlanExample;
import com.ruoyi.system.domain.task.TkRoundSubtask;
import com.ruoyi.system.domain.task.TkRoundSubtaskExample;
import com.ruoyi.system.domain.task.TkRoundTask;
import com.ruoyi.system.domain.task.TkRoundTaskExample;
import com.ruoyi.system.domain.task.utils.WorkMSGUtils;
import com.ruoyi.system.service.task.DiyService;
import com.ruoyi.system.service.task.TkCommonTaskService;
import com.ruoyi.system.service.task.TkRoundMatterService;
import com.ruoyi.system.service.task.TkRoundPlanService;
import com.ruoyi.system.service.task.TkRoundSubtaskService;
import com.ruoyi.system.service.task.TkRoundTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5de5\u5355 \u5de1\u67e5 \u4efb\u52a1"})
@RestController
@RequestMapping(value={"/api/task/roundTask"})
public class RoundTaskController {
    @Autowired
    TkRoundTaskService tkRoundTaskService;
    @Autowired
    TkRoundSubtaskService tkRoundSubtaskService;
    @Autowired
    TkRoundPlanService tkRoundPlanService;
    @Autowired
    TkRoundMatterService tkRoundMatterService;
    @Autowired
    DiyService diyService;
    @Autowired
    TkCommonTaskService tkCommonTaskService;
    @Autowired
    private WorkMSGUtils workMSGUtils;

    @ApiOperation(value="\u6bcf\u65e5\u5de1\u67e5\u7edf\u8ba1")
    @RequestMapping(value={"statistics"}, method={RequestMethod.GET})
    @ResponseBody
    public String endTask(String matterId, String matterName, String date) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        List totalPlanList = new ArrayList();
        ArrayList mapList = new ArrayList();
        try {
            List third = this.diyService.getThird();
            ArrayList<String> wgNames = new ArrayList<String>();
            HashSet<String> haveDateWgNames = new HashSet<String>();
            for (GridRegion bsWgxxb : third) {
                wgNames.add(bsWgxxb.getWgName());
            }
            TkRoundSubtaskExample subtaskExample = new TkRoundSubtaskExample();
            TkRoundSubtaskExample.Criteria criteria1 = subtaskExample.createCriteria();
            ArrayList<String> gridIds = new ArrayList<String>();
            for (GridRegion bsWgxxb : third) {
                gridIds.add(bsWgxxb.getWgCode());
            }
            criteria1.andGridIdIn(gridIds);
            List subtasks = this.tkRoundSubtaskService.selectByExample((Object)subtaskExample);
            ArrayList<String> taskIds = new ArrayList<String>();
            if (subtasks != null && subtasks.size() > 0) {
                for (TkRoundSubtask subtask : subtasks) {
                    taskIds.add(subtask.getTaskId());
                }
                TkRoundTaskExample taskExample = new TkRoundTaskExample();
                TkRoundTaskExample.Criteria criteria2 = taskExample.createCriteria();
                criteria2.andIdIn(taskIds);
                List tasks = this.tkRoundTaskService.selectByExample((Object)taskExample);
                ArrayList<String> planIds = new ArrayList<String>();
                if (tasks != null && tasks.size() > 0) {
                    List tkRoundPlanList;
                    for (TkRoundTask task : tasks) {
                        planIds.add(task.getRoundPlanId());
                    }
                    TkRoundPlanExample example = new TkRoundPlanExample();
                    TkRoundPlanExample.Criteria criteria = example.createCriteria();
                    criteria.andPeriodTypeEqualTo("4");
                    criteria.andIdIn(planIds);
                    totalPlanList = this.tkRoundPlanService.selectByExample((Object)example);
                    if (StringUtils.isNotBlank((String)date)) {
                        criteria.andEndDateEqualTo(DateUtil.getDate((String)date, (String)"yyyy-MM-dd"));
                    } else {
                        criteria.andEndDateEqualTo(new Date());
                    }
                    if (StringUtils.isNotBlank((String)matterName)) {
                        criteria.andMatterNameLike("%" + matterName + "%");
                    }
                    if ((tkRoundPlanList = this.tkRoundPlanService.selectByExample((Object)example)) != null && tkRoundPlanList.size() > 0) {
                        for (TkRoundPlan tkRoundPlan : tkRoundPlanList) {
                            String wgName = this.getWgName(tkRoundPlan.getId());
                            haveDateWgNames.add(wgName);
                            if (result.get(wgName) == null) {
                                result.put(wgName, 1);
                                continue;
                            }
                            result.put(wgName, Integer.parseInt(result.get(wgName).toString()) + 1);
                        }
                        wgNames.removeAll(haveDateWgNames);
                    }
                }
            }
            for (String wgName : wgNames) {
                result.put(wgName, 0);
            }
            int done = haveDateWgNames.size();
            int todo = wgNames.size();
            map.put("total", Integer.valueOf(third.size()));
            map.put("done", Integer.valueOf(done));
            map.put("todo", Integer.valueOf(todo));
            for (String s : result.keySet()) {
                HashMap<String, Object> wg = new HashMap<String, Object>();
                wg.put("wgName", s);
                wg.put("doNum", result.get(s));
                wg.put("done", Integer.parseInt(result.get(s).toString()) != 0);
                mapList.add(wg);
            }
            map.put("result", mapList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.build((int)500, (String)"fail", (String)"\u67e5\u8be2\u5931\u8d25"));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", map));
    }

    private String getWgName(String planId) {
        TkRoundTaskExample example = new TkRoundTaskExample();
        TkRoundTaskExample.Criteria criteria = example.createCriteria();
        criteria.andRoundPlanIdEqualTo(planId);
        List tkRoundTasks = this.tkRoundTaskService.selectByExample((Object)example);
        TkRoundMatterExample matterExample = new TkRoundMatterExample();
        TkRoundMatterExample.Criteria criteria1 = matterExample.createCriteria();
        criteria1.andSubTaskIdEqualTo(((TkRoundTask)tkRoundTasks.get(0)).getId());
        List tkRoundMatters = this.tkRoundMatterService.selectByExample((Object)matterExample);
        return ((TkRoundMatter)tkRoundMatters.get(0)).getStandby3();
    }

    @ApiOperation(value="\u7ed3\u675f\u65e5\u5e38\u5de1\u67e5")
    @RequestMapping(value={"endTask"}, method={RequestMethod.POST})
    @ResponseBody
    public String endTask(@RequestBody Map<String, Object> map) {
        try {
            TkRoundTask tkRoundTask = (TkRoundTask)this.tkRoundTaskService.selectByPrimaryKey(map.get("taskId").toString());
            tkRoundTask.setStatus("2");
            tkRoundTask.setPercent(Integer.valueOf(100));
            this.tkRoundTaskService.updateByPrimaryKey((Object)tkRoundTask);
            TkRoundPlan tkRoundPlan = (TkRoundPlan)this.tkRoundPlanService.selectByPrimaryKey(tkRoundTask.getRoundPlanId());
            tkRoundPlan.setEndDate(new Date());
            this.tkRoundPlanService.updateByPrimaryKey((Object)tkRoundPlan);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return JSON.toJSONString((Object)AjaxResult.build((int)500, (String)"fail", (String)"\u7ed3\u675f\u5931\u8d25"));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success"));
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @GetMapping
    @ResponseBody
    public String getList(@RequestParam(required=false, value="pageNum", defaultValue="1") int pageNum, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false, value="objId") String objId, @RequestParam(required=false, value="origin") String origin, @RequestParam(required=false, value="status") String status, @RequestParam(required=false, value="loginUserRole") String loginUserRole, @RequestParam(required=false, value="userId") String userId, @RequestParam(required=false, value="time") String time, @RequestParam(required=false, value="startDate") String startDate, @RequestParam(required=false, value="endDate") String endDate, @RequestParam(required=false, value="currentMonth") Integer currentMonth, @RequestParam(required=false, value="name") String name) {
        Date time2;
        TkRoundSubtaskExample.Criteria criteria;
        ArrayList taskIdsList = new ArrayList();
        if (StringUtils.isNotBlank((String)objId)) {
            TkRoundSubtaskExample example = new TkRoundSubtaskExample();
            criteria = example.createCriteria();
            criteria.andObjIdEqualTo(objId);
            List subtasks = this.tkRoundSubtaskService.selectByExample((Object)example);
            HashSet<String> taskIds = new HashSet<String>();
            for (TkRoundSubtask subtask : subtasks) {
                taskIds.add(subtask.getTaskId());
            }
            taskIdsList = new ArrayList(taskIds);
        }
        TkRoundTaskExample tkRoundTaskExample = new TkRoundTaskExample();
        criteria = tkRoundTaskExample.createCriteria();
        tkRoundTaskExample.setOrderByClause("time desc");
        criteria.andIsShowEqualTo("1");
        if (time != null) {
            time2 = DateUtil.getDate((String)time, (String)"yyyy-MM-dd");
            criteria.andTimeEqualTo(time2);
        }
        if (startDate != null) {
            time2 = DateUtil.getDate((String)startDate, (String)"yyyy-MM-dd");
            criteria.andTimeGreaterThanOrEqualTo(time2);
        }
        if (endDate != null) {
            time2 = DateUtil.getDate((String)endDate, (String)"yyyy-MM-dd");
            criteria.andTimeLessThanOrEqualTo(time2);
        }
        if (taskIdsList.size() > 0) {
            criteria.andIdIn(taskIdsList);
        }
        if (StringUtils.isNotBlank((String)origin)) {
            criteria.andOriginLike("%" + origin + "%");
        }
        if (StringUtils.isNotBlank((String)status)) {
            criteria.andStatusLike("%" + status + "%");
        }
        if (StringUtils.isNotBlank((String)name)) {
            criteria.andNameLike("%" + name + "%");
        }
        if (currentMonth != null && currentMonth == 1) {
            criteria.andTimeGreaterThanOrEqualTo(this.getFirstDayByMonth(0));
            criteria.andTimeLessThan(this.getFirstDayByMonth(1));
        }
        if (StringUtils.isNotBlank((String)loginUserRole) && (loginUserRole.equals("centerman") || loginUserRole.startsWith("one"))) {
            System.out.println("\u4e2d\u5fc3\u6216\u8005\u4e00\u7ea7\u7f51\u683c\u770b\u89c1\u6240\u6709 ");
        } else if (StringUtils.isNotBlank((String)userId)) {
            criteria.andUserIdsLike("%" + userId + "%");
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List tkRoundTaskList = this.tkRoundTaskService.selectByExampleWithBLOBs((Object)tkRoundTaskExample);
        for (TkRoundTask tkRoundTask : tkRoundTaskList) {
            TkRoundPlan tkRoundPlan = (TkRoundPlan)this.tkRoundPlanService.selectByPrimaryKey(tkRoundTask.getRoundPlanId());
            if (tkRoundPlan == null) continue;
            tkRoundTask.setPeriodType(tkRoundPlan.getPeriodType());
            tkRoundTask.setMatterId(tkRoundPlan.getMatterId());
            tkRoundTask.setMatterName(tkRoundPlan.getMatterName());
            tkRoundTask.setTime(tkRoundPlan.getStartDate());
            tkRoundTask.setEndTime(tkRoundPlan.getEndDate());
        }
        int recordCount = this.tkRoundTaskService.countByExample((Object)tkRoundTaskExample);
        ZQTPageModel zqtongPageListResult = new ZQTPageModel();
        zqtongPageListResult.setItemList(tkRoundTaskList);
        zqtongPageListResult.setCurPage(recordCount == 0 ? 0L : (long)pageNum);
        int totalPageNum = (recordCount + pageSize - 1) / pageSize;
        zqtongPageListResult.setPageCount((long)totalPageNum);
        zqtongPageListResult.setRecordCount((long)recordCount);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)zqtongPageListResult));
    }

    public Date getFirstDayByMonth(int monthLater) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, monthLater);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    @ApiOperation(value="\u4efb\u52a1\u8be6\u60c5")
    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getById(@RequestParam(required=false, value="pageNum", defaultValue="1") int pageNum, @RequestParam(required=false, value="pageSize", defaultValue="5") int pageSize, @RequestParam(required=false, value="loginUserRole") String loginUserRole, @RequestParam(required=false, value="subGridCodes") String subGridCodes, @RequestParam(required=false, value="gridCode") String gridCode, @PathVariable String id) {
        TkRoundTask tkRoundTask = (TkRoundTask)this.tkRoundTaskService.selectByPrimaryKey(id);
        TkRoundPlan tkRoundPlan = (TkRoundPlan)this.tkRoundPlanService.selectByPrimaryKey(tkRoundTask.getRoundPlanId());
        tkRoundTask.setPeriodType(tkRoundPlan.getPeriodType());
        tkRoundTask.setMatterId(tkRoundPlan.getMatterId());
        tkRoundTask.setMatterName(tkRoundPlan.getMatterName());
        TkRoundSubtaskExample tkRoundSubtaskExample = new TkRoundSubtaskExample();
        TkRoundSubtaskExample.Criteria criteria = tkRoundSubtaskExample.createCriteria();
        tkRoundSubtaskExample.setOrderByClause("time");
        if (tkRoundTask == null) {
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u672a\u67e5\u8be2\u5230\u5de1\u67e5\u4efb\u52a1\uff01"));
        }
        criteria.andTaskIdEqualTo(tkRoundTask.getId());
        if (StringUtils.isNotBlank((String)loginUserRole)) {
            if (loginUserRole.equals("centerman") || loginUserRole.startsWith("one")) {
                System.out.println("\u4e2d\u5fc3\u6216\u8005\u4e00\u7ea7\u7f51\u683c\u770b\u89c1\u6240\u6709\u8be6\u60c5 centerman\uff1a\u4e2d\u5fc3\uff1bone\uff1a\u4e00\u7ea7");
            } else if (loginUserRole.startsWith("two")) {
                if (StringUtils.isBlank((String)subGridCodes)) {
                    System.out.println("\u7c97\u95ee\u9898\u4e86\uff1a\u4e8c\u7ea7\u7f51\u683c\u8981\u770b\u89c1\u5b50\u5730\u5757   subGridCodes\u4e0d\u80fd\u4e3a\u7a7a!!!");
                } else {
                    String[] subIds = subGridCodes.split(",");
                    List<String> gridCodes = Arrays.asList(subIds);
                    criteria.andGridIdIn(gridCodes);
                }
            } else if (loginUserRole.startsWith("three") && StringUtils.isNotBlank((String)gridCode)) {
                criteria.andGridIdEqualTo(gridCode);
            }
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List tkRoundSubtaskList = this.tkRoundSubtaskService.selectByExample((Object)tkRoundSubtaskExample);
        int recordCount = this.tkRoundSubtaskService.countByExample((Object)tkRoundSubtaskExample);
        int totalPageNum = (recordCount + pageSize - 1) / pageSize;
        HashMap<String, Object> result = new HashMap<String, Object>();
        tkRoundTask.setObjName(tkRoundPlan.getObjNames());
        tkRoundTask.setCreateName(tkRoundPlan.getCreateName());
        TkRoundMatterExample example = new TkRoundMatterExample();
        TkRoundMatterExample.Criteria criteria1 = example.createCriteria();
        criteria1.andSubTaskIdEqualTo(tkRoundTask.getId());
        List tkRoundMatters = this.tkRoundMatterService.selectByExample((Object)example);
        if (tkRoundMatters.size() > 0) {
            tkRoundTask.setStandby3(((TkRoundMatter)tkRoundMatters.get(0)).getStandby3());
        }
        tkRoundTask.setEndTime(tkRoundPlan.getEndDate());
        result.put("task", tkRoundTask);
        result.put("subList", tkRoundSubtaskList);
        result.put("curPage", pageNum);
        result.put("pageCount", totalPageNum);
        result.put("recordCount", recordCount);
        if (result != null) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", result));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u67e5\u8be2\u5931\u8d25\uff01"));
    }

    @ApiOperation(value="\u67e5\u7b2c\u4e00\u4e2a\u8be6\u60c5")
    @RequestMapping(value={"first"}, method={RequestMethod.GET})
    @ResponseBody
    public String getFirst(@RequestParam(required=false, value="pageNum", defaultValue="1") int pageNum, @RequestParam(required=false, value="pageSize", defaultValue="5") int pageSize, @RequestParam(required=false, value="gridCode") String gridCode, @RequestParam(required=false, value="origin") String origin, @RequestParam(required=false, value="status") String status, @RequestParam(required=false, value="loginUserRole") String loginUserRole, @RequestParam(required=false, value="userId") String userId, @RequestParam(required=false, value="subGridCodes") String subGridCodes, @RequestParam(required=false, value="time") String time, @RequestParam(required=false, value="name") String name) {
        TkRoundTaskExample tkRoundTaskExample = new TkRoundTaskExample();
        TkRoundTaskExample.Criteria criteria = tkRoundTaskExample.createCriteria();
        criteria.andIsShowEqualTo("1");
        if (time != null) {
            Date time2 = DateUtil.getDate((String)time, (String)"yyyy-MM-dd");
            criteria.andTimeEqualTo(time2);
        }
        if (StringUtils.isNotBlank((String)origin)) {
            criteria.andOriginEqualTo(origin);
        }
        if (StringUtils.isNotBlank((String)status)) {
            criteria.andStatusLike("%" + status + "%");
        }
        if (StringUtils.isNotBlank((String)name)) {
            criteria.andNameLike("%" + name + "%");
        }
        if (StringUtils.isNotBlank((String)loginUserRole) && (loginUserRole.equals("centerman") || loginUserRole.startsWith("one"))) {
            System.out.println("\u4e2d\u5fc3\u6216\u8005\u4e00\u7ea7\u7f51\u683c\u770b\u89c1\u6240\u6709 ");
        } else if (StringUtils.isNotBlank((String)userId)) {
            criteria.andUserIdsLike("%" + userId + "%");
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List tkRoundTaskList = this.tkRoundTaskService.selectByExample((Object)tkRoundTaskExample);
        if (tkRoundTaskList == null || tkRoundTaskList.size() == 0) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (String)"\u6ca1\u6570\u636e\uff01"));
        }
        TkRoundSubtaskExample tkRoundSubtaskExample = new TkRoundSubtaskExample();
        TkRoundSubtaskExample.Criteria criteria2 = tkRoundSubtaskExample.createCriteria();
        tkRoundSubtaskExample.setOrderByClause("time");
        if (StringUtils.isNotBlank((String)loginUserRole)) {
            if ("centerman".equals(loginUserRole) || loginUserRole.startsWith("one")) {
                System.out.println("\u4e2d\u5fc3\u6216\u8005\u4e00\u7ea7\u7f51\u683c\u770b\u89c1\u6240\u6709\u8be6\u60c5 centerman\uff1a\u4e2d\u5fc3\uff1bone\uff1a\u4e00\u7ea7");
            } else if (loginUserRole.startsWith("two")) {
                if (StringUtils.isBlank((String)subGridCodes)) {
                    System.out.println("\u7c97\u95ee\u9898\u4e86\uff1a\u4e8c\u7ea7\u7f51\u683c\u8981\u770b\u89c1\u5b50\u5730\u5757   subGridCodes\u4e0d\u80fd\u4e3a\u7a7a!!!");
                } else {
                    String[] subIds = subGridCodes.split(",");
                    List<String> gridCodes = Arrays.asList(subIds);
                    criteria2.andGridIdIn(gridCodes);
                }
            } else if (loginUserRole.startsWith("three") && StringUtils.isNotBlank((String)gridCode)) {
                criteria2.andGridIdEqualTo(gridCode);
            }
        }
        criteria2.andTaskIdEqualTo(((TkRoundTask)tkRoundTaskList.get(0)).getId());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List tkRoundSubtaskList = this.tkRoundSubtaskService.selectByExample((Object)tkRoundSubtaskExample);
        int recordCount = this.tkRoundSubtaskService.countByExample((Object)tkRoundSubtaskExample);
        int totalPageNum = (recordCount + pageSize - 1) / pageSize;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("task", tkRoundTaskList.get(0));
        result.put("subList", tkRoundSubtaskList);
        result.put("curPage", pageNum);
        result.put("pageCount", totalPageNum);
        result.put("recordCount", recordCount);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", result));
    }
}

