/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.DateUtil;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.task.TkCommonTask;
import com.ruoyi.system.domain.task.TkCommonTaskExample;
import com.ruoyi.system.domain.task.TkRoundPlan;
import com.ruoyi.system.domain.task.TkRoundSubtask;
import com.ruoyi.system.domain.task.TkRoundSubtaskExample;
import com.ruoyi.system.domain.task.TkRoundTask;
import com.ruoyi.system.domain.task.utils.WorkMSGUtils;
import com.ruoyi.system.service.system.ISysRoleService;
import com.ruoyi.system.service.task.DiyService;
import com.ruoyi.system.service.task.TkCommonTaskService;
import com.ruoyi.system.service.task.TkRoundPlanService;
import com.ruoyi.system.service.task.TkRoundSubtaskService;
import com.ruoyi.system.service.task.TkRoundTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5de5\u5355 \u5de1\u67e5 \u5b50\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/api/task/roundSubtask"})
public class RoundSubTaskController {
    @Autowired
    TkRoundSubtaskService tkRoundSubTaskService;
    @Autowired
    TkRoundTaskService tkRoundTaskService;
    @Autowired
    DiyService diyService;
    @Autowired
    TkCommonTaskService tkCommonTaskService;
    @Autowired
    TkRoundPlanService tkRoundPlanService;
    @Autowired
    private TkRoundSubtaskService tkRoundSubtaskService;
    @Autowired
    private WorkMSGUtils workMSGUtils;
    @Autowired
    private ISysRoleService sysRoleService;

    @ApiOperation(value="\u5404\u5bf9\u8c61\u7c7b\u578b\u7684\u5de1\u67e5\u8bb0\u5f55\u7edf\u8ba1")
    @RequestMapping(value={"subtaskNumByDXLX"}, method={RequestMethod.GET})
    @ResponseBody
    public String getSubTaskNumByDXLX() {
        Map map = this.diyService.getSubTaskNumByDXLX();
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)map));
    }

    @ApiOperation(value="\u67d0\u516c\u53f8\u6240\u6709\u72b6\u6001\u5de1\u67e5\u8bb0\u5f55\u7684\u6570\u91cf")
    @RequestMapping(value={"objSubtask"}, method={RequestMethod.GET})
    @ResponseBody
    public String getSubTaskNum(@RequestParam(required=true, value="objId") String objId) {
        TkRoundSubtask tkRoundSubtask = new TkRoundSubtask();
        tkRoundSubtask.setObjId(objId);
        tkRoundSubtask.setStatus("0");
        int toDo = this.getNumByExample(tkRoundSubtask);
        tkRoundSubtask.setStatus("1");
        int normal = this.getNumByExample(tkRoundSubtask);
        tkRoundSubtask.setStatus("2");
        int accident = this.getNumByExample(tkRoundSubtask);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("toDo", toDo);
        map.put("normal", normal);
        map.put("accident", accident);
        map.put("done", normal + accident);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", map));
    }

    public int getNumByExample(TkRoundSubtask tkRoundSubtask) {
        TkRoundSubtaskExample tkRoundsubTaskExample = new TkRoundSubtaskExample();
        TkRoundSubtaskExample.Criteria criteria = tkRoundsubTaskExample.createCriteria();
        if (StringUtils.isNotBlank((String)tkRoundSubtask.getObjId())) {
            criteria.andObjIdEqualTo(tkRoundSubtask.getObjId());
        }
        if (StringUtils.isNotBlank((String)tkRoundSubtask.getStatus())) {
            criteria.andStatusEqualTo(tkRoundSubtask.getStatus());
        }
        int num = this.tkRoundSubTaskService.countByExample((Object)tkRoundsubTaskExample);
        return num;
    }

    @ApiOperation(value="\u67d0\u4eba\u67d0\u6708\u5de1\u67e5\u6b21\u6570")
    @RequestMapping(value={"subtaskNum"}, method={RequestMethod.GET})
    @ResponseBody
    public String getSubTaskNum(@RequestParam(required=false, value="id") String id, @RequestParam(required=false, value="time") String time, @RequestParam(required=false, value="year") Integer year, @RequestParam(required=false, value="month") Integer month) {
        TkRoundSubtaskExample tkRoundsubTaskExample = new TkRoundSubtaskExample();
        TkRoundSubtaskExample.Criteria criteria = tkRoundsubTaskExample.createCriteria();
        if (year != null && month != null) {
            time = month < 10 ? year + "-0" + month : year + "-" + month;
        }
        Date time2 = DateUtil.getDate((String)time, (String)"yyyy-MM");
        criteria.andUpdateTimeGreaterThanOrEqualTo(time2);
        Calendar c = Calendar.getInstance();
        c.setTime(time2);
        c.add(2, 1);
        criteria.andUpdateTimeLessThan(c.getTime());
        criteria.andUpdateByEqualTo(id);
        List tkRoundSubtaskList = this.tkRoundSubTaskService.selectByExample((Object)tkRoundsubTaskExample);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)tkRoundSubtaskList.size()));
    }

    @ApiOperation(value="\u6839\u636e\u4efb\u52a1\u65f6\u95f4\u8303\u56f4\u548c\u4f01\u4e1a\u5bf9\u8c61ID\u83b7\u53d6\u5de1\u67e5\u8bb0\u5f55\u5217\u8868")
    @RequestMapping(value={"roundSubtask"}, method={RequestMethod.GET})
    @ResponseBody
    public String getList(@RequestParam(required=false, value="pageNum", defaultValue="1") int pageNum, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=true, value="objId") String objId, @RequestParam(required=false, value="startTime") String startTime, @RequestParam(required=false, value="origin") String origin, @RequestParam(required=false, value="status") String status, @RequestParam(required=false, value="endTime") String endTime) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List tkRoundSubTaskList = this.diyService.selectByParam(objId, startTime, endTime, origin, status, Integer.valueOf(pageNum), Integer.valueOf(pageSize));
        for (TkRoundSubtask tkRoundSubtask : tkRoundSubTaskList) {
            TkRoundTask tkRoundTask = (TkRoundTask)this.tkRoundTaskService.selectByPrimaryKey(tkRoundSubtask.getTaskId());
            TkRoundPlan tkRoundPlan = (TkRoundPlan)this.tkRoundPlanService.selectByPrimaryKey(tkRoundTask.getRoundPlanId());
            tkRoundSubtask.setPeriodType(tkRoundPlan.getPeriodType());
            tkRoundSubtask.setMatterId(tkRoundPlan.getMatterId());
            TkCommonTaskExample commonTaskExample = new TkCommonTaskExample();
            TkCommonTaskExample.Criteria criteria1 = commonTaskExample.createCriteria();
            criteria1.andRoundSubtaskIdEqualTo(tkRoundSubtask.getId());
            List tkCommonTasks = this.tkCommonTaskService.selectByExample((Object)commonTaskExample);
            for (TkCommonTask tkCommonTask : tkCommonTasks) {
                if (tkCommonTask.getTkStatus() > 40) {
                    tkCommonTask.setZt("\u5df2\u5b8c\u6210");
                    continue;
                }
                if (tkCommonTask.getTkStatus() == 40) {
                    tkCommonTask.setZt("\u5f85\u8bc4\u4ef7");
                    continue;
                }
                if (tkCommonTask.getTkStatus() >= 30 && tkCommonTask.getTkStatus() < 40) {
                    tkCommonTask.setZt("\u5f85\u6838\u67e5");
                    continue;
                }
                if (tkCommonTask.getTkStatus() >= 20 && tkCommonTask.getTkStatus() < 30) {
                    tkCommonTask.setZt("\u5904\u7406\u4e2d");
                    continue;
                }
                if (tkCommonTask.getTkStatus() > 10 && tkCommonTask.getTkStatus() < 20 && tkCommonTask.getTkStatus() != 16) {
                    tkCommonTask.setZt("\u5f85\u5904\u7406");
                    continue;
                }
                if (tkCommonTask.getTkStatus() == 10 || tkCommonTask.getTkStatus() == 10) {
                    tkCommonTask.setZt("\u5f85\u6307\u6d3e");
                    continue;
                }
                if (tkCommonTask.getTkStatus() != 32) continue;
                tkCommonTask.setZt("\u5f85\u5ef6\u65f6");
            }
            tkRoundSubtask.setTkCommonTask(tkCommonTasks.size() > 0 ? (TkCommonTask)tkCommonTasks.get(0) : null);
        }
        int recordCount = this.diyService.selectByParam(objId, startTime, endTime, origin, status, null, null).size();
        ZQTPageModel zqtongPageListResult = new ZQTPageModel();
        zqtongPageListResult.setItemList(tkRoundSubTaskList);
        zqtongPageListResult.setCurPage(recordCount == 0 ? 0L : (long)pageNum);
        int totalPageNum = (recordCount + pageSize - 1) / pageSize;
        zqtongPageListResult.setPageCount((long)totalPageNum);
        zqtongPageListResult.setRecordCount((long)recordCount);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)zqtongPageListResult));
    }

    @ApiOperation(value="\u50ac\u529e")
    @RequestMapping(value={"cuiBan"}, method={RequestMethod.POST})
    @ResponseBody
    public String CuiBan(@RequestBody TkRoundTask param) {
        try {
            String AssignedUserId = "";
            String AssignedUserName = "";
            Map map = this.getAdmin();
            AssignedUserId = (String)map.get("AssignedUserId");
            AssignedUserName = (String)map.get("AssignedUserName");
            TkRoundTask task = (TkRoundTask)this.tkRoundTaskService.selectByPrimaryKey(param.getId());
            String[] ids = task.getUserIds().split(",");
            List<String> idList = Arrays.asList(ids);
            String body = "" + param.getName() + " \u63d0\u793a\u60a8\u6709\u5de1\u67e5\u4efb\u52a1\uff08" + task.getName() + "\uff09\u5c1a\u672a\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff01";
            this.workMSGUtils.sendMsg(AssignedUserId, AssignedUserName, idList, body, null, null);
        }
        catch (Exception e) {
            return JSON.toJSONString((Object)AjaxResult.build((int)500, (String)"fail", (String)"\u50ac\u529e\u5931\u8d25"));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (String)"\u50ac\u529e\u6210\u529f"));
    }

    @ApiOperation(value="\u5f00\u59cb\u5de1\u67e5")
    @PatchMapping
    @ResponseBody
    public String patch(@RequestBody TkRoundSubtask tkRoundSubtask) {
        Integer result = null;
        TkRoundSubtask oldTkRoundSubtask = (TkRoundSubtask)this.tkRoundSubtaskService.selectByPrimaryKey(tkRoundSubtask.getId());
        if (StringUtils.isBlank((String)oldTkRoundSubtask.getCode())) {
            tkRoundSubtask.setResult(tkRoundSubtask.getStatus());
        }
        if ((result = Integer.valueOf(this.diyService.saveSubtask(tkRoundSubtask))) == 0) {
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u4fdd\u5b58\u5931\u8d25\uff01"));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)tkRoundSubtask));
    }

    @ApiOperation(value="\u5b50\u4efb\u52a1\u8be6\u60c5\uff08\u8fd9\u91cc\u7684id\u4e5f\u53ef\u4ee5\u4f20\u67e5\u8be2\u7f16\u53f7code\uff09")
    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getById(@PathVariable String id) {
        TkRoundSubtaskExample example = new TkRoundSubtaskExample();
        TkRoundSubtaskExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        TkRoundSubtaskExample.Criteria criteriaCode = example.createCriteria();
        criteriaCode.andCodeEqualTo(id);
        example.or(criteriaCode);
        TkRoundSubtask tkRoundSubtask = (TkRoundSubtask)this.tkRoundSubtaskService.selectFirstByExampleWithBLOBs((Object)example);
        TkRoundTask tkRoundTask = (TkRoundTask)this.tkRoundTaskService.selectByPrimaryKey(tkRoundSubtask.getTaskId());
        TkCommonTaskExample commonTaskExample = new TkCommonTaskExample();
        TkCommonTaskExample.Criteria criteria1 = commonTaskExample.createCriteria();
        criteria1.andRoundSubtaskIdEqualTo(tkRoundSubtask.getId());
        List tkCommonTasks = this.tkCommonTaskService.selectByExample((Object)commonTaskExample);
        for (TkCommonTask tkCommonTask : tkCommonTasks) {
            if (tkCommonTask.getTkStatus() > 40) {
                tkCommonTask.setZt("\u5df2\u5b8c\u6210");
                continue;
            }
            if (tkCommonTask.getTkStatus() == 40) {
                tkCommonTask.setZt("\u5f85\u8bc4\u4ef7");
                continue;
            }
            if (tkCommonTask.getTkStatus() >= 30 && tkCommonTask.getTkStatus() < 40) {
                tkCommonTask.setZt("\u5f85\u6838\u67e5");
                continue;
            }
            if (tkCommonTask.getTkStatus() >= 20 && tkCommonTask.getTkStatus() < 30) {
                tkCommonTask.setZt("\u5904\u7406\u4e2d");
                continue;
            }
            if (tkCommonTask.getTkStatus() > 10 && tkCommonTask.getTkStatus() < 20 && tkCommonTask.getTkStatus() != 16) {
                tkCommonTask.setZt("\u5f85\u5904\u7406");
                continue;
            }
            if (tkCommonTask.getTkStatus() == 10 || tkCommonTask.getTkStatus() == 10) {
                tkCommonTask.setZt("\u5f85\u6307\u6d3e");
                continue;
            }
            if (tkCommonTask.getTkStatus() != 32) continue;
            tkCommonTask.setZt("\u5f85\u5ef6\u65f6");
        }
        String matterId = this.diyService.getMatterId(tkRoundSubtask.getId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        tkRoundSubtask.setObjCode(null);
        result.put("tkRoundSubtask", tkRoundSubtask);
        result.put("tkCommonTask", tkCommonTasks.size() > 0 ? (Object)tkCommonTasks.get(0) : null);
        result.put("matterId", matterId);
        result.put("taskName", tkRoundTask.getName());
        if (tkRoundSubtask != null && StringUtils.isNotBlank((String)matterId)) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", result));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u67e5\u8be2\u5931\u8d25\uff01"));
    }

    private Map<String, String> getAdmin() {
        String AssignedUserId = "";
        String AssignedUserName = "";
        AjaxResult result = new AjaxResult();
        this.sysRoleService.getUserByRoleCode("centerman", result);
        if (result.isSuccess()) {
            JSONArray objects = JSONArray.parseArray((String)JSONObject.toJSONString((Object)result.get((Object)"data")));
            for (int i = 0; i < objects.size(); ++i) {
                JSONObject jsonObject = JSONObject.parseObject((String)objects.get(i).toString());
                if (jsonObject == null || jsonObject.get((Object)"ylzd2") == null || !jsonObject.get((Object)"ylzd2").toString().equals("1")) continue;
                AssignedUserId = jsonObject.getString("userId");
                AssignedUserName = "\u7ba1\u7406\u5458";
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("AssignedUserId", AssignedUserId);
        map.put("AssignedUserName", AssignedUserName);
        return map;
    }
}

