/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.task;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.DateUtil;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.task.TkRoundPlan;
import com.ruoyi.system.domain.task.TkRoundPlanExample;
import com.ruoyi.system.domain.task.vo.BsGridRegionUser;
import com.ruoyi.system.domain.task.vo.RoundPlanVO;
import com.ruoyi.system.service.task.DiyService;
import com.ruoyi.system.service.task.TkRoundPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5de5\u5355 \u5de1\u67e5 \u8ba1\u5212"})
@RestController
@RequestMapping(value={"/api/task/roundPlan"})
public class RoundPlanController {
    @Autowired
    TkRoundPlanService tkRoundPlanService;
    @Autowired
    DiyService diyService;

    @ApiOperation(value="\u65b0\u589e")
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    public String saveSubTask(@RequestBody RoundPlanVO roundPlanVO) {
        Integer result = null;
        if (roundPlanVO == null || StringUtils.isBlank((String)roundPlanVO.getName())) {
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u53c2\u6570\u4e0d\u5b8c\u6574\uff01"));
        }
        Object[] chooseObjIds = roundPlanVO.getChooseObjIds();
        Object[] chooseUserIds = roundPlanVO.getChooseUserIds();
        TkRoundPlan tkRoundPlan = new TkRoundPlan();
        tkRoundPlan.setId(roundPlanVO.getId());
        tkRoundPlan.setName(roundPlanVO.getName());
        tkRoundPlan.setDescription(roundPlanVO.getDescription());
        tkRoundPlan.setPeriodType("4");
        tkRoundPlan.setPeriodHz(roundPlanVO.getPeriodHz());
        tkRoundPlan.setPeriodInterval(roundPlanVO.getPeriodInterval());
        tkRoundPlan.setStartDate(roundPlanVO.getStartDate());
        tkRoundPlan.setEndDate(roundPlanVO.getEndDate());
        tkRoundPlan.setObjType(roundPlanVO.getObjType());
        tkRoundPlan.setMatterId(roundPlanVO.getMatterId());
        tkRoundPlan.setMatterName(roundPlanVO.getMatterName());
        tkRoundPlan.setStatus(roundPlanVO.getStatus());
        tkRoundPlan.setCreateBy(roundPlanVO.getCreateBy());
        tkRoundPlan.setCreateName(roundPlanVO.getCreateName());
        tkRoundPlan.setUpdateBy(roundPlanVO.getUpdateBy());
        tkRoundPlan.setStartDate(new Date());
        tkRoundPlan.setUserIds(StringUtils.join((Object[])chooseUserIds, (String)","));
        tkRoundPlan.setObjIds(StringUtils.join((Object[])chooseObjIds, (String)","));
        tkRoundPlan.setUserNames(roundPlanVO.getCreateName());
        tkRoundPlan.setUserIds(roundPlanVO.getCreateBy());
        tkRoundPlan.setId(UUID.randomUUID().toString());
        tkRoundPlan.setCreateTime(new Date());
        tkRoundPlan.setStatus("1");
        ArrayList<BsGridRegionUser> chooseObjJson = new ArrayList<BsGridRegionUser>();
        BsGridRegionUser bsWgdxb = new BsGridRegionUser();
        bsWgdxb.setName(roundPlanVO.getObjNames());
        bsWgdxb.setWgId(roundPlanVO.getGridId());
        chooseObjJson.add(bsWgdxb);
        result = this.diyService.insert(tkRoundPlan, (String[])chooseObjIds, (String[])chooseUserIds, null, chooseObjJson, roundPlanVO.getOrigin(), roundPlanVO.getStandby3());
        if (result == 0) {
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u5de1\u67e5\u8ba1\u5212\u4fdd\u5b58\u5931\u8d25\uff01"));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)roundPlanVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @GetMapping
    @ResponseBody
    public String getList(@RequestParam(required=false, value="pageNum", defaultValue="1") int pageNum, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false, value="periodType") String periodType, @RequestParam(required=false, value="startDate") String startDate, @RequestParam(required=false, value="status") String status, @RequestParam(required=false, value="name") String name) {
        TkRoundPlanExample tkRoundPlanExample = new TkRoundPlanExample();
        TkRoundPlanExample.Criteria criteria = tkRoundPlanExample.createCriteria();
        tkRoundPlanExample.setOrderByClause("create_time desc");
        if (StringUtils.isNotBlank((String)periodType)) {
            criteria.andPeriodTypeEqualTo(periodType);
        } else {
            criteria.andPeriodTypeNotEqualTo("4");
        }
        if (StringUtils.isNotBlank((String)startDate)) {
            Date startDate2 = DateUtil.getDate((String)startDate, (String)"yyyy-MM-dd");
            criteria.andStartDateEqualTo(startDate2);
        }
        if (StringUtils.isNotBlank((String)name)) {
            criteria.andNameLike("%" + name + "%");
        }
        if (StringUtils.isNotBlank((String)status)) {
            criteria.andStatusEqualTo(status);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List tkRoundPlanList = this.tkRoundPlanService.selectByExampleWithBLOBs((Object)tkRoundPlanExample);
        int recordCount = this.tkRoundPlanService.countByExample((Object)tkRoundPlanExample);
        ZQTPageModel zqtongPageListResult = new ZQTPageModel();
        zqtongPageListResult.setCurPage(recordCount == 0 ? 0L : (long)pageNum);
        zqtongPageListResult.setItemList(tkRoundPlanList);
        int totalPageNum = (recordCount + pageSize - 1) / pageSize;
        zqtongPageListResult.setPageCount((long)totalPageNum);
        zqtongPageListResult.setRecordCount((long)recordCount);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)zqtongPageListResult));
    }

    @ApiOperation(value="\u65b0\u589e\u8bb0\u5f55")
    @PostMapping
    @ResponseBody
    public String save(@RequestBody RoundPlanVO roundPlanVO) {
        Integer result = null;
        if (roundPlanVO == null || StringUtils.isBlank((String)roundPlanVO.getName())) {
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u53c2\u6570\u4e0d\u5b8c\u6574\uff01"));
        }
        Object[] chooseObjIds = roundPlanVO.getChooseObjIds();
        Object[] chooseUserIds = roundPlanVO.getChooseUserIds();
        List chooseUserJson = roundPlanVO.getChooseUserJson();
        List chooseObjJson = roundPlanVO.getChooseObjJson();
        TkRoundPlan tkRoundPlan = new TkRoundPlan();
        tkRoundPlan.setId(roundPlanVO.getId());
        tkRoundPlan.setName(roundPlanVO.getName());
        tkRoundPlan.setDescription(roundPlanVO.getDescription());
        tkRoundPlan.setPeriodType(roundPlanVO.getPeriodType());
        tkRoundPlan.setPeriodHz(roundPlanVO.getPeriodHz());
        tkRoundPlan.setPeriodInterval(roundPlanVO.getPeriodInterval());
        tkRoundPlan.setStartDate(roundPlanVO.getStartDate());
        tkRoundPlan.setEndDate(roundPlanVO.getEndDate());
        tkRoundPlan.setObjType(roundPlanVO.getObjType());
        tkRoundPlan.setMatterId(roundPlanVO.getMatterId());
        tkRoundPlan.setMatterName(roundPlanVO.getMatterName());
        tkRoundPlan.setStatus(roundPlanVO.getStatus());
        tkRoundPlan.setCreateBy(roundPlanVO.getCreateBy());
        tkRoundPlan.setCreateName(roundPlanVO.getCreateName());
        tkRoundPlan.setUpdateBy(roundPlanVO.getUpdateBy());
        tkRoundPlan.setUserIds(StringUtils.join((Object[])chooseUserIds, (String)","));
        tkRoundPlan.setObjIds(StringUtils.join((Object[])chooseObjIds, (String)","));
        StringBuffer userNames = new StringBuffer();
        for (GridRegionUser user : chooseUserJson) {
            userNames.append(user.getYlzd1());
            userNames.append(",");
        }
        tkRoundPlan.setUserNames(userNames.toString());
        tkRoundPlan.setId(UUID.randomUUID().toString());
        tkRoundPlan.setCreateTime(new Date());
        tkRoundPlan.setStatus("1");
        result = this.diyService.insert(tkRoundPlan, (String[])chooseObjIds, (String[])chooseUserIds, chooseUserJson, chooseObjJson, roundPlanVO.getOrigin(), null);
        if (result == 0) {
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u5de1\u67e5\u8ba1\u5212\u4fdd\u5b58\u5931\u8d25\uff01"));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)roundPlanVO));
    }

    @ApiOperation(value="\u66f4\u65b0\u6240\u6709")
    @PutMapping
    @ResponseBody
    public String put(@RequestBody TkRoundPlan tkRoundPlan) {
        Integer result = null;
        tkRoundPlan.setUpdateTime(new Date());
        result = this.tkRoundPlanService.updateByPrimaryKey((Object)tkRoundPlan);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)tkRoundPlan));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", null));
    }

    @ApiOperation(value="\u4fee\u6539\u4fe1\u606f")
    @PatchMapping
    @ResponseBody
    public String patch(@RequestBody TkRoundPlan tkRoundPlan) {
        Integer result = null;
        tkRoundPlan.setUpdateTime(new Date());
        result = this.tkRoundPlanService.updateByPrimaryKeySelective((Object)tkRoundPlan);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)tkRoundPlan));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", null));
    }

    @ApiOperation(value="\u5220\u9664\u8bb0\u5f55")
    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public String deleteById(@PathVariable String id) {
        System.out.println("/test/roundPlan/del----->" + id);
        int result = this.diyService.deletePlanById(id);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (String)id));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", null));
    }

    @ApiOperation(value="\u8be6\u60c5")
    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getById(@PathVariable String id) {
        TkRoundPlan result = (TkRoundPlan)this.tkRoundPlanService.selectByPrimaryKey(id);
        if (result != null) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)result));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u67e5\u8be2\u5931\u8d25\uff01"));
    }

    @ApiOperation(value="\u72b6\u6001\u5f00\u5173")
    @RequestMapping(value={"{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public String statusUpdate(@PathVariable String id) {
        Integer result = null;
        TkRoundPlan tkRoundPlan = (TkRoundPlan)this.tkRoundPlanService.selectByPrimaryKey(id);
        result = this.diyService.onOff(tkRoundPlan);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)tkRoundPlan));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", null));
    }

    @ApiOperation(value="\u67e5\u7b2c\u4e00\u4e2a\u8be6\u60c5")
    @RequestMapping(value={"first"}, method={RequestMethod.GET})
    @ResponseBody
    public String getFirst(@RequestParam(required=false, value="pageNum", defaultValue="1") int pageNum, @RequestParam(required=false, value="pageSize", defaultValue="1") int pageSize, @RequestParam(required=false, value="periodType") String periodType, @RequestParam(required=false, value="startDate") String startDate, @RequestParam(required=false, value="status") String status, @RequestParam(required=false, value="name") String name) {
        TkRoundPlanExample tkRoundPlanExample = new TkRoundPlanExample();
        TkRoundPlanExample.Criteria criteria = tkRoundPlanExample.createCriteria();
        tkRoundPlanExample.setOrderByClause("start_date desc");
        if (StringUtils.isNotBlank((String)periodType)) {
            criteria.andPeriodTypeEqualTo(periodType);
        }
        if (StringUtils.isNotBlank((String)startDate)) {
            Date startDate2 = DateUtil.getDate((String)startDate, (String)"yyyy-MM-dd");
            criteria.andStartDateEqualTo(startDate2);
        }
        if (StringUtils.isNotBlank((String)name)) {
            criteria.andNameLike("%" + name + "%");
        }
        if (StringUtils.isNotBlank((String)status)) {
            criteria.andStatusEqualTo(status);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List tkRoundPlanList = this.tkRoundPlanService.selectByExampleWithBLOBs((Object)tkRoundPlanExample);
        if (tkRoundPlanList == null || tkRoundPlanList.size() == 0) {
            return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (String)"\u6ca1\u6570\u636e\uff01"));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", tkRoundPlanList.get(0)));
    }

    @ApiOperation(value="\u8ba1\u5212\u6570\u91cf\u548c\u4f01\u4e1a\u5de1\u67e5\u6b21\u6570")
    @RequestMapping(value={"num"}, method={RequestMethod.GET})
    @ResponseBody
    public String roundPlanNum() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        TkRoundPlanExample tkRoundPlanExample = new TkRoundPlanExample();
        Integer totalPlanNum = this.tkRoundPlanService.countByExample((Object)tkRoundPlanExample);
        Integer totalQYRecordNum = this.diyService.countByDxlx("qy");
        map.put("planNum", totalPlanNum);
        map.put("recordNum", totalQYRecordNum);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", map));
    }
}

