/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTHttpHelper;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.task.TkCommonDiaodu;
import com.ruoyi.system.domain.task.TkCommonDiaoduExample;
import com.ruoyi.system.service.task.TkCommonDiaoduService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5de5\u5355 \u8c03\u5ea6\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/api/task/diaodu"})
public class CommonDiaoDuController {
    @Resource
    private TkCommonDiaoduService tkCommonDiaoduService;
    @Value(value="${app.mgrdata.url}")
    private String managedataUrl;

    @ApiOperation(value="\u65b0\u589e\u8054\u7ea7\u8c03\u5ea6")
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    @ResponseBody
    public String add(@RequestBody TkCommonDiaodu tkCommonDiaodu) {
        try {
            tkCommonDiaodu.setDdStatus("0");
            tkCommonDiaodu.setDdTkstatus("0");
            tkCommonDiaodu.setDdCreatetime(new Date());
            tkCommonDiaodu.setId(UUID.randomUUID().toString());
            int insert = this.tkCommonDiaoduService.insert((Object)tkCommonDiaodu);
            if (insert == 0) {
                return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u4fdd\u5b58\u51fa\u9519"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (String)"\u4fdd\u5b58\u51fa\u9519"));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (String)"\u4fdd\u5b58\u6210\u529f"));
    }

    @ApiOperation(value="\u5217\u8868")
    @RequestMapping(value={"list"}, method={RequestMethod.GET})
    @ResponseBody
    public String commonTasklist(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false) String ddName, @RequestParam(required=false) String ddYouxianji, @RequestParam(required=false) String ddStatus, @RequestParam(required=false) String ddTkstatus, @RequestParam(required=false) String starttime, @RequestParam(required=false) String endtime) {
        TkCommonDiaoduExample tkCommonDiaoduExample = new TkCommonDiaoduExample();
        TkCommonDiaoduExample.Criteria criteria = tkCommonDiaoduExample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)ddName)) {
            criteria.andDdNameLike("%" + ddName + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)ddYouxianji)) {
            criteria.andDdYouxianjiEqualTo(ddYouxianji);
        }
        if (StringUtils.isNotBlank((CharSequence)ddStatus)) {
            criteria.andDdStatusEqualTo(ddStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)ddTkstatus)) {
            criteria.andDdTkstatusEqualTo(ddTkstatus);
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)starttime) && StringUtils.isNotBlank((CharSequence)endtime)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                criteria.andDdCreatetimeBetween(sdf.parse(starttime), sdf.parse(endtime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        tkCommonDiaoduExample.setOrderByClause("dd_createtime desc");
        List tkCommonDiaodus = this.tkCommonDiaoduService.selectByExampleWithBLOBs((Object)tkCommonDiaoduExample);
        int recordCount = this.tkCommonDiaoduService.countByExample((Object)tkCommonDiaoduExample);
        ZQTPageModel result = new ZQTPageModel();
        result.setItemList(tkCommonDiaodus);
        result.setRecordCount((long)recordCount);
        result.setPageCount((long)((recordCount + pageSize - 1) / pageSize));
        result.setCurPage(recordCount == 0 ? 0L : (long)pageNum);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)result));
    }

    @ApiOperation(value="\u6307\u6325\u8c03\u5ea6\u5f53\u524d\u5e94\u6025\u54cd\u5e94\u3001\u7d2f\u8ba1\u5e94\u6025\u54cd\u5e94\u6570\u636e\r\n\u672a\u5b8c\u6210\u548c\u5df2\u5b8c\u6210\u7684\u6570\u91cf")
    @RequestMapping(value={"diaoduTaskNum"}, method={RequestMethod.GET})
    @ResponseBody
    public String diaoduTaskNum() {
        HashedMap map = new HashedMap();
        try {
            TkCommonDiaoduExample tkCommonDiaoduExample = new TkCommonDiaoduExample();
            TkCommonDiaoduExample.Criteria criteria = tkCommonDiaoduExample.createCriteria();
            criteria.andDdTkstatusEqualTo("0");
            int doingCount = this.tkCommonDiaoduService.countByExample((Object)tkCommonDiaoduExample);
            map.put("doingCount", doingCount);
            TkCommonDiaoduExample tkCommonDiaoduExample2 = new TkCommonDiaoduExample();
            TkCommonDiaoduExample.Criteria criteria2 = tkCommonDiaoduExample2.createCriteria();
            criteria2.andDdTkstatusEqualTo("1");
            int endCount = this.tkCommonDiaoduService.countByExample((Object)tkCommonDiaoduExample2);
            map.put("endCount", endCount);
            map.put("allCount", doingCount + endCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"fail", (Object)map));
        }
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)map));
    }

    private void XZData(List<Map<String, Object>> idAndName) {
        try {
            String url = this.managedataUrl + "/manageData/getXZData";
            HashedMap map = new HashedMap();
            HashMap<String, String> headParams = new HashMap<String, String>();
            headParams.put("Content-Type", "application/json");
            String ret = ZQTHttpHelper.doPostJson((String)url, (String)JSON.toJSONString((Object)map), headParams);
            JSONObject jsonObject = JSONObject.parseObject((String)ret);
            if (jsonObject != null && jsonObject.get((Object)"msg").equals("success")) {
                JSONArray data = (JSONArray)jsonObject.get((Object)"data");
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject jo = (JSONObject)data.get(i);
                    HashedMap idName = new HashedMap();
                    idName.put("id", jo.get((Object)"id") == null ? "" : jo.get((Object)"id").toString());
                    idName.put("name", jo.get((Object)"xzmc") == null ? "" : jo.get((Object)"xzmc").toString());
                    idName.put("longitude", jo.get((Object)"longitude") == null ? "" : jo.get((Object)"longitude").toString());
                    idName.put("latitude", jo.get((Object)"latitude") == null ? "" : jo.get((Object)"latitude").toString());
                    idAndName.add((Map<String, Object>)idName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

