/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.task;

import com.alibaba.fastjson2.JSON;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.file.WordUtils;
import com.ruoyi.system.domain.task.TkChengyunTask;
import com.ruoyi.system.domain.task.TkChengyunTaskExample;
import com.ruoyi.system.service.task.TkChengyunTaskService;
import freemarker.core.OutputFormat;
import freemarker.core.XMLOutputFormat;
import freemarker.template.Configuration;
import freemarker.template.Template;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriUtils;

@Api(tags={"\u5de5\u5355 \u57ce\u8fd0\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/api/task/chengyun"})
public class ChengyunTaskController {
    @Autowired
    private TkChengyunTaskService tkChengyunTaskService;

    @ApiOperation(value="\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public String list(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, String isPush, String name, String cedeventcode) {
        AjaxResult result = new AjaxResult();
        this.tkChengyunTaskService.getRoles(cedeventcode, name, isPush, Integer.valueOf(pageNum), Integer.valueOf(pageSize), result);
        return JSON.toJSONString((Object)result);
    }

    @ApiOperation(value="\u7f16\u8f91")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public String update(@RequestBody TkChengyunTask chengyunTask) {
        int result = this.tkChengyunTaskService.updateByPrimaryKeySelective((Object)chengyunTask);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)chengyunTask.getCedeventcode()));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"fail"));
    }

    @ApiOperation(value="\u4e0b\u8f7d")
    @GetMapping(value={"/download"})
    public void download(@RequestParam(value="cedeventcode") String cedeventcode, HttpServletRequest request, HttpServletResponse response) {
        try {
            TkChengyunTask bsWgchengyunTask = (TkChengyunTask)this.tkChengyunTaskService.selectByPrimaryKey(cedeventcode);
            Configuration configuration = new Configuration();
            configuration.setDefaultEncoding("utf-8");
            configuration.setOutputFormat((OutputFormat)XMLOutputFormat.INSTANCE);
            configuration.setClassForTemplateLoading(this.getClass(), "/template");
            Template template = configuration.getTemplate("serviceOrder.ftl");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("cedeventcode", bsWgchengyunTask.getCedeventcode());
            map.put("complaintsPhone", bsWgchengyunTask.getComplaintsPhone());
            map.put("complaintsPerson", bsWgchengyunTask.getComplaintsPerson());
            map.put("address", bsWgchengyunTask.getFsdz());
            map.put("sfsj", bsWgchengyunTask.getSfsj());
            map.put("name", bsWgchengyunTask.getName());
            map.put("nameDetail", bsWgchengyunTask.getNameDetail());
            map.put("distributeDate", bsWgchengyunTask.getCreateTime());
            map.put("deadline", bsWgchengyunTask.getEndTime());
            map.put("appealType", "\u4e3e\u62a5");
            map.put("originType", "\u7535\u8bdd");
            map.put("townStreet", "\u4e07\u77f3\u9547");
            map.put("opinion", "\u8bf7\u5904\u7406\u90e8\u95e8\u67e5\u770b\u5de5\u5355\u540e\uff0c\u5c3d\u5feb\u6838\u5b9e\u60c5\u51b5\u5e76\u5904\u7406\u8be5\u95ee\u9898\u3002");
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/msword");
            String fileName = bsWgchengyunTask.getName() + "_" + bsWgchengyunTask.getEndTime() + ".doc";
            response.setHeader("Content-Disposition", "attachment;filename=\"" + UriUtils.encode((String)fileName, (String)"utf-8") + "\"");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8));
            template.process(map, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/downloadBatch"})
    public void downloadBatch(@RequestBody String[] cedeventcodeArr, HttpServletRequest request, HttpServletResponse response) {
        try {
            TkChengyunTaskExample example = new TkChengyunTaskExample();
            TkChengyunTaskExample.Criteria criteria = example.createCriteria();
            criteria.andCedeventcodeIn(Arrays.asList(cedeventcodeArr));
            List TkChengyunTaskList = this.tkChengyunTaskService.selectByExample((Object)example);
            ArrayList list = new ArrayList();
            ArrayList<String> fileList = new ArrayList<String>();
            for (TkChengyunTask bsWgchengyunTask : TkChengyunTaskList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("cedeventcode", bsWgchengyunTask.getCedeventcode());
                map.put("complaintsPhone", bsWgchengyunTask.getComplaintsPhone());
                map.put("complaintsPerson", bsWgchengyunTask.getComplaintsPerson());
                map.put("address", bsWgchengyunTask.getFsdz());
                map.put("sfsj", bsWgchengyunTask.getSfsj());
                map.put("name", bsWgchengyunTask.getName());
                map.put("nameDetail", bsWgchengyunTask.getNameDetail());
                map.put("distributeDate", bsWgchengyunTask.getCreateTime());
                map.put("deadline", bsWgchengyunTask.getEndTime());
                map.put("appealType", "\u4e3e\u62a5");
                map.put("originType", "\u7535\u8bdd");
                map.put("townStreet", "\u4e07\u77f3\u9547");
                map.put("opinion", "\u8bf7\u5904\u7406\u90e8\u95e8\u67e5\u770b\u5de5\u5355\u540e\uff0c\u5c3d\u5feb\u6838\u5b9e\u60c5\u51b5\u5e76\u5904\u7406\u8be5\u95ee\u9898\u3002");
                list.add(map);
                String fileName = bsWgchengyunTask.getName() + "_" + bsWgchengyunTask.getEndTime();
                fileList.add(fileName);
            }
            String ftlName = "/template/serviceOrder.ftl";
            WordUtils.exportWordBatch(list, fileList, (String)ftlName, (HttpServletResponse)response, (HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

