/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.DES;
import com.alibaba.fastjson.JSON;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.DeptUserCountTree;
import com.ruoyi.common.core.domain.DeptUserTree;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.utils.uuid.IdUtils;
import com.ruoyi.generator.utils.AesUtil;
import com.ruoyi.system.service.system.ISysDeptService;
import com.ruoyi.system.service.system.ISysPostService;
import com.ruoyi.system.service.system.ISysRoleService;
import com.ruoyi.system.service.system.ISysUserService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u57fa\u7840\u670d\u52a1 - \u7528\u6237\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/system/user"})
public class SysUserController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysDeptService deptService;
    @Autowired
    private ISysPostService postService;
    private static final String SECRET = "Av627+rvCwc=";

    @GetMapping(value={"/list"})
    public TableDataInfo list(SysUser user) {
        this.startPage();
        List list = this.userService.selectUserList(user);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/listForApp"})
    public AjaxResult listForApp(@RequestParam(value="deptId", required=false) Long deptId, @RequestParam(value="nickName", required=false) String nickName) {
        SysUser sysUser = new SysUser();
        sysUser.setNickName(nickName);
        sysUser.setStatus("0");
        sysUser.setDeptId(deptId);
        return AjaxResult.success((Object)this.userService.selectUserList(sysUser));
    }

    @GetMapping(value={"/listWithoutToken"})
    public AjaxResult listWithoutToken() {
        List sysUsers = this.userService.listAllUsers();
        ArrayList result = new ArrayList();
        sysUsers.forEach(user -> {
            SysUser sysUser = new SysUser();
            sysUser.setUserId(user.getUserId());
            sysUser.setNickName(user.getNickName());
            sysUser.setUserName(user.getUserName());
            try {
                DES des = SecureUtil.des((byte[])AesUtil.base64Decode((String)SECRET));
                result.add(des.encryptHex(JSON.toJSONString((Object)sysUser)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return AjaxResult.success(result);
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@ss.hasPermi('system:user:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysUser user) {
        List list = this.userService.selectUserList(user);
        ExcelUtil util = new ExcelUtil(SysUser.class);
        util.exportExcel(response, list, "\u7528\u6237\u6570\u636e");
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.IMPORT)
    @PreAuthorize(value="@ss.hasPermi('system:user:import')")
    @PostMapping(value={"/importData"})
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        List userList = util.importExcel(file.getInputStream());
        String operName = this.getUsername();
        String message = this.userService.importUser(userList, Boolean.valueOf(updateSupport), operName);
        return this.success(message);
    }

    @PostMapping(value={"/importTemplate"})
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        util.importTemplateExcel(response, "\u7528\u6237\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:query')")
    @GetMapping(value={"/", "/{userId}"})
    public AjaxResult getInfo(@PathVariable(value="userId", required=false) String userId) {
        this.userService.checkUserDataScope(userId);
        AjaxResult ajax = AjaxResult.success();
        List roles = this.roleService.selectRoleAll();
        ajax.put("roles", (Object)(SysUser.isAdmin((String)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        ajax.put("posts", (Object)this.postService.selectPostAll());
        if (StringUtils.isNotNull((Object)userId)) {
            SysUser sysUser = this.userService.selectUserById(userId);
            ajax.put("data", (Object)sysUser);
            ajax.put("postIds", (Object)this.postService.selectPostListByUserId(userId));
            ajax.put("roleIds", sysUser.getRoles().stream().map(SysRole::getRoleId).collect(Collectors.toList()));
        }
        return ajax;
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:add')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysUser user) {
        if (!this.userService.checkUserNameUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && !this.userService.checkPhoneUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && !this.userService.checkEmailUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        user.setUserId(IdUtils.simpleUUID());
        user.setCreateBy(this.getUsername());
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        return this.toAjax(this.userService.insertUser(user));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:edit')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        this.userService.checkUserDataScope(user.getUserId());
        if (!this.userService.checkUserNameUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && !this.userService.checkPhoneUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && !this.userService.checkEmailUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        user.setUpdateBy(this.getUsername());
        return this.toAjax(this.userService.updateUser(user));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:remove')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{userIds}"})
    public AjaxResult remove(@PathVariable String[] userIds) {
        if (ArrayUtils.contains((Object[])userIds, (Object)this.getUserId())) {
            return this.error("\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u5220\u9664");
        }
        return this.toAjax(this.userService.deleteUserByIds(userIds));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:resetPwd')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resetPwd"})
    public AjaxResult resetPwd(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        this.userService.checkUserDataScope(user.getUserId());
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        user.setUpdateBy(this.getUsername());
        return this.toAjax(this.userService.resetPwd(user));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:edit')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult changeStatus(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        this.userService.checkUserDataScope(user.getUserId());
        user.setUpdateBy(this.getUsername());
        return this.toAjax(this.userService.updateUserStatus(user));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:query')")
    @GetMapping(value={"/authRole/{userId}"})
    public AjaxResult authRole(@PathVariable(value="userId") String userId) {
        AjaxResult ajax = AjaxResult.success();
        SysUser user = this.userService.selectUserById(userId);
        List roles = this.roleService.selectRolesByUserId(userId);
        ajax.put("user", (Object)user);
        ajax.put("roles", (Object)(SysUser.isAdmin((String)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        return ajax;
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:edit')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PutMapping(value={"/authRole"})
    public AjaxResult insertAuthRole(String userId, Long[] roleIds) {
        this.userService.checkUserDataScope(userId);
        this.userService.insertUserAuth(userId, roleIds);
        return this.success();
    }

    @GetMapping(value={"/deptTree"})
    public AjaxResult deptTree(SysDept dept) {
        return this.success((Object)this.deptService.selectDeptTreeList(dept));
    }

    @GetMapping(value={"/deptTreeWithUserCount"})
    public AjaxResult deptTreeWithCount() {
        SysDept dept = new SysDept();
        dept.setNeedAuth(false);
        dept.setStatus("0");
        List treeSelectList = this.deptService.selectDeptTreeList(dept);
        List userTrees = BeanCopyUtil.bathToBean((Collection)treeSelectList, DeptUserCountTree.class);
        if (!CollectionUtils.isEmpty((Collection)userTrees)) {
            this.setDepUserWithCountChild(userTrees);
        }
        return AjaxResult.success((Object)userTrees);
    }

    private void setDepUserWithCountChild(List<DeptUserCountTree> userTrees) {
        for (DeptUserCountTree userTree : userTrees) {
            int count = this.deptService.countUserByDeptId(Long.valueOf(Long.parseLong(userTree.getId())));
            userTree.setUserCount(count);
            if (CollectionUtils.isEmpty((Collection)userTree.getChildren())) continue;
            this.setDepUserWithCountChild(userTree.getChildren());
        }
    }

    @GetMapping(value={"/userTree"})
    public AjaxResult getUserTree() {
        SysDept dept = new SysDept();
        dept.setStatus("0");
        dept.setNeedAuth(false);
        List deptTree = this.deptService.selectDeptTreeList(dept);
        List userTrees = BeanCopyUtil.bathToBean((Collection)deptTree, DeptUserTree.class);
        if (!CollectionUtils.isEmpty((Collection)userTrees)) {
            this.setDeptUserChild(userTrees);
        }
        return AjaxResult.success((Object)userTrees);
    }

    private void setDeptUserChild(List<DeptUserTree> userTrees) {
        for (DeptUserTree userTree : userTrees) {
            int count = this.deptService.countUserByDeptId(Long.valueOf(Long.parseLong(userTree.getId())));
            userTree.setCount(count);
            List sysUsers = this.userService.listByDepIdOnly(Long.valueOf(Long.parseLong(userTree.getId())));
            ArrayList<DeptUserTree> treeList = new ArrayList<DeptUserTree>();
            if (!CollectionUtils.isEmpty((Collection)sysUsers)) {
                for (SysUser sysUser : sysUsers) {
                    DeptUserTree tree = new DeptUserTree();
                    tree.setIsDep(false);
                    tree.setAvatar(sysUser.getAvatar());
                    tree.setId(sysUser.getUserId());
                    tree.setLabel(sysUser.getNickName());
                    treeList.add(tree);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)userTree.getChildren())) {
                this.setDeptUserChild(userTree.getChildren());
                userTree.getChildren().addAll(treeList);
                continue;
            }
            userTree.setChildren(treeList);
        }
    }
}

