/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysMenu;
import com.ruoyi.common.enums.MenuRangeEnum;
import com.ruoyi.common.enums.MenuTypeEnum;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.domain.system.SysRoleMenu;
import com.ruoyi.system.domain.system.enums.PermissionTypeEnum;
import com.ruoyi.system.mapper.system.SysMenuMapper;
import com.ruoyi.system.mapper.system.SysRoleMenuMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57fa\u7840\u670d\u52a1 - \u6743\u9650\u8bbe\u7f6e"})
@RestController
@RequestMapping(value={"/system/permission"})
public class SysNewPermissionController {
    @Autowired
    private SysRoleMenuMapper sysRoleMenuMapper;
    @Autowired
    private SysMenuMapper sysMenuMapper;

    @ApiOperation(value="\u6743\u9650\u7c7b\u578b\u679a\u4e3e")
    @GetMapping(value={"/type/enums"})
    public AjaxResult typeEnums() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(PermissionTypeEnum.DEPT.getCode(), PermissionTypeEnum.DEPT.getValue());
        map.put(PermissionTypeEnum.ROLE.getCode(), PermissionTypeEnum.ROLE.getValue());
        map.put(PermissionTypeEnum.PERSONAL.getCode(), PermissionTypeEnum.PERSONAL.getValue());
        return AjaxResult.success(map);
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6743\u9650")
    @PostMapping(value={"/bathAdd"})
    public AjaxResult bathAddPermission(@RequestBody List<SysRoleMenu> roleMenuList) {
        if (CollectionUtils.isEmpty(roleMenuList)) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)roleMenuList.get(0).getType()) || roleMenuList.get(0).getForeignId() == null || StringUtils.isEmpty((CharSequence)roleMenuList.get(0).getWorkRange())) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        List existRole = this.sysRoleMenuMapper.listByTypeAndForeignIdAndRange(roleMenuList.get(0).getType(), roleMenuList.get(0).getForeignId(), roleMenuList.get(0).getWorkRange());
        if (!CollectionUtils.isEmpty((Collection)existRole)) {
            this.sysRoleMenuMapper.deleteAllRoles(existRole.stream().map(SysRoleMenu::getId).collect(Collectors.toList()));
        }
        if (roleMenuList.get(0).getMenuId() != null) {
            this.sysRoleMenuMapper.batchRoleMenu(roleMenuList);
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u67d0\u7ec4\u7ec7/\u89d2\u8272/\u4eba\u5458\u7684\u6743\u9650\u5217\u8868")
    @GetMapping(value={"/list"})
    public AjaxResult getList(String type, String foreignId, String range) {
        return AjaxResult.success((Object)this.sysRoleMenuMapper.listByTypeAndForeignIdAndRange(type, foreignId, range));
    }

    @ApiOperation(value="\u5168\u90e8\u5e94\u7528/\u83dc\u5355/\u76ee\u5f55/\u6309\u94ae")
    @GetMapping(value={"/listAll"})
    public AjaxResult listAll(@RequestParam(value="range") String range) {
        if (StringUtils.isEmpty((CharSequence)range)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        if (MenuRangeEnum.PC.getCode().equals(range)) {
            SysMenu sysMenu = new SysMenu();
            sysMenu.setMenuType(MenuTypeEnum.APP.getCode());
            sysMenu.setWorkRange(MenuRangeEnum.PC.getCode());
            sysMenu.setStatus("0");
            List sysMenuList = this.sysMenuMapper.selectMenuList(sysMenu);
            this.setMenuChildren(sysMenuList);
            return AjaxResult.success((Object)sysMenuList);
        }
        SysMenu sysMenu = new SysMenu();
        sysMenu.setStatus("0");
        sysMenu.setWorkRange(MenuRangeEnum.APP.getCode());
        List sysMenuList = this.sysMenuMapper.selectMenuList(sysMenu);
        if (CollectionUtils.isNotEmpty((Collection)sysMenuList)) {
            for (SysMenu sysMenu1 : sysMenuList) {
                this.setRootMenuId(sysMenu1);
            }
        }
        return AjaxResult.success((Object)sysMenuList);
    }

    private void setMenuChildren(List<SysMenu> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (SysMenu menu : list) {
                SysMenu param = new SysMenu();
                param.setParentId(menu.getMenuId());
                param.setWorkRange(MenuRangeEnum.PC.getCode());
                param.setStatus("0");
                List children = this.sysMenuMapper.selectMenuList(param);
                if (CollectionUtils.isEmpty((Collection)children)) continue;
                this.setMenuChildren(children);
                menu.setChildren(children);
            }
        }
    }

    private void setRootMenuId(SysMenu menu) {
        SysMenu sysMenu;
        if (menu.getParentId() != null && (sysMenu = this.sysMenuMapper.selectMenuById(menu.getParentId())) != null) {
            if (MenuTypeEnum.APP.getCode().equals(sysMenu.getMenuType())) {
                menu.setRootMenuId(sysMenu.getMenuId());
                menu.setRootMenuName(sysMenu.getMenuName());
            } else {
                this.setRootMenuId(sysMenu);
            }
        }
    }
}

