/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysMenu;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginBody;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.enums.MenuTypeEnum;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.framework.web.service.SysLoginService;
import com.ruoyi.framework.web.service.SysPermissionService;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.GridRegionUserExample;
import com.ruoyi.system.domain.grid.enums.GridRegionSearchParam;
import com.ruoyi.system.mapper.system.SysMenuMapper;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.system.ISysMenuService;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.system.SysMenuPermissionService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57fa\u7840\u670d\u52a1 - \u767b\u5f55\u9a8c\u8bc1"})
@RestController
public class SysLoginController {
    @Autowired
    private SysLoginService loginService;
    @Autowired
    private ISysMenuService menuService;
    @Autowired
    private SysPermissionService permissionService;
    @Autowired
    private GridRegionUserService gridRegionUserService;
    @Autowired
    private GridRegionService gridRegionService;
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private SysMenuPermissionService sysMenuPermissionService;
    @Autowired
    private ISysUserService sysUserService;

    @PostMapping(value={"/login"})
    public AjaxResult login(@RequestBody LoginBody loginBody) {
        AjaxResult ajax = AjaxResult.success();
        String token = this.loginService.login(loginBody.getUsername(), loginBody.getPassword(), loginBody.getCode(), loginBody.getUuid(), true);
        ajax.put("token", (Object)token);
        return ajax;
    }

    @PostMapping(value={"/app/login"})
    public AjaxResult appLogin(@RequestBody LoginBody loginBody) {
        AjaxResult ajax = AjaxResult.success();
        String token = this.loginService.login(loginBody.getUsername(), loginBody.getPassword(), null, null, false);
        ajax.put("token", (Object)token);
        SysUser sysUser = this.sysUserService.selectUserByUserName(loginBody.getUsername());
        ajax.put("leaderFlag", (Object)(sysUser == null ? "0" : sysUser.getLeaderFlag().toString()));
        return ajax;
    }

    @GetMapping(value={"getInfo"})
    public AjaxResult getInfo() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        Set roles = this.permissionService.getRolePermission(user);
        Set permissions = this.permissionService.getMenuPermission(user);
        Set appPermissions = this.permissionService.getAppMenuPermission(user);
        GridRegionUserExample example = new GridRegionUserExample();
        GridRegionUserExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(user.getUserId());
        criteria.andIsValidEqualTo("1");
        List relationship = this.gridRegionUserService.selectByExample((Object)example);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("user", (Object)user);
        ajax.put("roles", (Object)roles);
        ajax.put("permissions", (Object)permissions);
        ajax.put("appPermissionPath", (Object)appPermissions);
        ajax.put("region", (Object)(CollectionUtils.isEmpty((Collection)relationship) ? "" : relationship.stream().map(GridRegionUser::getWgId).collect(Collectors.joining(","))));
        GridRegionSearchParam param = new GridRegionSearchParam();
        param.setWgCodeIn(relationship.stream().map(GridRegionUser::getWgId).collect(Collectors.toList()));
        ajax.put("regionList", CollectionUtils.isEmpty((Collection)relationship) ? new ArrayList() : this.gridRegionService.getByParams(param));
        return ajax;
    }

    private SysMenu getRootMenuId(SysMenu menu) {
        if (menu.getParentId() != null) {
            SysMenu sysMenu = this.menuService.selectMenuById(menu.getParentId());
            if (MenuTypeEnum.APP.getCode().equals(sysMenu.getMenuType())) {
                return sysMenu;
            }
            return this.getRootMenuId(sysMenu);
        }
        return menu;
    }

    @GetMapping(value={"hasRoutePermission"})
    public AjaxResult hasRoutePermission(@RequestParam(value="path") String path) {
        SysMenu param = new SysMenu();
        param.setStatus("0");
        param.setPath(path);
        List sysMenuList = this.sysMenuMapper.selectMenuList(param);
        if (CollectionUtils.isEmpty((Collection)sysMenuList)) {
            throw new ServiceException("\u65e0\u6b64\u83dc\u5355!");
        }
        SysMenu menu = (SysMenu)sysMenuList.get(0);
        SysUser user = SecurityUtils.getLoginUser().getUser();
        List<Object> menuIds = new ArrayList();
        if (user.isAdmin()) {
            SysMenu sysMenu = new SysMenu();
            sysMenu.setStatus("0");
            List menus = this.sysMenuMapper.selectMenuList(sysMenu);
            menuIds = menus.stream().map(SysMenu::getMenuId).collect(Collectors.toList());
        } else {
            menuIds = this.sysMenuPermissionService.getUserMenuIds(user, null);
        }
        if (!menuIds.contains(menu.getMenuId())) {
            throw new ServiceException("\u65e0\u6b64\u8def\u7531\u6743\u9650!");
        }
        if (MenuTypeEnum.APP.getCode().equals(menu.getMenuType())) {
            menu.setRootMenuId(menu.getMenuId());
            menu.setRootMenuName(menu.getMenuName());
        } else {
            SysMenu rootMenu = this.getRootMenuId(menu);
            menu.setRootMenuId(rootMenu.getMenuId());
            menu.setRootMenuName(rootMenu.getMenuName());
        }
        return AjaxResult.success((Object)menu);
    }

    @GetMapping(value={"getRouters"})
    public AjaxResult getRouters() {
        SysUser loginUser = SecurityUtils.getLoginUser().getUser();
        List menus = this.menuService.selectMenuTreeByUserId(loginUser);
        return AjaxResult.success((Object)this.menuService.buildMenus(menus));
    }

    @GetMapping(value={"/app/list"})
    public AjaxResult appList() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        List menus = this.permissionService.getAppList(user);
        return AjaxResult.success((Object)menus);
    }

    @GetMapping(value={"/app/hasPerms"})
    public AjaxResult hasPerms(Long appId) {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        return AjaxResult.success((Object)this.permissionService.hasAppPerms(user, appId));
    }

    @GetMapping(value={"/app/getRouters"})
    public AjaxResult getAppRouters(Long menuId) {
        if (menuId == null) {
            return AjaxResult.warn((String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LoginUser loginUser = SecurityUtils.getLoginUser();
        List menus = this.menuService.selectMenuTreeByUserId(loginUser.getUser());
        for (SysMenu menu : menus) {
            if (!menu.getMenuId().equals(menuId)) continue;
            return AjaxResult.success((Object)this.menuService.buildMenus(menu.getChildren()));
        }
        return AjaxResult.success();
    }
}

