/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.stamp;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.system.domain.stamp.request.CarDinnerExamineRequest;
import com.ruoyi.system.domain.stamp.request.CarExamineSaveRequest;
import com.ruoyi.system.service.stamp.CarExamineService;
import io.swagger.annotations.Api;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u8f66\u7533\u8bf7"})
@RestController
@RequestMapping(value={"/api/car/examine"})
public class CarExamineController
extends BaseController {
    @Autowired
    private CarExamineService carExamineService;

    @PostMapping(value={"/save"})
    public AjaxResult save(@RequestBody CarExamineSaveRequest request) {
        SysUser sysUser = this.getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateTime(new Date());
        request.setCreateUserName(sysUser.getNickName());
        SysDept sysDept = sysUser.getDept();
        if (sysDept != null) {
            request.setDepId(sysDept.getDeptId());
            request.setDepName(sysDept.getDeptName());
        }
        this.carExamineService.save(request);
        return AjaxResult.success();
    }

    @PostMapping(value={"/examine"})
    public AjaxResult examine(@RequestBody CarDinnerExamineRequest request) {
        request.setUserId(this.getUserId());
        this.carExamineService.apply(request);
        return AjaxResult.success();
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.carExamineService.detail(id, this.getUserId()));
    }

    @GetMapping(value={"/page"})
    public AjaxResult page(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="title", required=false) String title, @RequestParam(value="status", required=false) String status) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = this.carExamineService.page(title, status, this.getUserId());
        return AjaxResult.success((Object)pageInfo);
    }

    @PostMapping(value={"/reSubmit"})
    public AjaxResult reSubmit(@RequestBody CarExamineSaveRequest request) {
        SysUser sysUser = this.getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateTime(new Date());
        request.setCreateUserName(sysUser.getNickName());
        request.setUpdateTime(new Date());
        SysDept sysDept = sysUser.getDept();
        if (sysDept != null) {
            request.setDepId(sysDept.getDeptId());
            request.setDepName(sysDept.getDeptName());
        }
        this.carExamineService.reSubmit(request);
        return AjaxResult.success();
    }
}

