/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.screen;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.service.SysPermissionService;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.GridRegionUserExample;
import com.ruoyi.system.domain.grid.enums.GridRegionSearchParam;
import com.ruoyi.system.domain.grid.vo.GridCompanySearchParam;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.mapper.grid.GridRegionUserMapper;
import com.ruoyi.system.mapper.task.ext.TkCommonTaskExtMapper;
import com.ruoyi.system.service.grid.GridCompanyService;
import com.ruoyi.system.service.grid.GridHouseService;
import com.ruoyi.system.service.grid.GridPeopleService;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.grid.GridShopService;
import com.ruoyi.system.service.grid.GridWgLogService;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.task.TkCommonTaskService;
import com.ruoyi.web.controller.screen.res.CommonCountItem;
import com.ruoyi.web.controller.screen.res.InfoWithTypeRes;
import com.ruoyi.web.controller.screen.res.SimpleUserInfo;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5927\u5c4f\u63a5\u53e3-\u7f51\u683c\u6001\u52bf-\u793e\u4f1a\u6cbb\u7406"})
@RestController
@RequestMapping(value={"/api/grid/screen/social"})
public class ScreenSocialController {
    @Autowired
    private GridPeopleService gridPeopleService;
    @Autowired
    private GridHouseService gridHouseService;
    @Autowired
    private GridCompanyService gridCompanyService;
    @Autowired
    private GridShopService gridShopService;
    @Autowired
    private GridRegionMapper gridRegionMapper;
    @Autowired
    private GridWgLogService gridWgLogService;
    @Autowired
    private SysPermissionService permissionService;
    @Autowired
    private GridRegionUserService gridRegionUserService;
    @Autowired
    private TkCommonTaskExtMapper tkCommonTaskExtMapper;
    @Autowired
    private GridRegionUserMapper gridRegionUserMapper;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    TkCommonTaskService tkCommonTaskService;

    @GetMapping(value={"/getInfo/user"})
    public AjaxResult getInfo() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        SimpleUserInfo simpleUserInfo = new SimpleUserInfo();
        BeanUtils.copyProperties((Object)user, (Object)simpleUserInfo);
        return AjaxResult.success((Object)simpleUserInfo);
    }

    @GetMapping(value={"/getInfo/roles"})
    public AjaxResult getInfoRoles() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        Set roles = this.permissionService.getRolePermission(user);
        return AjaxResult.success((Object)roles);
    }

    @GetMapping(value={"/getInfo/grid"})
    public AjaxResult getInfoGrid() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        GridRegionUserExample example = new GridRegionUserExample();
        GridRegionUserExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(user.getUserId());
        criteria.andIsValidEqualTo("1");
        List relationship = this.gridRegionUserService.selectByExample((Object)example);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)(CollectionUtils.isEmpty((Collection)relationship) ? "" : relationship.stream().map(GridRegionUser::getWgId).collect(Collectors.joining(","))));
    }

    @GetMapping(value={"/infoWithType"})
    public AjaxResult infoWithType(@RequestParam(value="wgCode", required=false) String wgCode) {
        InfoWithTypeRes res = new InfoWithTypeRes();
        res.setPeopleAllNum(this.gridPeopleService.countAll(wgCode));
        res.setSpecialPeopleNum(Integer.valueOf(this.gridPeopleService.countSpecialPeople(wgCode) != null ? this.gridPeopleService.countSpecialPeople(wgCode) : 0));
        int houseAllNum = this.gridHouseService.countAll(wgCode);
        res.setHouseAllNum(houseAllNum);
        res.setCompanyAllNum(this.gridCompanyService.countAll(wgCode));
        res.setShopAllNum(this.gridShopService.countAll(wgCode));
        GridRegionSearchParam param = new GridRegionSearchParam();
        param.setLevel("4");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wgCode)) {
            List<String> wgCodes = Arrays.asList(wgCode.split(","));
            param.setWgCodeLikes(wgCodes);
        }
        int wgCount = this.gridRegionMapper.countByParams(param);
        res.setWgCount(wgCount);
        return AjaxResult.success((Object)res);
    }

    @GetMapping(value={"/peopleRkbqList"})
    public AjaxResult peopleRkbqList(@RequestParam(value="wgCode", required=false) String wgCode) {
        List peopleList = this.gridPeopleService.countGridPeople(wgCode);
        ArrayList<CommonCountItem> itemList = new ArrayList<CommonCountItem>();
        if (CollectionUtils.isNotEmpty((Collection)peopleList)) {
            for (Map map : peopleList) {
                CommonCountItem item = new CommonCountItem();
                item.setName(map.get("name").toString());
                item.setNumber((Long)map.get("number"));
                itemList.add(item);
            }
        }
        return AjaxResult.success(itemList);
    }

    @GetMapping(value={"/houseCountList"})
    public AjaxResult houseCountList(@RequestParam(value="wgCode", required=false) String wgCode) {
        List houseList = this.gridHouseService.countGridHouse(wgCode);
        ArrayList<CommonCountItem> itemList = new ArrayList<CommonCountItem>();
        if (CollectionUtils.isNotEmpty((Collection)houseList)) {
            for (Map map : houseList) {
                CommonCountItem item = new CommonCountItem();
                item.setName(map.get("name").toString());
                item.setNumber((Long)map.get("number"));
                itemList.add(item);
            }
        }
        return AjaxResult.success(itemList);
    }

    @GetMapping(value={"/countWsPeopleRklxByGrid"})
    public AjaxResult countWsPeopleRklxByGrid(@RequestParam(value="wgCode", required=false) String wgCode) {
        return AjaxResult.success((Object)this.gridPeopleService.countGridPeopleRklxByGrid(wgCode));
    }

    @GetMapping(value={"/statistic/WsShopTypeNum"})
    public AjaxResult countWsShop(@RequestParam(value="wgCode", required=false) String wgCode) {
        return AjaxResult.success((Object)this.gridShopService.countGridShopFive(wgCode));
    }

    @GetMapping(value={"/infoAll"})
    public AjaxResult infoAll(@RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime) {
        return AjaxResult.success((Object)this.gridWgLogService.infoAll(wgCode, startTime, endTime));
    }

    @GetMapping(value={"/allCompanyList"})
    public AjaxResult getCompanyList(@RequestParam(value="wgCode") String wgCode, @RequestParam(value="value", required=false) String value, @RequestParam(value="name", required=false) String name) {
        GridCompanySearchParam param = new GridCompanySearchParam();
        if (StringUtils.isNotBlank((CharSequence)wgCode)) {
            param.setWgCodeLikes(Arrays.asList(wgCode.split(",")));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
            param.setCompanyName(name);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
            param.setValue(value);
        }
        return AjaxResult.success((Object)this.gridCompanyService.getAllCompanyList(param));
    }

    @RequestMapping(value={"/getRegionByWgcode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getRegionByWgcode(@RequestParam(value="wgCode") String wgCode) {
        GridRegionExample example = new GridRegionExample();
        GridRegionExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo("1");
        if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)wgCode)) {
            return AjaxResult.error((String)"\u7f51\u683ccode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        criteria.andWgCodeEqualTo(wgCode);
        List regionList = this.gridRegionMapper.selectByExample(example);
        return AjaxResult.success(CollectionUtils.isEmpty((Collection)regionList) ? null : regionList.get(0));
    }

    @RequestMapping(value={"/countByWgcode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult countByWgcode(@RequestParam(value="wgCode") String wgCode) {
        GridRegionExample example = new GridRegionExample();
        example.createCriteria().andWgParentIdEqualTo(wgCode).andIsValidEqualTo("1");
        long count = this.gridRegionMapper.countByExample(example);
        return AjaxResult.success((Object)count);
    }

    @RequestMapping(value={"/oneGridUserByWgcode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult oneGridUserByWgcode(@RequestParam(value="wgCode") String wgCode) {
        List bsRegionUsers = this.gridRegionUserMapper.selectOneGridUserByWgCode(wgCode);
        ArrayList<SimpleUserInfo> simpleUserInfoList = new ArrayList<SimpleUserInfo>();
        if (CollectionUtils.isNotEmpty((Collection)bsRegionUsers)) {
            for (GridRegionUser user : bsRegionUsers) {
                SimpleUserInfo simpleUserInfo = this.getSimpleUserInfo(user.getUserId(), user.getWgId());
                if (simpleUserInfo == null) continue;
                simpleUserInfoList.add(simpleUserInfo);
            }
        }
        return AjaxResult.success(simpleUserInfoList);
    }

    @RequestMapping(value={"/twoGridUserByWgcode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult twoGridUserByWgcode(@RequestParam(value="wgCode") String wgCode) {
        ArrayList<SimpleUserInfo> simpleUserInfoList = new ArrayList<SimpleUserInfo>();
        GridRegion gridRegion = this.gridRegionMapper.getWgLevel(wgCode);
        List reginUsers = this.gridRegionUserMapper.selectTwoGridUserByWgCode(wgCode);
        if (CollectionUtils.isNotEmpty((Collection)reginUsers)) {
            for (GridRegionUser user : reginUsers) {
                SimpleUserInfo simpleUserInfo = this.getSimpleUserInfo(user.getUserId(), user.getWgId());
                if (simpleUserInfo == null) continue;
                simpleUserInfoList.add(simpleUserInfo);
            }
        }
        return AjaxResult.success(simpleUserInfoList);
    }

    @RequestMapping(value={"/threeGridUserByWgcode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult threeGridUserByWgcode(@RequestParam(value="wgCode") String wgCode) {
        List threeGirdUser = this.gridRegionUserMapper.selectThreeGirdUserByWgCode(wgCode);
        ArrayList<SimpleUserInfo> simpleUserInfoList = new ArrayList<SimpleUserInfo>();
        if (!threeGirdUser.isEmpty()) {
            for (GridRegionUser bsRegionUser : threeGirdUser) {
                SimpleUserInfo simpleUserInfo = this.getSimpleUserInfo(bsRegionUser.getUserId(), bsRegionUser.getWgId());
                if (simpleUserInfo == null) continue;
                simpleUserInfoList.add(simpleUserInfo);
            }
        }
        return AjaxResult.success(simpleUserInfoList);
    }

    @RequestMapping(value={"/allGridUser"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult allGridUser(@RequestParam(value="wgCode") String wgCode) {
        List<Object> simpleUserInfoList = new ArrayList();
        List threeGirdUser = this.gridRegionUserMapper.selectChildGirdUserByWgCode(wgCode);
        if (CollectionUtils.isNotEmpty((Collection)threeGirdUser)) {
            for (GridRegionUser user : threeGirdUser) {
                SimpleUserInfo simpleUserInfo = this.getSimpleUserInfo(user.getUserId(), user.getWgId());
                if (simpleUserInfo == null) continue;
                simpleUserInfoList.add(simpleUserInfo);
            }
        }
        if (CollectionUtils.isNotEmpty(simpleUserInfoList)) {
            simpleUserInfoList = simpleUserInfoList.stream().sorted(Comparator.comparing(SimpleUserInfo::getWgLevel)).collect(Collectors.toList());
        }
        return AjaxResult.success(simpleUserInfoList);
    }

    private SimpleUserInfo getSimpleUserInfo(String userId, String wgId) {
        SysUser sysUser = this.sysUserService.selectUserById(userId);
        if (sysUser != null) {
            SimpleUserInfo simpleUserInfo = new SimpleUserInfo();
            BeanUtils.copyProperties((Object)sysUser, (Object)simpleUserInfo);
            simpleUserInfo.setWgCode(wgId);
            GridRegion gridRegion = this.gridRegionMapper.getWgLevel(wgId);
            simpleUserInfo.setWgName(gridRegion.getWgName());
            simpleUserInfo.setWgLevel(gridRegion.getLevel());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)gridRegion.getLevel())) {
                if ("2".equals(gridRegion.getLevel())) {
                    simpleUserInfo.setRoleName("\u4e8c\u7ea7\u7f51\u683c\u5458");
                } else {
                    simpleUserInfo.setRoleName("\u4e09\u7ea7\u7f51\u683c\u5458");
                }
            }
            return simpleUserInfo;
        }
        return null;
    }
}

