/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.screen;

import com.google.common.collect.Lists;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.party.domain.ExcellentParty;
import com.ruoyi.party.domain.ExcellentPartyMember;
import com.ruoyi.party.domain.PartyActivity;
import com.ruoyi.party.domain.PartyMember;
import com.ruoyi.party.domain.PartyOrganization;
import com.ruoyi.party.domain.vo.PartyOrganizationVo;
import com.ruoyi.party.service.api.IExcellentPartyMemberService;
import com.ruoyi.party.service.api.IExcellentPartyService;
import com.ruoyi.party.service.api.IPartyActivityService;
import com.ruoyi.party.service.api.IPartyMemberService;
import com.ruoyi.party.service.api.IPartyOrganizationService;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.mapper.system.SysDictDataMapper;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.web.controller.screen.res.CommonPercentCountItem;
import com.ruoyi.web.controller.screen.res.OrgStructureDetail;
import com.ruoyi.web.controller.screen.res.PartyOrganizationDetail;
import com.ruoyi.web.controller.screen.res.PartyStatisticsCommonItem;
import io.swagger.annotations.Api;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5927\u5c4f\u63a5\u53e3-\u515a\u5efa"})
@RestController
@RequestMapping(value={"/api/grid/screen/party"})
public class ScreenPartyController {
    @Autowired
    private IPartyMemberService partyMemberService;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;
    @Autowired
    private IPartyActivityService partyActivityService;
    @Autowired
    private IPartyOrganizationService partyOrganizationService;
    @Autowired
    private IExcellentPartyMemberService excellentPartyMemberService;
    @Autowired
    private IExcellentPartyService excellentPartyService;
    @Autowired
    private GridRegionService gridRegionService;

    @RequestMapping(value={"getDl"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getDl(String orgId) {
        List list = this.partyMemberService.getDl(orgId);
        ArrayList<PartyStatisticsCommonItem> itemList = new ArrayList<PartyStatisticsCommonItem>();
        ArrayList rlist = new ArrayList();
        int wnyxCounts = 0;
        int wdsnCounts = 0;
        int sdswCounts = 0;
        int swdesCounts = 0;
        int esysCounts = 0;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            for (Map map : list) {
                int dYear = 0;
                if (map.get("dyear") != null) {
                    String d = String.valueOf(map.get("dyear"));
                    dYear = Integer.parseInt(d);
                }
                if (dYear < 5) {
                    ++wnyxCounts;
                    continue;
                }
                if (dYear <= 10) {
                    ++wdsnCounts;
                    continue;
                }
                if (dYear <= 15) {
                    ++sdswCounts;
                    continue;
                }
                if (dYear <= 20) {
                    ++swdesCounts;
                    continue;
                }
                ++esysCounts;
            }
        }
        PartyStatisticsCommonItem item1 = new PartyStatisticsCommonItem("5\u5e74\u4ee5\u4e0b", Integer.valueOf(wnyxCounts));
        PartyStatisticsCommonItem item2 = new PartyStatisticsCommonItem("5~10\u5e74", Integer.valueOf(wdsnCounts));
        PartyStatisticsCommonItem item3 = new PartyStatisticsCommonItem("10~15\u5e74", Integer.valueOf(sdswCounts));
        PartyStatisticsCommonItem item4 = new PartyStatisticsCommonItem("15~20\u5e74", Integer.valueOf(swdesCounts));
        PartyStatisticsCommonItem item5 = new PartyStatisticsCommonItem("20\u5e74\u4ee5\u4e0a", Integer.valueOf(esysCounts));
        itemList.add(item1);
        itemList.add(item2);
        itemList.add(item3);
        itemList.add(item4);
        itemList.add(item5);
        return AjaxResult.success(itemList);
    }

    private List<SysDictData> getDataByType(String type) {
        return this.sysDictDataMapper.selectDictDataByType(type);
    }

    @RequestMapping(value={"/getPartyActivity"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getPartyActivity(String orgId) {
        return AjaxResult.success((Object)this.getPartyActivityList(orgId));
    }

    private List<PartyStatisticsCommonItem> getPartyActivityList(String orgId) {
        List sysDictData = this.getDataByType("service_type");
        Map<String, SysDictData> treeMap = sysDictData.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        List list = this.partyActivityService.getPartyActivity(orgId);
        ArrayList<PartyStatisticsCommonItem> itemList = new ArrayList<PartyStatisticsCommonItem>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Map map : list) {
                PartyStatisticsCommonItem item = new PartyStatisticsCommonItem();
                String fwlx = map.get("fwlx").toString();
                if (!treeMap.containsKey(fwlx)) continue;
                item.setType(treeMap.get(fwlx).getDictLabel());
                item.setCount(Integer.valueOf(Integer.parseInt(map.get("count").toString())));
                itemList.add(item);
            }
        }
        return itemList;
    }

    @RequestMapping(value={"/getPartyActivityTop"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getPartyActivityTop(String orgId) {
        List sysDictData = this.getDataByType("service_type");
        Map<String, String> treeMap = sysDictData.stream().collect(Collectors.toMap(SysDictData::getDictValue, SysDictData::getDictLabel));
        ArrayList values = Lists.newArrayList(treeMap.values());
        List itemList = this.getPartyActivityList(orgId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemList)) {
            List keyItemList = itemList.stream().map(PartyStatisticsCommonItem::getType).collect(Collectors.toList());
            values.removeAll(keyItemList);
        }
        if (!CollectionUtils.isEmpty((Collection)values)) {
            for (String key : values) {
                PartyStatisticsCommonItem item = new PartyStatisticsCommonItem(key, Integer.valueOf(0));
                itemList.add(item);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemList)) {
            itemList = itemList.stream().sorted(Comparator.comparing(PartyStatisticsCommonItem::getCount).reversed()).collect(Collectors.toList());
        }
        return AjaxResult.success((Object)itemList);
    }

    @RequestMapping(value={"/getSexCount"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getSexCount() {
        ArrayList<CommonPercentCountItem> itemList = new ArrayList<CommonPercentCountItem>();
        List memberList = this.partyMemberService.selectPartyMemberList(new PartyMember());
        int total = memberList.size();
        itemList.add(new CommonPercentCountItem(Long.valueOf(Long.parseLong(String.valueOf(total))), "\u603b\u8ba1", "100%"));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)memberList)) {
            DecimalFormat decimalFormat = new DecimalFormat("0.00%");
            int nan = memberList.stream().filter(e -> "\u7537".equals(e.getXb())).collect(Collectors.toList()).size();
            int nv = memberList.stream().filter(e -> "\u5973".equals(e.getXb())).collect(Collectors.toList()).size();
            double percent = (double)nan / (double)total;
            double otherPercent = (double)nv / (double)total;
            itemList.add(new CommonPercentCountItem(Long.valueOf(Long.parseLong(String.valueOf(nan))), "\u7537", decimalFormat.format(percent)));
            itemList.add(new CommonPercentCountItem(Long.valueOf(Long.parseLong(String.valueOf(nv))), "\u5973", decimalFormat.format(otherPercent)));
        }
        return AjaxResult.success(itemList);
    }

    @RequestMapping(value={"/getPartyInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getPartyInfo() {
        ArrayList<PartyStatisticsCommonItem> itemList = new ArrayList<PartyStatisticsCommonItem>();
        Integer partyCount = this.partyMemberService.getPartyCount();
        Integer organizationCount = this.partyOrganizationService.countOrg();
        Integer excellentMemberCount = this.excellentPartyMemberService.selectExcellentPartyMemberList(new ExcellentPartyMember()).size();
        Integer excellentPartyCount = this.excellentPartyService.selectExcellentPartyList(new ExcellentParty()).size();
        PartyStatisticsCommonItem item1 = new PartyStatisticsCommonItem("\u515a\u5458\u6570\u91cf", partyCount);
        PartyStatisticsCommonItem item2 = new PartyStatisticsCommonItem("\u515a\u7ec4\u7ec7\u6570\u91cf", organizationCount);
        PartyStatisticsCommonItem item3 = new PartyStatisticsCommonItem("\u4f18\u79c0\u515a\u5458", excellentMemberCount);
        PartyStatisticsCommonItem item4 = new PartyStatisticsCommonItem("\u4f18\u79c0\u515a\u652f\u90e8", excellentPartyCount);
        itemList.add(item1);
        itemList.add(item2);
        itemList.add(item3);
        itemList.add(item4);
        return AjaxResult.success(itemList);
    }

    @RequestMapping(value={"/getAgeStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getAgeStatistics() {
        List ageList = this.partyMemberService.getAgeList();
        ArrayList<PartyStatisticsCommonItem> itemList = new ArrayList<PartyStatisticsCommonItem>();
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        int count4 = 0;
        int count5 = 0;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ageList)) {
            count1 = (int)ageList.stream().filter(e -> Integer.parseInt(e) < 20).count();
            count2 = (int)ageList.stream().filter(e -> Integer.parseInt(e) >= 20 && Integer.parseInt(e) < 30).count();
            count3 = (int)ageList.stream().filter(e -> Integer.parseInt(e) >= 30 && Integer.parseInt(e) < 40).count();
            count4 = (int)ageList.stream().filter(e -> Integer.parseInt(e) >= 40 && Integer.parseInt(e) < 50).count();
            count5 = (int)ageList.stream().filter(e -> Integer.parseInt(e) >= 50).count();
        }
        PartyStatisticsCommonItem item1 = new PartyStatisticsCommonItem("20\u5c81\u4ee5\u4e0b", Integer.valueOf(count1));
        PartyStatisticsCommonItem item2 = new PartyStatisticsCommonItem("20~30\u5c81", Integer.valueOf(count2));
        PartyStatisticsCommonItem item3 = new PartyStatisticsCommonItem("30~40\u5c81", Integer.valueOf(count3));
        PartyStatisticsCommonItem item4 = new PartyStatisticsCommonItem("40~50\u5c81", Integer.valueOf(count4));
        PartyStatisticsCommonItem item5 = new PartyStatisticsCommonItem("50\u5c81\u4ee5\u4e0a", Integer.valueOf(count5));
        itemList.add(item1);
        itemList.add(item2);
        itemList.add(item3);
        itemList.add(item4);
        itemList.add(item5);
        return AjaxResult.success(itemList);
    }

    @GetMapping(value={"/excellentMemberList"})
    @ResponseBody
    public AjaxResult excellentMemberList() {
        List list = this.excellentPartyMemberService.selectExcellentPartyMemberList(new ExcellentPartyMember());
        return AjaxResult.success((Object)list);
    }

    @GetMapping(value={"/activityList"})
    @ResponseBody
    public AjaxResult activityList(String orgId) {
        List sysDictData = this.getDataByType("service_type");
        Map<String, SysDictData> treeMap = sysDictData.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        PartyActivity partyActivity = new PartyActivity();
        partyActivity.setSsdzzmc(orgId);
        List list = this.partyActivityService.selectPartyActivityList(partyActivity);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getFwlx()) && treeMap.containsKey(e.getFwlx())) {
                    e.setFwlxString(((SysDictData)treeMap.get(e.getFwlx())).getDictLabel());
                }
            });
        }
        return AjaxResult.success((Object)list);
    }

    @GetMapping(value={"/orgList"})
    @ResponseBody
    public AjaxResult orgList(String wgCode, String name) {
        PartyOrganization partyOrganization = new PartyOrganization();
        if (StringUtils.isNotBlank((CharSequence)wgCode)) {
            partyOrganization.setSswg(wgCode);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            partyOrganization.setDzzmc(name);
        }
        List list = this.partyOrganizationService.selectPartyOrganizationList(partyOrganization);
        return AjaxResult.success((Object)list);
    }

    @GetMapping(value={"/orgStructureDetail"})
    @ResponseBody
    public AjaxResult orgStructureDetail(String orgId) {
        List memberList;
        List sysDictData = this.getDataByType("party_org_type");
        Map<String, SysDictData> treeMap = sysDictData.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        OrgStructureDetail detail = new OrgStructureDetail();
        PartyOrganization partyOrganization = this.partyOrganizationService.getByDzzdm(orgId);
        if (partyOrganization == null) {
            return AjaxResult.success((Object)new OrgStructureDetail());
        }
        if (StringUtils.isNotBlank((CharSequence)partyOrganization.getDzzsj())) {
            detail.setName(partyOrganization.getDzzsj());
            detail.setPhone(partyOrganization.getDzzlxdh());
            PartyMember partyMember2 = new PartyMember();
            partyMember2.setMz(partyOrganization.getDzzsj());
            partyMember2.setDzzmc(orgId);
            memberList = this.partyMemberService.selectPartyMemberList(partyMember2);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)memberList)) {
                detail.setPic(((PartyMember)memberList.get(0)).getDyphoto());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)partyOrganization.getZzlb()) && treeMap.containsKey(partyOrganization.getZzlb())) {
            detail.setOrgType(treeMap.get(partyOrganization.getZzlb()).getDictLabel());
        }
        PartyMember partyMember = new PartyMember();
        partyMember.setDzzmc(orgId);
        memberList = this.partyMemberService.selectPartyMemberList(partyMember);
        detail.setPartyCount(Integer.valueOf(memberList.size()));
        return AjaxResult.success((Object)detail);
    }

    @GetMapping(value={"/org/detail/{orgId}"})
    public AjaxResult getOrgInfo(@PathVariable(value="orgId") String orgId) {
        List ortTypeList = this.getDataByType("party_org_type");
        List sdgxTypeList = this.getDataByType("sdgx_type");
        PartyOrganization partyOrganization = this.partyOrganizationService.getByDzzdm(orgId);
        if (partyOrganization == null) {
            return AjaxResult.error((String)"\u515a\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        PartyOrganizationVo partyOrganizationVo = this.partyOrganizationService.selectPartyOrganizationById(partyOrganization.getId().toString());
        Map<String, SysDictData> orgMap = ortTypeList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        Map<String, SysDictData> sdgxMap = sdgxTypeList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        if (StringUtils.isNotBlank((CharSequence)partyOrganizationVo.getSdgx())) {
            SysDictData sdgx = sdgxMap.get(partyOrganizationVo.getSdgx());
            partyOrganizationVo.setSdgxName(sdgx == null ? "" : sdgx.getDictLabel());
        }
        if (StringUtils.isNotBlank((CharSequence)partyOrganizationVo.getZzlb())) {
            SysDictData zzlb = orgMap.get(partyOrganizationVo.getZzlb());
            partyOrganizationVo.setZzlbName(zzlb == null ? "" : zzlb.getDictLabel());
        }
        PartyOrganizationDetail detail = new PartyOrganizationDetail();
        BeanUtils.copyProperties((Object)partyOrganizationVo, (Object)detail);
        if (StringUtils.isNotBlank((CharSequence)detail.getSswg())) {
            GridRegion gridRegion = this.gridRegionService.getWgByCode(detail.getSswg());
            detail.setWgName(gridRegion == null ? "" : gridRegion.getWgName());
        }
        return AjaxResult.success((Object)detail);
    }

    @GetMapping(value={"/partyMemberList/{orgId}"})
    public AjaxResult getPartyMemberList(@PathVariable(value="orgId") String orgId) {
        PartyOrganization partyOrganization = this.partyOrganizationService.getByDzzdm(orgId);
        if (partyOrganization == null) {
            return AjaxResult.error((String)"\u515a\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        String name = partyOrganization.getDzzmc();
        PartyMember partyMember = new PartyMember();
        partyMember.setDzzmc(orgId);
        List partyMemberList = this.partyMemberService.selectPartyMemberList(partyMember);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)partyMemberList)) {
            partyMemberList.forEach(e -> e.setDzzmc(name));
        }
        return AjaxResult.success((Object)partyMemberList);
    }
}

