/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.screen;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.party.domain.PartyOrganization;
import com.ruoyi.party.service.api.IPartyOrganizationService;
import com.ruoyi.system.domain.grid.GridCompanyEconomyInfo;
import com.ruoyi.system.domain.grid.GridCompanyEconomyInfoExample;
import com.ruoyi.system.domain.grid.GridCompanyExample;
import com.ruoyi.system.domain.grid.GridCompanyLand;
import com.ruoyi.system.domain.grid.GridCompanyPeople;
import com.ruoyi.system.domain.grid.GridGroupLand;
import com.ruoyi.system.domain.grid.GridGroupLandExample;
import com.ruoyi.system.domain.grid.GridHouseExample;
import com.ruoyi.system.domain.grid.GridInterviewExample;
import com.ruoyi.system.domain.grid.GridPeople;
import com.ruoyi.system.domain.grid.GridPeopleExample;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.GridRegionUserExample;
import com.ruoyi.system.domain.grid.GridShop;
import com.ruoyi.system.domain.grid.GridShopExample;
import com.ruoyi.system.domain.grid.GridShopStaff;
import com.ruoyi.system.domain.grid.GridShopStaffExample;
import com.ruoyi.system.domain.grid.ext.GridCompanyExt;
import com.ruoyi.system.domain.grid.ext.GridCompanyLandExt;
import com.ruoyi.system.domain.grid.ext.GridHouseExt;
import com.ruoyi.system.domain.grid.ext.GridPeopleExt;
import com.ruoyi.system.mapper.grid.GridCompanyEconomyInfoExtMapper;
import com.ruoyi.system.mapper.grid.GridCompanyEconomyInfoMapper;
import com.ruoyi.system.mapper.grid.GridCompanyLandExtMapper;
import com.ruoyi.system.service.grid.GridCompanyLandService;
import com.ruoyi.system.service.grid.GridCompanyPeopleService;
import com.ruoyi.system.service.grid.GridCompanyService;
import com.ruoyi.system.service.grid.GridGroupLandService;
import com.ruoyi.system.service.grid.GridGroupService;
import com.ruoyi.system.service.grid.GridHouseService;
import com.ruoyi.system.service.grid.GridInterviewService;
import com.ruoyi.system.service.grid.GridPeopleService;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.grid.GridShopService;
import com.ruoyi.system.service.grid.GridShopStaffService;
import com.ruoyi.system.service.other.BsCommonService;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.video.VideoDeviceChannelService;
import com.ruoyi.web.controller.screen.res.CommonPeopleItem;
import com.ruoyi.web.controller.screen.res.GridBasicInfo;
import com.ruoyi.web.controller.screen.res.GridCompanyLandWithEcoExt;
import com.ruoyi.web.controller.screen.res.GridRegionExtInfo;
import com.ruoyi.web.controller.screen.res.LandDetail;
import io.swagger.annotations.Api;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5927\u5c4f\u63a5\u53e3-\u6570\u5b57\u56fe\u5c42"})
@RestController
@RequestMapping(value={"/api/grid/screen/number"})
public class ScreenNumberController {
    @Autowired
    private GridCompanyPeopleService gridCompanyPeopleService;
    @Autowired
    private BsCommonService bsCommonService;
    @Autowired
    private GridRegionService gridRegionService;
    @Autowired
    private GridPeopleService gridPeopleService;
    @Autowired
    private GridHouseService gridHouseService;
    @Autowired
    private GridInterviewService gridInterviewService;
    @Autowired
    private GridCompanyService gridCompanyService;
    @Autowired
    private GridShopService gridShopService;
    @Autowired
    private IPartyOrganizationService partyOrganizationService;
    @Autowired
    private VideoDeviceChannelService videoDeviceChannelService;
    @Autowired
    private GridShopStaffService gridShopStaffService;
    @Autowired
    private GridCompanyEconomyInfoExtMapper wsCompanyEconomyInfoExtMapper;
    @Autowired
    private GridCompanyLandExtMapper gridCompanyLandExtMapper;
    @Autowired
    private GridGroupLandService gridGroupLandService;
    @Autowired
    private GridGroupService gridGroupService;
    @Autowired
    private GridCompanyLandService gridCompanyLandService;
    @Autowired
    private GridRegionUserService gridRegionUserService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    GridCompanyLandExtMapper wsCompanyLandExtMapper;
    @Autowired
    GridCompanyEconomyInfoMapper wsCompanyEconomyInfoMapper;

    @GetMapping(value={"/infoAll"})
    public AjaxResult infoAll(@RequestParam(value="wgCode") String wgCode) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        GridRegionExample wgsExample = new GridRegionExample();
        wgsExample.createCriteria().andIsValidEqualTo("1").andWgTypeEqualTo("1").andWgCodeLike(wgCode + "%").andLevelEqualTo("3");
        long wgsCount = this.gridRegionService.countByExample((Object)wgsExample);
        GridRegionExample dksExample = new GridRegionExample();
        dksExample.createCriteria().andIsValidEqualTo("1").andWgTypeEqualTo("1").andWgCodeLike(wgCode + "%").andLevelEqualTo("4");
        long dksCount = this.gridRegionService.countByExample((Object)dksExample);
        GridRegionExample regionExample = new GridRegionExample();
        regionExample.createCriteria().andIsValidEqualTo("1").andWgTypeEqualTo("1").andWgCodeLike(wgCode + "%").andLevelEqualTo("3").andYlzd2EqualTo("1");
        long zsCount = this.gridRegionService.countByExample((Object)regionExample);
        map.put("jjDk", dksCount);
        map.put("zsWg", zsCount);
        map.put("jcWg", wgsCount - zsCount);
        map.put("company", this.gridCompanyService.countAll(wgCode));
        map.put("shop", this.gridShopService.countAll(wgCode));
        PartyOrganization partyOrganization = new PartyOrganization();
        partyOrganization.setSswg(wgCode);
        List partyOrganizationList = this.partyOrganizationService.selectPartyOrganizationList(partyOrganization);
        map.put("org", partyOrganizationList.size());
        map.put("video", this.videoDeviceChannelService.getVideoCount(null));
        return AjaxResult.success(map);
    }

    @GetMapping(value={"/companyToPeopleList"})
    public AjaxResult companyToPeoplePage(@RequestParam(value="companyId") String companyId) {
        List companyPeopleList = this.gridCompanyPeopleService.selectGridCompanyPeopleByCompanyId(companyId, null, null);
        ArrayList<CommonPeopleItem> companyPeopleExtList = new ArrayList<CommonPeopleItem>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)companyPeopleList)) {
            for (GridCompanyPeople people : companyPeopleList) {
                CommonPeopleItem item = new CommonPeopleItem();
                GridPeople gridPeople = (GridPeople)this.gridPeopleService.selectByPrimaryKey(people.getPeopleId());
                if (gridPeople == null) continue;
                item.setName(gridPeople.getPersonName());
                item.setSex(gridPeople.getSex());
                if (StringUtils.isNotBlank((String)gridPeople.getWgCode())) {
                    item.setWgName(this.gridRegionService.getWgName(gridPeople.getWgCode()));
                }
                if (StringUtils.isNotBlank((String)gridPeople.getRklxCode())) {
                    item.setRklxValue(this.bsCommonService.getName(gridPeople.getRklxCode()));
                }
                companyPeopleExtList.add(item);
            }
        }
        return AjaxResult.success(companyPeopleExtList);
    }

    @GetMapping(value={"/interview/list"})
    public AjaxResult companyInterviewList(@RequestParam(value="id") String id) {
        GridInterviewExample ex = new GridInterviewExample();
        GridInterviewExample.Criteria ca = ex.createCriteria();
        ca.andCidEqualTo(id);
        ex.setOrderByClause(" interview_time desc, create_time desc ");
        List list = this.gridInterviewService.selectByExample((Object)ex);
        return AjaxResult.success((Object)list);
    }

    @GetMapping(value={"/shop/list"})
    public AjaxResult shopList(String wgCode, String name) {
        List gridShops = this.gridShopService.getAllShopPointList(wgCode, name);
        return AjaxResult.success((Object)gridShops);
    }

    @GetMapping(value={"/region/list"})
    public AjaxResult regionList(@RequestParam(value="type") String type, String wgCode, String name) {
        GridRegionExample wgsExample = new GridRegionExample();
        GridRegionExample.Criteria criteria = wgsExample.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andWgTypeEqualTo("1");
        if (StringUtils.isNotBlank((String)wgCode)) {
            criteria.andWgCodeLike(wgCode + "%");
        }
        if (StringUtils.isNotBlank((String)name)) {
            criteria.andWgNameLike("%" + name + "%");
        }
        if ("1".equals(type)) {
            criteria.andLevelEqualTo("3");
            criteria.andYlzd2NotEqualTo("1");
        } else if ("2".equals(type)) {
            criteria.andLevelEqualTo("3");
            criteria.andYlzd2EqualTo("1");
        } else {
            criteria.andLevelEqualTo("4");
        }
        criteria.andWgCentreCoordinateIsNotNull();
        criteria.andWgCentreCoordinateNotEqualTo("");
        List gridRegionList = this.gridRegionService.selectByExample((Object)wgsExample);
        List infoList = BeanCopyUtil.bathToBean((Collection)gridRegionList, GridRegionExtInfo.class);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)infoList)) {
            infoList.forEach(e -> {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)e.getWgCoordinate())) {
                    String point = "MULTILINESTRING((" + e.getWgCoordinate().replaceAll("\\|", " ") + "))";
                    e.setWgCoordinate(point);
                }
                if (StringUtils.isNotBlank((String)e.getWgCentreCoordinate()) && e.getWgCentreCoordinate().contains("|")) {
                    String longitude = e.getWgCentreCoordinate().substring(0, e.getWgCentreCoordinate().indexOf("|"));
                    String latitude = e.getWgCentreCoordinate().substring(e.getWgCentreCoordinate().indexOf("|") + 1);
                    e.setLongitude(longitude);
                    e.setLatitude(latitude);
                    String point = e.getWgCentreCoordinate().replaceAll("\\|", " ");
                    e.setWgCentreCoordinate(point);
                }
            });
        }
        return AjaxResult.success((Object)infoList);
    }

    @GetMapping(value={"/shop/{id}"})
    public AjaxResult getShopById(@PathVariable(value="id") Long id) throws Exception {
        GridShop gridShop = this.gridShopService.getGridShopById(id);
        gridShop.setOtherappAttachments(null);
        return AjaxResult.success((Object)gridShop);
    }

    @GetMapping(value={"/listGridShopPeople"})
    public AjaxResult ListGridPeople(@RequestParam(value="shopId") Long shopId) {
        GridShopStaffExample shopStaffExample = new GridShopStaffExample();
        GridShopStaffExample.Criteria criteria = shopStaffExample.createCriteria();
        criteria.andShopIdEqualTo(shopId);
        criteria.andValidEqualTo(Byte.valueOf("1"));
        List wsShopStaffs = this.gridShopStaffService.selectByExample((Object)shopStaffExample);
        ArrayList<CommonPeopleItem> itemList = new ArrayList<CommonPeopleItem>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)wsShopStaffs)) {
            for (GridShopStaff people : wsShopStaffs) {
                CommonPeopleItem item = new CommonPeopleItem();
                GridPeople gridPeople = (GridPeople)this.gridPeopleService.selectByPrimaryKey(people.getPeopleId());
                if (gridPeople == null) continue;
                item.setName(gridPeople.getPersonName());
                item.setSex(gridPeople.getSex());
                if (StringUtils.isNotBlank((String)gridPeople.getWgCode())) {
                    item.setWgName(this.gridRegionService.getWgName(gridPeople.getWgCode()));
                }
                if (StringUtils.isNotBlank((String)gridPeople.getRklxCode())) {
                    item.setRklxValue(this.bsCommonService.getName(gridPeople.getRklxCode()));
                }
                itemList.add(item);
            }
        }
        return AjaxResult.success(itemList);
    }

    @GetMapping(value={"/land/detail"})
    public AjaxResult landDetail(String landId, String year) {
        Map saleAndTaxAndPerMuCountMap;
        GridRegion gridRegion = (GridRegion)this.gridRegionService.selectByPrimaryKey(landId);
        if (gridRegion == null) {
            return AjaxResult.error((String)"\u5730\u5757\u4e0d\u5b58\u5728");
        }
        LandDetail detail = new LandDetail();
        detail.setLandId(landId);
        detail.setName(gridRegion.getWgName());
        detail.setArea(gridRegion.getWgArea());
        detail.setPurpose(gridRegion.getWgPurpose());
        List wsCompanyLandExtList = this.gridCompanyLandExtMapper.getList(null, landId, null);
        if (!CollectionUtils.isEmpty((Collection)wsCompanyLandExtList) && !(saleAndTaxAndPerMuCountMap = this.wsCompanyEconomyInfoExtMapper.sumSaleAndTaxAndPerMu(wsCompanyLandExtList.stream().map(GridCompanyLand::getCompanyId).collect(Collectors.toList()), year)).isEmpty()) {
            detail.setTax(saleAndTaxAndPerMuCountMap.get("perMuCount").toString());
        }
        return AjaxResult.success((Object)detail);
    }

    @GetMapping(value={"/land/group/list"})
    public AjaxResult landGroupList(String landId) {
        GridGroupLandExample example = new GridGroupLandExample();
        GridGroupLandExample.Criteria criteria = example.createCriteria();
        criteria.andLandIdEqualTo(landId);
        List gridGroupLandList = this.gridGroupLandService.selectByExample((Object)example);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)gridGroupLandList)) {
            GridGroupLand wsGroupLand = (GridGroupLand)gridGroupLandList.get(0);
            GridGroupLandExample wsGroupLandExample1 = new GridGroupLandExample();
            wsGroupLandExample1.createCriteria().andGroupIdEqualTo(wsGroupLand.getGroupId());
            List groupLands = this.gridGroupLandService.selectByExample((Object)wsGroupLandExample1);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)groupLands)) {
                ArrayList<String> landIds = new ArrayList<String>();
                for (GridGroupLand wsGroupLand1 : groupLands) {
                    if (landId.equals(wsGroupLand1.getLandId())) continue;
                    landIds.add(wsGroupLand1.getLandId());
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(landIds)) {
                    GridRegionExample bsWgxxbExample = new GridRegionExample();
                    bsWgxxbExample.createCriteria().andIdIn(landIds).andIsValidEqualTo("1");
                    List bsWgxxbs = this.gridRegionService.selectByExample((Object)bsWgxxbExample);
                    return AjaxResult.success((Object)bsWgxxbs);
                }
            }
        }
        return AjaxResult.success(new ArrayList());
    }

    @GetMapping(value={"/land/company/list"})
    public AjaxResult landCompanyList(String landId, String year) {
        GridRegion region = (GridRegion)this.gridRegionService.selectByPrimaryKey(landId);
        if (region == null) {
            throw new RuntimeException("\u67e5\u8be2\u5931\u8d25\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u5730\u5757");
        }
        if (StringUtils.isBlank((String)year)) {
            LocalDate localDate = LocalDate.now();
            year = String.valueOf(localDate.getYear());
        }
        ArrayList<GridCompanyLandWithEcoExt> exts = new ArrayList<GridCompanyLandWithEcoExt>();
        List wsCompanyLandExtList = this.wsCompanyLandExtMapper.getList(null, region.getId(), null);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)wsCompanyLandExtList)) {
            ArrayList<String> companyIds = new ArrayList<String>();
            for (GridCompanyLandExt wsCompanyLandExt : wsCompanyLandExtList) {
                companyIds.add(wsCompanyLandExt.getCompanyId());
                GridCompanyLandWithEcoExt wsCompanyLandWithEcoExt = (GridCompanyLandWithEcoExt)BeanCopyUtil.toBean((Object)wsCompanyLandExt, GridCompanyLandWithEcoExt.class);
                exts.add(wsCompanyLandWithEcoExt);
            }
            GridCompanyEconomyInfoExample wsCompanyEconomyInfoExample = new GridCompanyEconomyInfoExample();
            wsCompanyEconomyInfoExample.createCriteria().andCompanyIdIn(companyIds).andIsValidEqualTo("1").andYearEqualTo(year);
            List wsCompanyEconomyInfos = this.wsCompanyEconomyInfoMapper.selectByExample(wsCompanyEconomyInfoExample);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)wsCompanyEconomyInfos)) {
                block1: for (GridCompanyLandWithEcoExt ext : exts) {
                    for (GridCompanyEconomyInfo info : wsCompanyEconomyInfos) {
                        if (!ext.getCompanyId().equals(info.getCompanyId())) continue;
                        ext.setPerMu(info.getPerMu());
                        ext.setSale(info.getSale());
                        ext.setTax(info.getTax());
                        continue block1;
                    }
                }
            }
        }
        return AjaxResult.success(exts);
    }

    @GetMapping(value={"/regionDetail"})
    public AjaxResult regionDetail(String wgCode) {
        SysUser sysUser;
        GridRegion region = this.gridRegionService.getWgByCode(wgCode);
        GridBasicInfo basicInfo = new GridBasicInfo();
        basicInfo.setWgCode(wgCode);
        basicInfo.setWgName(region.getWgName());
        GridRegionUserExample example = new GridRegionUserExample();
        GridRegionUserExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andWgIdEqualTo(wgCode);
        GridRegionUser regionUser = (GridRegionUser)this.gridRegionUserService.selectFirstByExample((Object)example);
        if (regionUser != null && (sysUser = this.sysUserService.selectUserById(regionUser.getUserId())) != null) {
            basicInfo.setRegionUserName(sysUser.getNickName());
            basicInfo.setUserPhone(sysUser.getPhonenumber());
        }
        return AjaxResult.success((Object)basicInfo);
    }

    @GetMapping(value={"/region/obj/list"})
    public AjaxResult regionObjList(@RequestParam(value="type") String type, @RequestParam(value="wgCode") String wgCode) {
        if ("1".equals(type)) {
            GridCompanyExample example = new GridCompanyExample();
            GridCompanyExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo(Byte.valueOf("1"));
            criteria.andWgCodeEqualTo(wgCode);
            List list = this.gridCompanyService.selectByExample((Object)example);
            List itemList = BeanCopyUtil.bathToBean((Collection)list, GridCompanyExt.class);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemList)) {
                itemList.forEach(e -> {
                    if (StringUtils.isNotBlank((String)e.getQylxCode())) {
                        e.setQylxValue(this.bsCommonService.getName(e.getQylxCode()));
                    }
                });
            }
            return AjaxResult.success((Object)itemList);
        }
        if ("2".equals(type)) {
            GridShopExample example = new GridShopExample();
            GridShopExample.Criteria criteria = example.createCriteria();
            criteria.andValidEqualTo(Byte.valueOf("1"));
            criteria.andWgCodeEqualTo(wgCode);
            List shopList = this.gridShopService.selectByExample((Object)example);
            return AjaxResult.success((Object)shopList);
        }
        if ("3".equals(type)) {
            GridHouseExample example = new GridHouseExample();
            GridHouseExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo(Byte.valueOf("1"));
            criteria.andWgCodeEqualTo(wgCode);
            List list = this.gridHouseService.selectByExample((Object)example);
            List itemList = BeanCopyUtil.bathToBean((Collection)list, GridHouseExt.class);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemList)) {
                itemList.forEach(e -> {
                    if (StringUtils.isNotBlank((String)e.getFwlxCode())) {
                        e.setFwlxValue(this.bsCommonService.getName(e.getFwlxCode()));
                    }
                });
            }
            return AjaxResult.success((Object)itemList);
        }
        GridPeopleExample example = new GridPeopleExample();
        GridPeopleExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo(Byte.valueOf("1"));
        criteria.andWgCodeEqualTo(wgCode);
        List list = this.gridPeopleService.selectByExample((Object)example);
        List itemList = BeanCopyUtil.bathToBean((Collection)list, GridPeopleExt.class);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemList)) {
            itemList.forEach(e -> {
                if (StringUtils.isNotBlank((String)e.getRklxCode())) {
                    e.setRklxValue(this.bsCommonService.getName(e.getRklxCode()));
                }
            });
        }
        return AjaxResult.success((Object)itemList);
    }

    @GetMapping(value={"/companyPointList"})
    public AjaxResult companyPointList(@RequestParam(value="wgCode") String wgCode, @RequestParam(value="name", required=false) String name) {
        return AjaxResult.success((Object)this.gridCompanyService.companyPointList(wgCode, name));
    }

    @GetMapping(value={"/getChildGridRegion"})
    public AjaxResult getChildGridRegion(@RequestParam(value="wgCode") String wgCode) {
        return AjaxResult.success((Object)this.gridRegionService.getChildGridRegion(wgCode));
    }
}

