/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.screen;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.ext.GridCompanyEconomyPermuItem;
import com.ruoyi.system.domain.grid.vo.GridEconomyPerMuItem;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.service.grid.GridCompanyEconomyInfoService;
import com.ruoyi.system.service.grid.GridCompanyLandRemarkService;
import com.ruoyi.system.service.grid.GridCompanyLandService;
import com.ruoyi.system.service.grid.GridRegionFacadeService;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5927\u5c4f\u63a5\u53e3-\u7ecf\u6d4e\u8fd0\u884c"})
@RestController
@RequestMapping(value={"/api/grid/screen/economy"})
public class ScreenEconomyController {
    @Autowired
    private GridRegionMapper gridRegionMapper;
    @Autowired
    private GridCompanyEconomyInfoService gridCompanyEconomyInfoService;
    @Autowired
    private GridCompanyLandService gridCompanyLandService;
    @Autowired
    private GridCompanyLandRemarkService gridCompanyLandRemarkService;
    @Autowired
    private GridRegionFacadeService gridRegionFacadeService;

    @RequestMapping(value={"/pointList"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getEconomyPointList(@RequestParam(value="perMuRangeStart") String perMuRangeStart, @RequestParam(value="perMuRangeEnd") String perMuRangeEnd, @RequestParam(value="year") String year) {
        return AjaxResult.success((Object)this.gridRegionFacadeService.getEconomyPointList(perMuRangeStart, perMuRangeEnd, year));
    }

    @GetMapping(value={"/info/list"})
    public AjaxResult ecoInfoList(@RequestParam(value="type") String type, @RequestParam(value="year", required=false) String year, @RequestParam(value="searchName", required=false) String searchName) {
        if (StringUtils.isBlank((String)type)) {
            return AjaxResult.error((int)400, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        if (StringUtils.isBlank((String)year)) {
            LocalDate localDate = LocalDate.now();
            year = String.valueOf(localDate.getYear());
        }
        return AjaxResult.success((Object)this.gridCompanyEconomyInfoService.loadCompanyEcoInfos(type, year, searchName));
    }

    @GetMapping(value={"/perMu/count"})
    public AjaxResult perMuCount(@RequestParam(value="year", required=false) String year) {
        if (StringUtils.isBlank((String)year)) {
            LocalDate localDate = LocalDate.now();
            year = String.valueOf(localDate.getYear());
        }
        List list = this.gridCompanyEconomyInfoService.listPerMuByYear(year);
        GridCompanyEconomyPermuItem totalBean = new GridCompanyEconomyPermuItem();
        totalBean.setCountCode("total");
        totalBean.setCountName("\u603b\u6570");
        totalBean.setNum(Integer.valueOf(list.stream().mapToInt(GridCompanyEconomyPermuItem::getNum).sum()));
        list.add(totalBean);
        return AjaxResult.success((Object)list);
    }

    @GetMapping(value={"/permuSort/list"})
    public AjaxResult permuSortList(@RequestParam(value="year", required=false) String year) {
        LocalDate nowDate = LocalDate.now();
        String lastYear = "";
        if (StringUtils.isBlank((String)year)) {
            year = String.valueOf(nowDate.getYear());
            lastYear = String.valueOf(nowDate.minusYears(1L).getYear());
        } else {
            lastYear = String.valueOf(Integer.parseInt(year) - 1);
        }
        List currentList = this.gridCompanyLandService.permuSortList(year);
        List lastList = this.gridCompanyLandService.permuSortList(lastYear);
        if (!CollectionUtils.isEmpty((Collection)currentList)) {
            Map<Object, Object> lastYearMap = new LinkedHashMap();
            if (!CollectionUtils.isEmpty((Collection)lastList)) {
                lastYearMap = lastList.stream().collect(Collectors.toMap(GridEconomyPerMuItem::getId, Function.identity()));
            }
            for (GridEconomyPerMuItem item : currentList) {
                if (lastYearMap.isEmpty() || !lastYearMap.containsKey(item.getId())) continue;
                GridEconomyPerMuItem lastItem = (GridEconomyPerMuItem)lastYearMap.get(item.getId());
                BigDecimal currentPerMu = BigDecimal.valueOf(item.getPerMuSum());
                BigDecimal lastPerMu = BigDecimal.valueOf(lastItem.getPerMuSum());
                if (lastPerMu.compareTo(BigDecimal.ZERO) == 0) {
                    item.setPercent("100%");
                    continue;
                }
                BigDecimal cha = currentPerMu.subtract(lastPerMu);
                if (cha.compareTo(new BigDecimal(0)) < 0) {
                    item.setUpFlag(false);
                }
                BigDecimal percent = cha.abs().divide(lastPerMu, 2, RoundingMode.HALF_UP);
                item.setPercent(percent + "%");
            }
        }
        return AjaxResult.success((Object)currentList);
    }
}

