/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.screen;

import com.alibaba.fastjson2.JSON;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.task.TkCommonAssigned;
import com.ruoyi.system.domain.task.TkCommonAssignedExample;
import com.ruoyi.system.domain.task.TkCommonTask;
import com.ruoyi.system.domain.task.TkCommonTaskDynamicExample;
import com.ruoyi.system.domain.visit.VisitPlanTaskExample;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.mapper.task.ext.TkCommonTaskExtMapper;
import com.ruoyi.system.mapper.visit.VisitPlanTaskMapper;
import com.ruoyi.system.service.grid.GridHouseService;
import com.ruoyi.system.service.grid.GridPeopleService;
import com.ruoyi.system.service.grid.GridRegionFacadeService;
import com.ruoyi.system.service.task.TkCommonAssignedService;
import com.ruoyi.system.service.task.TkCommonTaskDynamicService;
import com.ruoyi.system.service.task.TkCommonTaskService;
import com.ruoyi.system.service.visit.VisitFreeInterviewService;
import com.ruoyi.system.service.visit.VisitPlanService;
import com.ruoyi.web.controller.screen.res.GridRegionExtInfo;
import io.swagger.annotations.Api;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5927\u5c4f\u63a5\u53e3-\u7f51\u683c\u5efa\u8bbe"})
@RestController
@RequestMapping(value={"/api/grid/screen/build"})
public class ScreenBuildController
extends BaseController {
    @Autowired
    private GridPeopleService gridPeopleService;
    @Autowired
    private GridHouseService gridHouseService;
    @Autowired
    private VisitPlanService visitPlanService;
    @Autowired
    private GridRegionFacadeService gridRegionFacadeService;
    @Autowired
    private TkCommonTaskService tkCommonTaskService;
    @Autowired
    private GridRegionMapper gridRegionMapper;
    @Autowired
    private VisitPlanTaskMapper visitPlanTaskMapper;
    @Autowired
    private VisitFreeInterviewService visitFreeInterviewService;
    @Autowired
    TkCommonTaskExtMapper tkCommonTaskExtMapper;
    @Autowired
    TkCommonTaskDynamicService tkCommonTaskDynamicService;
    @Autowired
    TkCommonAssignedService tkCommonAssignedService;

    @RequestMapping(value={"/planTaskList"}, method={RequestMethod.GET})
    public AjaxResult planTaskForPage(@RequestParam(value="visitType") String visitType, @RequestParam(value="wgCode", required=false) String wgCode) {
        LocalDate nowDate = LocalDate.now();
        String dateStr = nowDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate threeDateBefore = nowDate.minusMonths(10L);
        String threeDateStr = threeDateBefore.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return AjaxResult.success((Object)this.visitFreeInterviewService.interviewList(visitType, wgCode, threeDateStr, dateStr));
    }

    @RequestMapping(value={"/getWsParentRegionAndCount"}, method={RequestMethod.GET})
    @ResponseBody
    public String getWsParentRegionAndCount(@RequestParam(value="wgCode", required=false) String wgCode) {
        AjaxResult result = new AjaxResult();
        this.gridRegionFacadeService.getWsParentRegionAndCount(wgCode, result);
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(value={"areaTaskNum"}, method={RequestMethod.GET})
    @ResponseBody
    public String areaTaskNum(String wgCode, String dateType) {
        HashedMap map = new HashedMap();
        DecimalFormat df = new DecimalFormat("0.00");
        Date startDate = DateUtils.getBeginDayOfWeek();
        Date endDate = DateUtils.getEndDayOfWeek();
        if (StringUtils.isBlank((CharSequence)dateType)) {
            dateType = "1";
        }
        if ("2".equals(dateType)) {
            startDate = DateUtils.getBeginDayOfMonth();
            endDate = DateUtils.getEndDayOfMonth();
        } else if ("3".equals(dateType)) {
            startDate = DateUtils.getCurrYearFirst();
            endDate = DateUtils.getCurrYearLast();
        }
        int count = this.tkCommonTaskExtMapper.countByReleaseTimeAndUserId(startDate, endDate, null, null, null);
        map.put("allCount", count);
        int endCount = this.tkCommonTaskExtMapper.countByReleaseTimeAndUserId(startDate, endDate, null, Integer.valueOf(50), null);
        map.put("endCount", endCount);
        map.put("bjl", count == 0 ? "0" : df.format((double)endCount / (double)count * 100.0));
        VisitPlanTaskExample allTaskExample = new VisitPlanTaskExample();
        allTaskExample.createCriteria().andIsValidEqualTo("1").andObjWgCodeLike(wgCode + "%");
        allTaskExample.createCriteria().andCreateTimeBetween(startDate, endDate);
        double allZfCount = this.visitPlanTaskMapper.countByExample(allTaskExample);
        map.put("zfCount", allZfCount);
        return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"success", (Object)map));
    }

    @RequestMapping(value={"/bigWindow/taskList"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult bigWindowTaskList() {
        HashedMap data = new HashedMap();
        data.put("unfinished", 50);
        data.put("currIndex", 0);
        data.put("pageSize", 50);
        List sysTestList = this.tkCommonTaskExtMapper.selectSimpleList((Map)data);
        return AjaxResult.success((Object)sysTestList);
    }

    @RequestMapping(value={"/bigWindow/taskPoint"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult bigWindowTaskPoint() {
        HashedMap data = new HashedMap();
        data.put("unfinished", 50);
        data.put("currIndex", 0);
        data.put("pageSize", 999);
        List sysTestList = this.tkCommonTaskExtMapper.selectSimpleList((Map)data);
        return AjaxResult.success((Object)sysTestList);
    }

    @RequestMapping(value={"/taskDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getTaskDetail(@RequestParam String id) {
        try {
            TkCommonTask tkCommonTask = (TkCommonTask)this.tkCommonTaskService.selectByPrimaryKey(id);
            List tkCommonAssigneds = this.getTkCommonAssigneds(id);
            if (tkCommonAssigneds.size() > 0) {
                tkCommonTask.setAssBeassignedUserId(tkCommonAssigneds.stream().map(TkCommonAssigned::getBeassignedUserId).collect(Collectors.joining(",")));
                tkCommonTask.setAssBeassignedRole(tkCommonAssigneds.stream().map(TkCommonAssigned::getBeassignedRole).map(String::valueOf).collect(Collectors.joining(",")));
                tkCommonTask.setAssBeassignedUserName(tkCommonAssigneds.stream().map(TkCommonAssigned::getBeassignedUserName).map(String::valueOf).collect(Collectors.joining(",")));
                tkCommonTask.setAssAssignedUserId(((TkCommonAssigned)tkCommonAssigneds.get(0)).getAssignedUserId());
                tkCommonTask.setAssAssignedUserName(((TkCommonAssigned)tkCommonAssigneds.get(0)).getAssignedUserName());
                tkCommonTask.setAssAssignedNode(((TkCommonAssigned)tkCommonAssigneds.get(0)).getAssignedNode());
                tkCommonTask.setAssAssignedCreatetime(((TkCommonAssigned)tkCommonAssigneds.get(0)).getCreateTime());
            } else {
                tkCommonTask.setAssAssignedUserId(tkCommonTask.getAssignedUserId());
                tkCommonTask.setAssAssignedUserName(tkCommonTask.getAssignedUserName());
            }
            tkCommonTask.setTkCommonTaskDynamics(null);
            return AjaxResult.success((Object)tkCommonTask);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)400, (String)"\u67e5\u8be2\u51fa\u9519");
        }
    }

    @GetMapping(value={"/task/process/list"})
    public AjaxResult getTaskProcessList(@RequestParam String id) {
        TkCommonTask tkCommonTask = (TkCommonTask)this.tkCommonTaskService.selectByPrimaryKey(id);
        TkCommonTaskDynamicExample tkCommonTaskDynamicExample = new TkCommonTaskDynamicExample();
        TkCommonTaskDynamicExample.Criteria criteria = tkCommonTaskDynamicExample.createCriteria();
        criteria.andCommonTkIdEqualTo(tkCommonTask.getId());
        tkCommonTaskDynamicExample.setOrderByClause("create_time desc");
        List tkCommonTaskDynamics = this.tkCommonTaskDynamicService.selectByExample((Object)tkCommonTaskDynamicExample);
        return AjaxResult.success((Object)tkCommonTaskDynamics);
    }

    private List<TkCommonAssigned> getTkCommonAssigneds(@RequestParam String id) {
        TkCommonAssignedExample tkCommonAssignedExample = new TkCommonAssignedExample();
        TkCommonAssignedExample.Criteria criteria1 = tkCommonAssignedExample.createCriteria();
        criteria1.andCommonTkIdEqualTo(id);
        tkCommonAssignedExample.setOrderByClause("assigned_status desc");
        List list = this.tkCommonAssignedService.selectByExample((Object)tkCommonAssignedExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        Integer maxStatus = list.stream().mapToInt(TkCommonAssigned::getAssignedStatus).max().getAsInt();
        return list.stream().filter(t -> maxStatus.equals(t.getAssignedStatus())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/bigWindow/taskCountByComeFrom"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult taskCountByComeFrom(String wgCode, String startTime, String endTime) {
        List tkCommonTasks = new ArrayList();
        HashedMap data = new HashedMap();
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            data.put("startTime", startTime);
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            data.put("endTime", endTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)wgCode)) {
            data.put("wgCode", wgCode);
        }
        tkCommonTasks = this.tkCommonTaskService.taskCountByComeFrom((Map)data);
        return AjaxResult.success(tkCommonTasks);
    }

    @GetMapping(value={"/wgPointList"})
    @ResponseBody
    public AjaxResult wgPointList(String level) {
        GridRegionExample wgsExample = new GridRegionExample();
        GridRegionExample.Criteria criteria = wgsExample.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andWgTypeEqualTo("1");
        if (StringUtils.isNotBlank((CharSequence)level)) {
            if ("4".equals(level)) {
                criteria.andLevelEqualTo("3");
                criteria.andYlzd2EqualTo("1");
            } else {
                criteria.andLevelEqualTo(level);
                criteria.andYlzd2NotEqualTo("1");
            }
        } else {
            criteria.andLevelEqualTo("2");
        }
        List gridRegionList = this.gridRegionMapper.selectByExample(wgsExample);
        List list = BeanCopyUtil.bathToBean((Collection)gridRegionList, GridRegionExtInfo.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getWgCoordinate())) {
                    String point = "MULTILINESTRING((" + e.getWgCoordinate().replaceAll("\\|", " ") + "))";
                    e.setWgCoordinate(point);
                }
                if (StringUtils.isNotBlank((CharSequence)e.getWgCentreCoordinate()) && e.getWgCentreCoordinate().contains("|") && StringUtils.isNotBlank((CharSequence)e.getWgCentreCoordinate())) {
                    String longitude = e.getWgCentreCoordinate().substring(0, e.getWgCentreCoordinate().indexOf("|"));
                    String latitude = e.getWgCentreCoordinate().substring(e.getWgCentreCoordinate().indexOf("|") + 1);
                    e.setLongitude(longitude);
                    e.setLatitude(latitude);
                    String point = e.getWgCentreCoordinate().replaceAll("\\|", " ");
                    e.setWgCentreCoordinate(point);
                }
            });
        }
        return AjaxResult.success((Object)list);
    }
}

