/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.publicservice;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.publicservice.TPublicServiceDiscuss;
import com.ruoyi.system.domain.publicservice.vo.PSTkCommonTaskVO;
import com.ruoyi.system.domain.task.TkCommonTask;
import com.ruoyi.system.service.publicservice.TPublicServiceDiscussService;
import com.ruoyi.system.service.task.TaskService;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u516c\u5171\u670d\u52a1-\u4e07\u4e8b\u597d\u5546\u91cf"})
@RestController
@RequestMapping(value={"/api/publicservice/discuss"})
public class TPublicServiceDiscussController
extends BaseController {
    @Autowired
    private TPublicServiceDiscussService tPublicServiceDiscussService;
    @Autowired
    private TaskService taskService;

    @GetMapping(value={"/getMaxNo"})
    public AjaxResult getMaxNo() {
        return AjaxResult.success((String)this.tPublicServiceDiscussService.getMaxNum());
    }

    @GetMapping
    public TableDataInfo list(TPublicServiceDiscuss tPublicServiceDiscuss) {
        this.startPage();
        return this.getDataTable(this.tPublicServiceDiscussService.listTPublicServiceDiscuss(tPublicServiceDiscuss));
    }

    @Log(title="\u65b0\u589e\u516c\u5171\u670d\u52a1 \u4e07\u4e8b\u597d\u5546\u91cf\u8868", businessType=BusinessType.INSERT)
    @RepeatSubmit
    @PostMapping
    public AjaxResult save(@Validated @RequestBody TPublicServiceDiscuss tPublicServiceDiscuss) {
        tPublicServiceDiscuss.setCreateBy(this.getUserId());
        return this.toAjax(this.tPublicServiceDiscussService.saveDiscuss(tPublicServiceDiscuss, this.getUserId()));
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getById(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.tPublicServiceDiscussService.getDiscussById(id));
    }

    @Log(title="\u4fee\u6539\u516c\u5171\u670d\u52a1 \u6211\u53d1\u73b0\u8868", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult update(@Validated @RequestBody TPublicServiceDiscuss tPublicServiceDiscuss) {
        tPublicServiceDiscuss.setUpdateBy(this.getUserId());
        return this.toAjax(this.tPublicServiceDiscussService.updateDiscuss(tPublicServiceDiscuss, this.getUsername()));
    }

    @Log(title="\u5220\u9664\u516c\u5171\u670d\u52a1 \u6211\u53d1\u73b0\u8868", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/delete"})
    public AjaxResult batchRemove(@RequestBody Long[] ids) {
        return this.toAjax(this.tPublicServiceDiscussService.batchRemove(ids));
    }

    @RequestMapping(value={"/transferTask"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult add(@RequestBody PSTkCommonTaskVO tkCommonTask) {
        if (null == tkCommonTask.getFindOrDiscussId()) {
            throw new ServiceException("\u4e07\u4e8b\u597d\u5546\u91cfid\u672a\u4f20");
        }
        TPublicServiceDiscuss discuss = this.tPublicServiceDiscussService.getDiscussById(tkCommonTask.getFindOrDiscussId());
        if (null == discuss) {
            throw new ServiceException("\u4e07\u4e8b\u597d\u5546\u91cf\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        TkCommonTask task = new TkCommonTask();
        BeanUtils.copyProperties((Object)tkCommonTask, (Object)task);
        task.setComeFrom(Integer.valueOf(10));
        task.setPriorityType(Integer.valueOf(0));
        task.setFormId(tkCommonTask.getFindOrDiscussId().toString());
        task.setNum(tkCommonTask.getFindCode());
        String projectId = this.taskService.add(task);
        if (StringUtils.isEmpty((String)projectId)) {
            throw new ServiceException("\u8f6c\u5de5\u5355\u5931\u8d25\uff1a\u672a\u80fd\u83b7\u53d6\u5de5\u5355id");
        }
        discuss.setDiscussId(tkCommonTask.getFindOrDiscussId());
        discuss.setProjectId(projectId);
        discuss.setGenTask("1");
        discuss.setDiscussResult("3");
        discuss.setProjectStatus("\u5904\u7406\u4e2d");
        discuss.setProjectName(tkCommonTask.getTkName());
        int result = this.tPublicServiceDiscussService.updateTPublicServiceDiscuss(discuss);
        return this.toAjax(result);
    }
}

