/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.utils.poi.ExportExcelUtil;
import com.ruoyi.common.utils.poi.ImportExcelUtil;
import com.ruoyi.party.domain.PartyOrganization;
import com.ruoyi.party.domain.vo.PartyOrganizationVo;
import com.ruoyi.party.service.api.IPartyOrganizationService;
import com.ruoyi.system.mapper.system.SysDictDataMapper;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u515a\u7ec4\u7ec7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/party/partyOrganization"})
public class PartyOrganizationController
extends BaseController {
    @Autowired
    private IPartyOrganizationService partyOrganizationService;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;

    private List<SysDictData> getDataByType(String dictType) {
        return this.sysDictDataMapper.selectDictDataByType(dictType);
    }

    @GetMapping(value={"/list"})
    public TableDataInfo list(PartyOrganization partyOrganization) {
        List ortTypeList = this.getDataByType("party_org_type");
        Map<String, SysDictData> orgMap = ortTypeList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        this.startPage();
        List list = this.partyOrganizationService.selectPartyOrganizationList(partyOrganization);
        TableDataInfo dataInfo = this.getDataTable(list);
        List voList = BeanCopyUtil.bathToBean((Collection)dataInfo.getRows(), PartyOrganizationVo.class);
        if (!CollectionUtils.isEmpty((Collection)voList)) {
            voList.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getZzlb())) {
                    SysDictData zzlb = (SysDictData)orgMap.get(e.getZzlb());
                    e.setZzlbName(zzlb == null ? "" : zzlb.getDictLabel());
                }
            });
        }
        dataInfo.setRows(voList);
        return dataInfo;
    }

    @Log(title="\u515a\u7ec4\u7ec7\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, PartyOrganization partyOrganization) {
        List list = this.partyOrganizationService.selectPartyOrganizationList(partyOrganization);
        ExcelUtil util = new ExcelUtil(PartyOrganization.class);
        util.exportExcel(response, list, "\u515a\u7ec4\u7ec7\u7ba1\u7406\u6570\u636e");
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") String id) {
        List ortTypeList = this.getDataByType("party_org_type");
        List sdgxTypeList = this.getDataByType("sdgx_type");
        PartyOrganizationVo partyOrganizationVo = this.partyOrganizationService.selectPartyOrganizationById(id);
        Map<String, SysDictData> orgMap = ortTypeList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        Map<String, SysDictData> sdgxMap = sdgxTypeList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        if (StringUtils.isNotBlank((CharSequence)partyOrganizationVo.getSdgx())) {
            SysDictData sdgx = sdgxMap.get(partyOrganizationVo.getSdgx());
            partyOrganizationVo.setSdgxName(sdgx == null ? "" : sdgx.getDictLabel());
        }
        if (StringUtils.isNotBlank((CharSequence)partyOrganizationVo.getZzlb())) {
            SysDictData zzlb = orgMap.get(partyOrganizationVo.getZzlb());
            partyOrganizationVo.setZzlbName(zzlb == null ? "" : zzlb.getDictLabel());
        }
        return this.success((Object)partyOrganizationVo);
    }

    @Log(title="\u515a\u7ec4\u7ec7\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PartyOrganization partyOrganization) {
        return this.toAjax(this.partyOrganizationService.insertPartyOrganization(partyOrganization));
    }

    @Log(title="\u515a\u7ec4\u7ec7\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PartyOrganization partyOrganization) {
        return this.toAjax(this.partyOrganizationService.updatePartyOrganization(partyOrganization));
    }

    @Log(title="\u515a\u7ec4\u7ec7\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable String[] ids) {
        return this.toAjax(this.partyOrganizationService.deletePartyOrganizationByIds(ids));
    }

    @RequestMapping(value={"countPartyOrganization"}, method={RequestMethod.GET})
    public AjaxResult countPartyOrganization() {
        int count = this.partyOrganizationService.countOrg();
        return this.success((Object)count);
    }

    @RequestMapping(value={"getPartyOrgBuild"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getPartyOrgBuild() {
        List sysDictDataList = this.getDataByType("party_org_type");
        List list = this.partyOrganizationService.getPartyOrgBuild(sysDictDataList);
        return this.success((Object)list);
    }

    @GetMapping(value={"/listTree"})
    public TableDataInfo listTree(PartyOrganization partyOrganization) {
        return this.getDataTable(this.partyOrganizationService.partyOrganizationTree(partyOrganization));
    }

    @PostMapping(value={"/readExcel"}, headers={"content-type=multipart/form-data"})
    public AjaxResult readExcel(@RequestParam(value="file") MultipartFile file) {
        HSSFWorkbook workbook;
        block6: {
            if (null == file) {
                return AjaxResult.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String fileName = file.getOriginalFilename();
            try {
                InputStream is = file.getInputStream();
                if ("xls".equals(ImportExcelUtil.getPostFix((String)fileName))) {
                    workbook = new HSSFWorkbook(is);
                    break block6;
                }
                if ("xlsx".equals(ImportExcelUtil.getPostFix((String)fileName))) {
                    workbook = new XSSFWorkbook(is);
                    break block6;
                }
                return AjaxResult.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            catch (Exception e) {
                e.printStackTrace();
                return AjaxResult.error((String)"\u7cfb\u7edf\u9519\u8bef");
            }
        }
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet == null) {
            return AjaxResult.error((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        this.partyOrganizationService.importExcel((Workbook)workbook, this.getDataByType("party_org_type"), this.getDataByType("sdgx_type"));
        return AjaxResult.success();
    }

    @GetMapping(value={"/downloadTemplate"})
    public String readExcel(HttpServletRequest request, HttpServletResponse response) {
        HSSFWorkbook sheets = this.partyOrganizationService.exportTemplate();
        try {
            return ExportExcelUtil.downloadExcel((HttpServletRequest)request, (HttpServletResponse)response, (HSSFWorkbook)sheets);
        }
        catch (IOException e) {
            this.logger.info("\u4e0b\u8f7d\u515a\u7ec4\u7ec7\u5bfc\u5165\u6a21\u7248\u51fa\u9519");
            throw new RuntimeException("\u4e0b\u8f7d\u515a\u7ec4\u7ec7\u5bfc\u5165\u6a21\u7248\u51fa\u9519" + e.getMessage());
        }
    }
}

