/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.party;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExportExcelUtil;
import com.ruoyi.common.utils.poi.ImportExcelUtil;
import com.ruoyi.party.domain.PartyMember;
import com.ruoyi.party.domain.vo.PartyMemberVo;
import com.ruoyi.party.service.api.IPartyMemberService;
import com.ruoyi.system.mapper.system.SysDictDataMapper;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u515a\u5efa-\u515a\u5458"})
@RestController
@RequestMapping(value={"/api/party/partyMember"})
public class PartyMemberController
extends BaseController {
    @Autowired
    private IPartyMemberService partyMemberService;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;

    private List<SysDictData> getDataByType(String type) {
        return this.sysDictDataMapper.selectDictDataByType(type);
    }

    @GetMapping(value={"/list"})
    public TableDataInfo list(PartyMember partyMember) {
        this.startPage();
        List list = this.partyMemberService.selectPartyMemberList(partyMember);
        TableDataInfo dataInfo = this.getDataTable(list);
        if (!CollectionUtils.isEmpty((Collection)dataInfo.getRows())) {
            dataInfo.setRows(this.partyMemberService.convertToVo(dataInfo.getRows()));
        }
        return dataInfo;
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        SysDictData sysDictData;
        List dictDataList = this.getDataByType("party_people_type");
        Map<String, SysDictData> map = dictDataList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        List educationDictDataList = this.getDataByType("education_type");
        Map<String, SysDictData> educationMap = educationDictDataList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        PartyMemberVo partyMemberVo = this.partyMemberService.selectPartyMemberById(id);
        if (StringUtils.isNotBlank((CharSequence)partyMemberVo.getRylb())) {
            sysDictData = map.get(partyMemberVo.getRylb());
            partyMemberVo.setRylbName(sysDictData == null ? "" : sysDictData.getDictLabel());
        }
        if (StringUtils.isNotBlank((CharSequence)partyMemberVo.getXl())) {
            sysDictData = educationMap.get(partyMemberVo.getXl());
            partyMemberVo.setEducationName(sysDictData == null ? "" : sysDictData.getDictLabel());
        }
        return this.success((Object)partyMemberVo);
    }

    @Log(title="\u515a\u5458", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PartyMember partyMember) {
        return this.toAjax(this.partyMemberService.insertPartyMember(partyMember));
    }

    @Log(title="\u515a\u5458", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PartyMember partyMember) {
        return this.toAjax(this.partyMemberService.updatePartyMember(partyMember));
    }

    @Log(title="\u515a\u5458", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable String[] ids) {
        return this.toAjax(this.partyMemberService.deletePartyMemberByIds(ids));
    }

    @RequestMapping(value={"getPartyCounts"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getPartyCounts() {
        return this.success((Object)this.partyMemberService.getPartyCount());
    }

    @RequestMapping(value={"getXLFB"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getXLFB(String orgId) {
        List list = this.partyMemberService.getXLFB(orgId);
        List educationDictDataList = this.getDataByType("education_type");
        Map<String, SysDictData> educationMap = educationDictDataList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        ArrayList rlist = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            for (Map map : list) {
                HashMap<String, String> rmap = new HashMap<String, String>();
                String dictType = (String)map.get("xl");
                if (!educationMap.containsKey(dictType)) continue;
                SysDictData sysDictData = educationMap.get(dictType);
                rmap.put("xl", sysDictData.getDictLabel());
                rmap.put("count", (String)map.get("counts"));
                rlist.add(rmap);
            }
        }
        return this.success(rlist);
    }

    @RequestMapping(value={"getDl"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getDl(String orgId) {
        List list = this.partyMemberService.getDl(orgId);
        ArrayList<JSONArray> rlist = new ArrayList<JSONArray>();
        int wnyxCountsMan = 0;
        int wnyxCountsWoman = 0;
        int wdsnCountsMan = 0;
        int wdsnCountsWoman = 0;
        int sdswCountsMan = 0;
        int sdswCountsWoman = 0;
        int swdesCountsMan = 0;
        int swdesCountsWoman = 0;
        int esysCountsMan = 0;
        int esysCountsWoman = 0;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            for (Map map : list) {
                int dYear = 0;
                if (map.get("dyear") != null) {
                    String d = String.valueOf(map.get("dyear"));
                    dYear = Integer.parseInt(d);
                }
                String sex = String.valueOf(map.get("xb"));
                if (dYear < 5) {
                    if (sex.equals("\u7537")) {
                        ++wnyxCountsMan;
                        continue;
                    }
                    if (sex.equals("\u5973")) {
                        ++wnyxCountsWoman;
                        continue;
                    }
                }
                if (dYear <= 10) {
                    if (sex.equals("\u7537")) {
                        ++wdsnCountsMan;
                        continue;
                    }
                    if (sex.equals("\u5973")) {
                        ++wdsnCountsWoman;
                        continue;
                    }
                }
                if (dYear <= 15) {
                    if (sex.equals("\u7537")) {
                        ++sdswCountsMan;
                        continue;
                    }
                    if (sex.equals("\u5973")) {
                        ++sdswCountsWoman;
                        continue;
                    }
                }
                if (dYear <= 20) {
                    if (sex.equals("\u7537")) {
                        ++swdesCountsMan;
                        continue;
                    }
                    if (sex.equals("\u5973")) {
                        ++swdesCountsWoman;
                        continue;
                    }
                }
                if (dYear <= 20) continue;
                if (sex.equals("\u7537")) {
                    ++esysCountsMan;
                    continue;
                }
                if (!sex.equals("\u5973")) continue;
                ++esysCountsWoman;
            }
        }
        String rString = "[{\"time\":\"5\u5e74\u4ee5\u4e0b\",\"type\":\"\u5973\",\"value\":" + wnyxCountsWoman + "},{\"time\":\"5-10\u5e74\",\"type\":\"\u5973\",\"value\":" + wdsnCountsWoman + "},{\"time\":\"10-15\u5e74\",\"type\":\"\u5973\",\"value\":" + sdswCountsWoman + "},{\"time\":\"15-20\u5e74\",\"type\":\"\u5973\",\"value\":" + swdesCountsWoman + "},{\"time\":\"20\u5e74\u4ee5\u4e0a\",\"type\":\"\u5973\",\"value\":" + esysCountsWoman + "}]";
        JSONArray rj = JSONArray.parseArray((String)rString, (JSONReader.Feature[])new JSONReader.Feature[0]);
        rlist.add(rj);
        String rStringMan = "[{\"time\":\"5\u5e74\u4ee5\u4e0b\",\"type\":\"\u7537\",\"value\":" + wnyxCountsMan + "},{\"time\":\"5-10\u5e74\",\"type\":\"\u7537\",\"value\":" + wdsnCountsMan + "},{\"time\":\"10-15\u5e74\",\"type\":\"\u7537\",\"value\":" + sdswCountsMan + "},{\"time\":\"15-20\u5e74\",\"type\":\"\u7537\",\"value\":" + swdesCountsMan + "},{\"time\":\"20\u5e74\u4ee5\u4e0a\",\"type\":\"\u7537\",\"value\":" + esysCountsMan + "}]";
        JSONArray r = JSONArray.parseArray((String)rStringMan, (JSONReader.Feature[])new JSONReader.Feature[0]);
        rlist.add(r);
        return this.success(rlist);
    }

    @PostMapping(value={"/readExcel"}, headers={"content-type=multipart/form-data"})
    public AjaxResult readExcel(@RequestParam(value="file") MultipartFile file) {
        HSSFWorkbook workbook;
        block6: {
            if (null == file) {
                return AjaxResult.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String fileName = file.getOriginalFilename();
            try {
                InputStream is = file.getInputStream();
                if ("xls".equals(ImportExcelUtil.getPostFix((String)fileName))) {
                    workbook = new HSSFWorkbook(is);
                    break block6;
                }
                if ("xlsx".equals(ImportExcelUtil.getPostFix((String)fileName))) {
                    workbook = new XSSFWorkbook(is);
                    break block6;
                }
                return AjaxResult.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            catch (Exception e) {
                e.printStackTrace();
                return AjaxResult.error((String)"\u7cfb\u7edf\u9519\u8bef");
            }
        }
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet == null) {
            return AjaxResult.error((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        List partyPeopleTypes = this.sysDictDataMapper.selectDictDataByType("party_people_type");
        List educationTypes = this.sysDictDataMapper.selectDictDataByType("education_type");
        Map<String, SysDictData> treeMap = partyPeopleTypes.stream().collect(Collectors.toMap(SysDictData::getDictLabel, x -> x));
        Map<String, SysDictData> educationMap = educationTypes.stream().collect(Collectors.toMap(SysDictData::getDictLabel, x -> x));
        this.partyMemberService.importExcel((Workbook)workbook, treeMap, educationMap);
        return AjaxResult.success();
    }

    @GetMapping(value={"/downloadTemplate"})
    public String readExcel(HttpServletRequest request, HttpServletResponse response) {
        HSSFWorkbook sheets = this.partyMemberService.exportTemplate();
        try {
            return ExportExcelUtil.downloadExcel((HttpServletRequest)request, (HttpServletResponse)response, (HSSFWorkbook)sheets);
        }
        catch (IOException e) {
            this.logger.info("\u4e0b\u8f7d\u515a\u5458\u5bfc\u5165\u6a21\u7248\u51fa\u9519");
            throw new RuntimeException("\u4e0b\u8f7d\u515a\u5458\u5bfc\u5165\u6a21\u7248\u51fa\u9519" + e.getMessage());
        }
    }
}

