/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.PartyBuildingNews;
import com.ruoyi.party.domain.vo.PartyBuildingNewsVO;
import com.ruoyi.party.service.api.IPartyBuildingNewsService;
import io.swagger.annotations.Api;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u515a\u5efa-\u515a\u5efa\u8981\u95fb"})
@RestController
@RequestMapping(value={"/api/party/partyBuildNews"})
public class PartyBuildingNewsController
extends BaseController {
    @Autowired
    private IPartyBuildingNewsService partyBuildingNewsService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(PartyBuildingNewsVO partyBuildingNews) {
        this.startPage();
        List list = this.partyBuildingNewsService.selectPartyBuildingNewsList(partyBuildingNews);
        return this.getDataTable(list);
    }

    @Log(title="\u515a\u5efa\u8981\u95fb", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, PartyBuildingNewsVO partyBuildingNews) {
        List list = this.partyBuildingNewsService.selectPartyBuildingNewsList(partyBuildingNews);
        ExcelUtil util = new ExcelUtil(PartyBuildingNews.class);
        util.exportExcel(response, list, "\u515a\u5efa\u8981\u95fb\u6570\u636e");
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return this.success((Object)this.partyBuildingNewsService.selectPartyBuildingNewsById(id));
    }

    @Log(title="\u515a\u5efa\u8981\u95fb", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PartyBuildingNews partyBuildingNews) {
        return this.toAjax(this.partyBuildingNewsService.insertPartyBuildingNews(partyBuildingNews));
    }

    @Log(title="\u515a\u5efa\u8981\u95fb", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PartyBuildingNews partyBuildingNews) {
        return this.toAjax(this.partyBuildingNewsService.updatePartyBuildingNews(partyBuildingNews));
    }

    @Log(title="\u515a\u5efa\u8981\u95fb", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.partyBuildingNewsService.deletePartyBuildingNewsByIds(ids));
    }
}

