/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.party;

import com.google.common.collect.Lists;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.PartyActivity;
import com.ruoyi.party.domain.vo.PartyActivityVO;
import com.ruoyi.party.service.api.IPartyActivityService;
import com.ruoyi.system.mapper.system.SysDictDataMapper;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u515a\u5efa-\u515a\u5458\u6d3b\u52a8"})
@RestController
@RequestMapping(value={"/api/party/partyActivity"})
public class PartyActivityController
extends BaseController {
    @Autowired
    private IPartyActivityService partyActivityService;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;

    private List<SysDictData> getDataByType() {
        return this.sysDictDataMapper.selectDictDataByType("service_type");
    }

    @GetMapping(value={"/selectByInfo"})
    public TableDataInfo list(PartyActivity partyActivity) {
        this.startPage();
        List list = this.partyActivityService.selectPartyActivityList(partyActivity);
        TableDataInfo dataInfo = this.getDataTable(list);
        if (!CollectionUtils.isEmpty((Collection)dataInfo.getRows())) {
            dataInfo.setRows(this.partyActivityService.convertData(dataInfo.getRows(), this.getDataByType()));
        }
        return dataInfo;
    }

    @Log(title="\u515a\u5458\u6d3b\u52a8", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, PartyActivity partyActivity) {
        List list = this.partyActivityService.selectPartyActivityList(partyActivity);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = this.partyActivityService.convertData(list, this.getDataByType());
        }
        ExcelUtil util = new ExcelUtil(PartyActivity.class);
        util.exportExcel(response, list, "\u515a\u5458\u6d3b\u52a8\u6570\u636e");
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") String id) {
        SysDictData sysDictData;
        List dictDataList = this.getDataByType();
        Map<String, SysDictData> map = dictDataList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        PartyActivityVO partyActivityVO = this.partyActivityService.selectPartyActivityById(id);
        if (StringUtils.isNotBlank((CharSequence)partyActivityVO.getFwlx()) && (sysDictData = map.get(partyActivityVO.getFwlx())) != null) {
            partyActivityVO.setFwlxString(sysDictData.getDictLabel());
        }
        return this.success((Object)partyActivityVO);
    }

    @Log(title="\u515a\u5458\u6d3b\u52a8", businessType=BusinessType.INSERT)
    @PostMapping(value={"/partyActivityInsertOrUpdate"})
    public AjaxResult add(@RequestBody PartyActivity partyActivity) {
        return this.toAjax(this.partyActivityService.insertOrUpdatePartyActivity(partyActivity).booleanValue());
    }

    @Log(title="\u515a\u5458\u6d3b\u52a8", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PartyActivity partyActivity) {
        return this.toAjax(this.partyActivityService.updatePartyActivity(partyActivity));
    }

    @Log(title="\u515a\u5458\u6d3b\u52a8", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable String[] ids) {
        return this.toAjax(this.partyActivityService.deletePartyActivityByIds(ids));
    }

    @RequestMapping(value={"getPartyActivity"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getPartyActivity(String orgId) {
        List sysDictData = this.getDataByType();
        Map<String, SysDictData> treeMap = sysDictData.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        List list = this.partyActivityService.getPartyActivity(orgId);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Map map : list) {
                String fwlx = map.get("fwlx").toString();
                if (!treeMap.containsKey(fwlx)) continue;
                map.put("fwlx", treeMap.get(fwlx).getDictLabel());
            }
        }
        return this.success((Object)list);
    }

    @RequestMapping(value={"getPartyActivityRank"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getPartyActivityRank(String orgId) {
        List sysDictData = this.getDataByType();
        Map<String, String> treeMap = sysDictData.stream().collect(Collectors.toMap(SysDictData::getDictValue, SysDictData::getDictLabel));
        ArrayList keyList = Lists.newArrayList(treeMap.keySet());
        List list = this.partyActivityService.getPartyActivity(orgId);
        ArrayList<String> hasDataList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Map map : list) {
                String fwlx = map.get("fwlx").toString();
                if (!treeMap.containsKey(fwlx)) continue;
                map.put("fwlx", treeMap.get(fwlx));
                hasDataList.add(fwlx);
            }
            keyList.removeAll(hasDataList);
        }
        if (!CollectionUtils.isEmpty((Collection)keyList)) {
            for (String key : keyList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("count", 0);
                map.put("fwlx", treeMap.get(key));
                list.add(map);
            }
        }
        return this.success((Object)list);
    }
}

