/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.ExcellentParty;
import com.ruoyi.party.service.api.IExcellentPartyService;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u515a\u5efa-\u4f18\u79c0\u515a\u7ec4\u7ec7"})
@RestController
@RequestMapping(value={"/api/party/excellentParty"})
public class ExcellentPartyController
extends BaseController {
    @Autowired
    private IExcellentPartyService excellentPartyService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(ExcellentParty excellentParty) {
        this.startPage();
        List list = this.excellentPartyService.selectExcellentPartyList(excellentParty);
        TableDataInfo tableDataInfo = this.getDataTable(list);
        if (!CollectionUtils.isEmpty((Collection)tableDataInfo.getRows())) {
            tableDataInfo.setRows(this.excellentPartyService.convertData(tableDataInfo.getRows()));
        }
        return tableDataInfo;
    }

    @Log(title="\u4f18\u79c0\u515a\u7ec4\u7ec7", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, ExcellentParty excellentParty) {
        List list = this.excellentPartyService.selectExcellentPartyList(excellentParty);
        ExcelUtil util = new ExcelUtil(ExcellentParty.class);
        util.exportExcel(response, list, "\u4f18\u79c0\u515a\u7ec4\u7ec7\u6570\u636e");
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") String id) {
        return this.success((Object)this.excellentPartyService.selectExcellentPartyById(id));
    }

    @Log(title="\u4f18\u79c0\u515a\u7ec4\u7ec7", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ExcellentParty excellentParty) {
        return this.toAjax(this.excellentPartyService.insertExcellentParty(excellentParty));
    }

    @Log(title="\u4f18\u79c0\u515a\u7ec4\u7ec7", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ExcellentParty excellentParty) {
        return this.toAjax(this.excellentPartyService.updateExcellentParty(excellentParty));
    }

    @Log(title="\u4f18\u79c0\u515a\u7ec4\u7ec7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable String[] ids) {
        return this.toAjax(this.excellentPartyService.deleteExcellentPartyByIds(ids));
    }

    @RequestMapping(value={"getGoodPartyOrgCounts"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getGoodPartyOrgCounts(Integer year, String beginDate) {
        String goodPartyOrgCountspartyCounts = this.excellentPartyService.getGoodPartyOrgCounts(year, beginDate);
        return this.success(goodPartyOrgCountspartyCounts);
    }
}

