/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.ClickNumber;
import com.ruoyi.party.service.api.IClickNumberService;
import io.swagger.annotations.Api;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u515a\u5efa-\u70b9\u51fb\u6b21\u6570"})
@RestController
@RequestMapping(value={"/api/party/clickNumber"})
public class ClickNumberController
extends BaseController {
    @Autowired
    private IClickNumberService clickNumberService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(ClickNumber clickNumber) {
        this.startPage();
        List list = this.clickNumberService.selectClickNumberList(clickNumber);
        return this.getDataTable(list);
    }

    @Log(title="\u70b9\u51fb\u6b21\u6570", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, ClickNumber clickNumber) {
        List list = this.clickNumberService.selectClickNumberList(clickNumber);
        ExcelUtil util = new ExcelUtil(ClickNumber.class);
        util.exportExcel(response, list, "\u70b9\u51fb\u6b21\u6570\u6570\u636e");
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return this.success((Object)this.clickNumberService.selectClickNumberById(id));
    }

    @Log(title="\u70b9\u51fb\u6b21\u6570", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ClickNumber clickNumber) {
        return this.toAjax(this.clickNumberService.insertClickNumber(clickNumber));
    }

    @Log(title="\u70b9\u51fb\u6b21\u6570", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ClickNumber clickNumber) {
        return this.toAjax(this.clickNumberService.updateClickNumber(clickNumber));
    }

    @Log(title="\u70b9\u51fb\u6b21\u6570", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.clickNumberService.deleteClickNumberByIds(ids));
    }

    @GetMapping(value={"/statisticsClickFrequency/{type}/{businessKey}"})
    public AjaxResult statisticsClickFrequency(@PathVariable(value="type") String type, @PathVariable(value="businessKey") String businessKey) {
        return AjaxResult.success((Object)this.clickNumberService.getClickNumberStatistics(type, businessKey));
    }
}

