/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.other;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.other.MapEntity;
import com.ruoyi.system.service.other.MapEntityService;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/map"})
@Api(tags={"\u5730\u56fe"})
public class MapEntityController
extends BaseController {
    @Autowired
    private MapEntityService mapEntityService;

    @RequestMapping(value={"/getAllMapEntities"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MapEntity> getAllMapEntities(@RequestParam(name="level") String level) {
        return this.mapEntityService.getAllMapEntitiesByLevel(level);
    }

    @RequestMapping(value={"/app/getAllMapEntities"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getAllMapEntitiesForApp(@RequestParam(name="level") String level) {
        return AjaxResult.success((Object)this.mapEntityService.getAllMapEntitiesByLevel(level));
    }

    @RequestMapping(value={"/getMapEntityById"}, method={RequestMethod.GET})
    @ResponseBody
    public MapEntity getMapEntityById(@RequestParam(name="id") String id) {
        return this.mapEntityService.getMapEntityById(id);
    }

    @RequestMapping(value={"/addMapEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public MapEntity addMapEntityById(@RequestBody MapEntity mapEntity) {
        return this.mapEntityService.addMapEntityById(mapEntity);
    }

    @RequestMapping(value={"/updateMapEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public MapEntity updateMapEntity(@RequestBody MapEntity mapEntity) {
        return this.mapEntityService.updateMapEntity(mapEntity.getId(), mapEntity);
    }

    @RequestMapping(value={"/deleteMapEntity"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteMapEntity(@RequestParam(name="id") String id) {
        this.mapEntityService.deleteMapEntity(id);
    }
}

