/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.other;

import com.alibaba.fastjson.JSON;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.domain.other.vo.BsCommonVO;
import com.ruoyi.system.service.other.BsCommonService;
import com.ruoyi.system.service.other.impl.FlpzService;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/flpz"})
public class BsFlpzController
extends BaseController {
    @Autowired
    private FlpzService flpzService;
    @Autowired
    private BsCommonService bsCommonService;

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ResponseBody
    public String getCommons(@RequestBody BsCommonVO bsCommonVO) {
        try {
            AjaxResult result = new AjaxResult();
            this.flpzService.getRoles(bsCommonVO, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage()));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    @ResponseBody
    public String delete(@RequestBody BsCommon body) {
        try {
            AjaxResult result = new AjaxResult();
            this.flpzService.delete(body, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage()));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public String insert(@RequestBody BsCommon body) {
        try {
            String id = UUID.randomUUID().toString();
            body.setId(id);
            int reslt = this.bsCommonService.insert((Object)body);
            if (reslt > 0) {
                return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"", (String)"\u4fdd\u5b58\u6210\u529f"));
            }
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"", (String)"\u4fdd\u5b58\u5931\u8d25"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage()));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    @ResponseBody
    public String update(@RequestBody BsCommon body) {
        try {
            int reslt = this.bsCommonService.updateByPrimaryKeySelective((Object)body);
            if (reslt > 0) {
                return JSON.toJSONString((Object)AjaxResult.build((int)200, (String)"", (String)"\u4fdd\u5b58\u6210\u529f"));
            }
            return JSON.toJSONString((Object)AjaxResult.build((int)400, (String)"", (String)"\u4fdd\u5b58\u5931\u8d25"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage()));
        }
    }

    @RequestMapping(value={"/getTreeNode"}, method={RequestMethod.POST})
    @ResponseBody
    public String getTreeNode(@RequestBody BsCommonVO bsCommonVO) {
        try {
            AjaxResult result = new AjaxResult();
            this.flpzService.getTreeNode(bsCommonVO, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/getWgNameList"}, method={RequestMethod.GET})
    @ResponseBody
    public String getWgNameList(String name, Integer pageNum, Integer pageSize) {
        try {
            AjaxResult result = new AjaxResult();
            List wgdxList = this.flpzService.getWgNameList(pageNum, pageSize, name, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage()));
        }
    }
}

