/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.other;

import com.alibaba.fastjson2.JSON;
import com.github.pagehelper.PageHelper;
import com.ruoyi.common.annotation.Anonymous;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.domain.other.BsCommonExample;
import com.ruoyi.system.domain.other.vo.BsCommonVO;
import com.ruoyi.system.service.other.BsCommonFacadeService;
import com.ruoyi.system.service.other.BsCommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57fa\u672c\u914d\u7f6e - \u6570\u636e\u5b57\u5178"})
@RestController
@RequestMapping(value={"/api/bsCommon"})
public class BsCommonController
extends BaseController {
    @Autowired
    private BsCommonFacadeService commonService;
    @Autowired
    private BsCommonService bsCommonService;

    @ApiOperation(value="\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ResponseBody
    public TableDataInfo getCommons(@RequestBody BsCommonVO bsCommonVO) {
        PageHelper.startPage((int)bsCommonVO.getPageNum(), (int)bsCommonVO.getPageSize());
        BsCommonExample example = new BsCommonExample();
        BsCommonExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty((CharSequence)bsCommonVO.getParentId())) {
            criteria.andParentIdEqualTo(bsCommonVO.getParentId());
        }
        example.setOrderByClause(" sort + 0 asc ");
        List list = this.bsCommonService.selectByExample((Object)example);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5220\u9664")
    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    @ResponseBody
    public String delete(@RequestBody BsCommon body) {
        try {
            return this.commonService.commit(body, "delete");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public String insert(@RequestBody BsCommon body) {
        try {
            return this.commonService.commit(body, "insert");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    @ResponseBody
    public String update(@RequestBody BsCommon body) {
        try {
            return this.commonService.commit(body, "update");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @ApiOperation(value="\u6811\u7ed3\u6784")
    @RequestMapping(value={"/getTreeNode"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getTreeNode(@RequestBody BsCommonVO bsCommonVO) {
        try {
            return this.commonService.getTreeNode(bsCommonVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @Anonymous
    @ApiOperation(value="\u83b7\u53d6\u7f51\u683c\u5217\u8868")
    @RequestMapping(value={"/getWgdxList"}, method={RequestMethod.GET})
    @ResponseBody
    public String getWgdxList(@RequestParam(name="code") String code) {
        try {
            List wgdxList = this.bsCommonService.getWgdxList(code);
            return JSON.toJSONString((Object)AjaxResult.success((Object)wgdxList));
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }
}

