/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.operatingmanage;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.operatingmanage.TPublicServiceComInfo;
import com.ruoyi.system.service.operatingmanage.TPublicServiceComInfoService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8fd0\u8425\u7ba1\u7406-\u751f\u6d3b\u516c\u544a\u680f"})
@RestController
@RequestMapping(value={"/api/publicservice/comInfo"})
public class TPublicServiceComInfoController
extends BaseController {
    @Autowired
    private TPublicServiceComInfoService tPublicServiceComInfoService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(TPublicServiceComInfo tPublicServiceComInfo) {
        this.startPage();
        return this.getDataTable(this.tPublicServiceComInfoService.listTPublicServiceComInfo(tPublicServiceComInfo));
    }

    @Log(title="\u65b0\u589e\u4f01\u4e1a\u62db\u8058 \u4f01\u4e1a\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public AjaxResult save(@RequestBody TPublicServiceComInfo tPublicServiceComInfo) {
        tPublicServiceComInfo.setCreateBy(this.getUsername());
        return this.toAjax(this.tPublicServiceComInfoService.saveComInfo(tPublicServiceComInfo));
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getById(@PathVariable(value="id") Long id) {
        TPublicServiceComInfo comInfo = this.tPublicServiceComInfoService.getTPublicServiceComInfoById(id);
        if (comInfo != null && StringUtils.isNotBlank((CharSequence)comInfo.getPostDesc())) {
            String content = comInfo.getPostDesc().replaceAll("<image ", "<img ");
            comInfo.setPostDesc(content);
        }
        return AjaxResult.success();
    }

    @Log(title="\u4fee\u6539\u4f01\u4e1a\u62db\u8058 \u4f01\u4e1a\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/update"})
    public AjaxResult update(@RequestBody TPublicServiceComInfo tPublicServiceComInfo) {
        return this.toAjax(this.tPublicServiceComInfoService.updateTPublicServiceComInfo(tPublicServiceComInfo));
    }

    @Log(title="\u5220\u9664\u4f01\u4e1a\u62db\u8058 \u4f01\u4e1a\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/delete"})
    public AjaxResult batchRemove(@RequestBody Long[] ids) {
        return this.toAjax(this.tPublicServiceComInfoService.batchRemove(ids));
    }
}

