/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.md;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.domain.md.dto.UnionInboxDto;
import com.ruoyi.system.domain.md.request.NewMsgQuery;
import com.ruoyi.system.service.md.NewMsgService;
import com.ruoyi.system.service.md.NewmsgAppService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d88\u606f"})
@RestController
@RequestMapping(value={"/api/md/msgcenter"})
public class MsgCenterController {
    @Resource
    private NewmsgAppService newmsgAppService;
    @Resource
    private NewMsgService newMsgService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5206\u7c7b\u7684\u6536\u4ef6\u7bb1")
    @RequestMapping(value={"/query/union/inbox"}, method={RequestMethod.GET})
    @ResponseBody
    public R<IPage<UnionInboxDto>> queryUnion(NewMsgQuery query) {
        return R.ok((Object)this.newmsgAppService.queryUnion(query));
    }

    @ApiOperation(value="\u83b7\u53d6\u6536\u4ef6\u6d88\u606f\u8be6\u60c5")
    @RequestMapping(value={"/detail/inbox/{inboxid}"}, method={RequestMethod.GET})
    @ResponseBody
    public R<Map<String, Object>> detail(@PathVariable(value="inboxid") String inboxid) {
        if (StringUtils.isBlank((CharSequence)inboxid)) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        return R.ok((Object)this.newMsgService.getInboxDetail4Map(inboxid));
    }

    @ApiOperation(value="\u7528\u6237\u9605\u8bfb\u6536\u4ef6\u6d88\u606f")
    @RequestMapping(value={"/read/{inboxid}"}, method={RequestMethod.POST})
    @ResponseBody
    public R<String> read(@PathVariable(value="inboxid") String inboxid) {
        if (StringUtils.isBlank((CharSequence)inboxid)) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        this.newMsgService.readInbox(inboxid);
        return R.ok();
    }

    @ApiOperation(value="\u7528\u6237\u9605\u8bfb\u6536\u4ef6\u6d88\u606f")
    @RequestMapping(value={"/read/batch"}, method={RequestMethod.POST})
    @ResponseBody
    public R<String> read(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        NewMsgQuery query = new NewMsgQuery();
        query.setInboxids(ids);
        this.newMsgService.readInbox(null, query);
        return R.ok();
    }

    @ApiOperation(value="\u7528\u6237\u9605\u8bfb\u5206\u7c7b\u4e0b\u5168\u90e8\u6d88\u606f")
    @RequestMapping(value={"/read/all/{msgtype}"}, method={RequestMethod.POST})
    @ResponseBody
    public R<String> readAll(@PathVariable(value="msgtype") Byte msgtype, @RequestBody NewMsgQuery query) {
        if (msgtype == null || StringUtils.isBlank((CharSequence)query.getToUserid()) || query.getToUsertype() == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        this.newMsgService.readInbox(msgtype, query);
        return R.ok();
    }

    @ApiOperation(value="\u7528\u6237\u9605\u8bfb\u5206\u7c7b\u4e0b\u5168\u90e8\u6d88\u606f")
    @RequestMapping(value={"/read/all"}, method={RequestMethod.POST})
    @ResponseBody
    public R<String> readAll(@RequestBody NewMsgQuery query) {
        if (StringUtils.isBlank((CharSequence)query.getToUserid())) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        this.newMsgService.readInbox(null, query);
        return R.ok();
    }
}

