/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.lawcase;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.lawcase.CaseLawEnforcement;
import com.ruoyi.system.domain.lawcase.CaseLawEnforcementExample;
import com.ruoyi.system.service.lawcase.CaseLawEnforcementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7efc\u5408\u6267\u6cd5-\u6267\u6cd5\u68c0\u67e5"})
@RestController
@RequestMapping(value={"/case/law/enforcement"})
public class CaseLawEnforcementController {
    @Autowired
    private CaseLawEnforcementService caseLawEnforcementService;

    @ApiOperation(value="\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", value="\u9875\u7801", dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", dataType="int", paramType="query"), @ApiImplicitParam(name="ylzd5", value="\u6807\u9898", dataType="string", paramType="query"), @ApiImplicitParam(name="ajbm", value="\u53d7\u7406\u7f16\u53f7", dataType="string", paramType="query"), @ApiImplicitParam(name="ajlyLx", value="\u6848\u4ef6\u6765\u6e90\u7c7b\u578b", dataType="string", paramType="query"), @ApiImplicitParam(name="dsr", value="\u5f53\u4e8b\u4eba", dataType="string", paramType="query"), @ApiImplicitParam(name="ajlyMc", value="\u53d7\u7406\u4eba", dataType="string", paramType="query"), @ApiImplicitParam(name="startDate", value="\u53d7\u7406\u5f00\u59cb\u65f6\u95f4", dataType="date", paramType="query"), @ApiImplicitParam(name="endDate", value="\u53d7\u7406\u7ed3\u675f\u65f6\u95f4", dataType="date", paramType="query"), @ApiImplicitParam(name="creditCode", value="\u4f01\u4e1a\u4fe1\u7528id", dataType="date", paramType="query")})
    @RequestMapping(value={"page"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult page(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, String ylzd5, String ajbm, String ajlyLx, String dsr, String ajlyMc, String startDate, String endDate, String creditCode) {
        try {
            if (null == pageNum || pageNum <= 0) {
                pageNum = 1;
            }
            if (null == pageSize || pageSize <= 0) {
                pageSize = 10;
            }
            ZQTPageModel appPageModel = new ZQTPageModel();
            appPageModel.setRecordCount(0L);
            appPageModel.setPageCount(0L);
            appPageModel.setCurPage((long)pageNum.intValue());
            appPageModel.setItemList(new ArrayList());
            CaseLawEnforcementExample example = new CaseLawEnforcementExample();
            CaseLawEnforcementExample.Criteria criteria = example.createCriteria();
            criteria.andState7EqualTo("0");
            if (StringUtils.isNotBlank((CharSequence)ajbm)) {
                criteria.andAjbmLike("%" + ajbm + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)ylzd5)) {
                criteria.andYlzd5Like("%" + ylzd5 + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)ajlyLx)) {
                criteria.andAjlyLxEqualTo(ajlyLx);
            }
            if (StringUtils.isNotBlank((CharSequence)dsr)) {
                criteria.andDsrFrMcLike("%" + dsr + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)ajlyMc)) {
                criteria.andCreatorNameLike("%" + ajlyMc + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)creditCode)) {
                criteria.andYlzd4Like("%" + creditCode + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)startDate)) {
                criteria.andSasjGreaterThanOrEqualTo(startDate);
            }
            if (StringUtils.isNotBlank((CharSequence)endDate)) {
                criteria.andSasjLessThanOrEqualTo(endDate);
            }
            example.setOrderByClause(" create_time desc ");
            int count = this.caseLawEnforcementService.countByExample((Object)example);
            List caseLawEnforcements = this.caseLawEnforcementService.selectByExampleForStartPage((Object)example, pageNum, pageSize);
            appPageModel.setRecordCount((long)count);
            appPageModel.setPageCount((long)Math.ceil(1.0 * (double)count / (double)pageSize.intValue()));
            appPageModel.setCurPage((long)pageNum.intValue());
            appPageModel.setItemList(caseLawEnforcements);
            return AjaxResult.success((Object)appPageModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @ApiOperation(value="\u4fdd\u5b58")
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult saveSlAjysd(@RequestBody CaseLawEnforcement body) {
        try {
            body.setState7("0");
            int ret = 0;
            if (StringUtils.isEmpty((CharSequence)body.getId())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String str = sdf.format(new Date());
                String id = UUID.randomUUID().toString();
                body.setId(id);
                body.setAjbm(String.valueOf(new Date().getTime()));
                body.setCreateTime(str);
                ret = this.caseLawEnforcementService.insert((Object)body);
            } else {
                CaseLawEnforcementExample example = new CaseLawEnforcementExample();
                CaseLawEnforcementExample.Criteria criteria = example.createCriteria();
                criteria.andIdEqualTo(body.getId());
                ret = this.caseLawEnforcementService.updateByExampleSelective((Object)body, (Object)example);
            }
            if (ret > 0) {
                return AjaxResult.success();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
        return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
    }

    @ApiOperation(value="\u8be6\u60c5")
    @RequestMapping(value={"detail"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult detail(@RequestParam(value="id") String id) {
        CaseLawEnforcementExample example = new CaseLawEnforcementExample();
        CaseLawEnforcementExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        CaseLawEnforcement caseLawEnforcement = (CaseLawEnforcement)this.caseLawEnforcementService.selectFirstByExample((Object)example);
        return AjaxResult.success((Object)caseLawEnforcement);
    }

    @ApiOperation(value="\u5220\u9664")
    @RequestMapping(value={"del"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult del(@RequestParam(value="id") String id) {
        CaseLawEnforcement ajsldjb = (CaseLawEnforcement)this.caseLawEnforcementService.selectByPrimaryKey(id);
        ajsldjb.setState7("1");
        this.caseLawEnforcementService.updateByPrimaryKeySelective((Object)ajsldjb);
        return AjaxResult.success();
    }
}

