/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.house.HouseResource;
import com.ruoyi.system.domain.house.vo.HouseResourceExport;
import com.ruoyi.system.domain.house.vo.HouseResourcePageQuery;
import com.ruoyi.system.domain.house.vo.HouseResourceSaveUpdateDto;
import com.ruoyi.system.domain.house.vo.PageBusinessEntityStatisticsQuery;
import com.ruoyi.system.domain.house.vo.YearTaxSaveUpdateDto;
import com.ruoyi.system.service.house.HouseResourceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/house"})
public class HouseResourceController {
    private final HouseResourceService houseResourceService;

    public HouseResourceController(HouseResourceService houseResourceService) {
        this.houseResourceService = houseResourceService;
    }

    @PostMapping
    public AjaxResult saveHouseResource(@RequestBody HouseResourceSaveUpdateDto dto) {
        this.houseResourceService.saveHouseResource(dto);
        return AjaxResult.success();
    }

    @GetMapping
    public AjaxResult getHouseResourceById(@RequestParam String id) {
        return AjaxResult.success((Object)this.houseResourceService.detail(id));
    }

    @PutMapping
    public AjaxResult updateHouseResource(@RequestBody HouseResourceSaveUpdateDto dto) {
        this.houseResourceService.updateHouseResource(dto);
        return AjaxResult.success();
    }

    @DeleteMapping
    public AjaxResult deleteHouseResourceById(@RequestParam String id) {
        this.houseResourceService.deleteHouseResourceById(id);
        return AjaxResult.success();
    }

    @PostMapping(value={"/batch"})
    public AjaxResult batchSaveHouseResources(@RequestBody List<HouseResource> houseResources) {
        this.houseResourceService.batchSaveHouseResources(houseResources);
        return AjaxResult.success();
    }

    @PostMapping(value={"/page"})
    public AjaxResult getPageHouseResources(@RequestBody HouseResourcePageQuery query) {
        if (Objects.nonNull(query.getIncomeSort()) && query.getIncomeSort().length() > 4) {
            return AjaxResult.error((String)"<UNK>4<UNK>");
        }
        return AjaxResult.success((Object)this.houseResourceService.pageHouseResources(query));
    }

    @PostMapping(value={"/profileGraph"})
    public AjaxResult getProfileGraphHouseResources(@RequestBody HouseResourcePageQuery query) {
        return AjaxResult.success((Object)this.houseResourceService.profileGraphHouseResources(query));
    }

    @GetMapping(value={"/app/profileGraph"})
    public AjaxResult getAppProfileGraphHouseResources(HouseResourcePageQuery query) {
        return AjaxResult.success((Object)this.houseResourceService.appProfileGraphHouseResources(query));
    }

    @PostMapping(value={"/list"})
    public AjaxResult getListHouseResources(@RequestBody HouseResourcePageQuery query) {
        return AjaxResult.success((Object)this.houseResourceService.listHouseResources(query));
    }

    @PostMapping(value={"/businessEntityStatistics"})
    public AjaxResult getBusinessEntityStatistics(@RequestBody HouseResourcePageQuery query) {
        return AjaxResult.success((Object)this.houseResourceService.businessEntityStatistics(query));
    }

    @PostMapping(value={"/page/businessEntityStatistics"})
    public AjaxResult getPageBusinessEntityStatistics(@RequestBody PageBusinessEntityStatisticsQuery query) {
        return AjaxResult.success((Object)this.houseResourceService.pageBusinessEntityStatistics(query));
    }

    @PostMapping(value={"/saveYearTax"})
    public AjaxResult postSaveYearTax(@RequestBody YearTaxSaveUpdateDto dto) {
        this.houseResourceService.saveYearTax(dto);
        return AjaxResult.success();
    }

    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, @RequestBody HouseResourcePageQuery query) {
        ArrayList exportList = new ArrayList();
        List pageList = this.houseResourceService.exportListHouseResources(query);
        pageList.forEach(x -> {
            HouseResourceExport houseResourceExport = new HouseResourceExport();
            BeanUtils.copyProperties((Object)x, (Object)houseResourceExport);
            exportList.add(houseResourceExport);
        });
        ExcelUtil util = new ExcelUtil(HouseResourceExport.class);
        util.exportExcel(response, exportList, "\u623f\u6e90\u6570\u636e");
    }

    @GetMapping(value={"/businessEntityInfo"})
    public AjaxResult getBusinessEntityInfo(@RequestParam(value="name") String name) {
        return AjaxResult.success((Object)this.houseResourceService.listByBusinessEntityInfoName(name));
    }
}

