/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.house.BusinessEntityInfo;
import com.ruoyi.system.domain.house.BusinessEntitySell;
import com.ruoyi.system.domain.house.ContrastIncome;
import com.ruoyi.system.mapper.house.BusinessEntityInfoMapper;
import com.ruoyi.system.mapper.house.BusinessEntitySellMapper;
import com.ruoyi.system.mapper.house.ContrastIncomeMapper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contrastIncome"})
public class ContrastIncomeController
extends BaseController {
    private final ContrastIncomeMapper contrastIncomeMapper;
    private final BusinessEntityInfoMapper businessEntityInfoMapper;
    private final BusinessEntitySellMapper businessEntitySellMapper;

    public ContrastIncomeController(ContrastIncomeMapper contrastIncomeMapper, BusinessEntityInfoMapper businessEntityInfoMapper, BusinessEntitySellMapper businessEntitySellMapper) {
        this.contrastIncomeMapper = contrastIncomeMapper;
        this.businessEntityInfoMapper = businessEntityInfoMapper;
        this.businessEntitySellMapper = businessEntitySellMapper;
    }

    @PutMapping(value={"/start"})
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult start() {
        List contrastIncomes = this.contrastIncomeMapper.selectAll();
        for (ContrastIncome contrastIncome : contrastIncomes) {
            contrastIncome.setWgName(contrastIncome.getWgName().replaceAll(" ", ""));
            contrastIncome.setName(contrastIncome.getName().replaceAll(" ", ""));
            contrastIncome.setPrincipal(contrastIncome.getPrincipal().replaceAll(" ", ""));
        }
        for (ContrastIncome contrastIncome : contrastIncomes) {
            System.out.println("\u5f53\u524d\u5904\u7406id: " + contrastIncome.getId());
            List businessEntityInfos = this.businessEntityInfoMapper.selectByName(contrastIncome.getName());
            if (CollectionUtils.isEmpty((Collection)businessEntityInfos)) {
                System.out.println("\u5f53\u524d\u540d\u5b57: " + contrastIncome.getName() + " \u4e0b\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ecf\u8425\u4e3b\u4f53");
                continue;
            }
            if (businessEntityInfos.size() != 1) {
                System.out.println("\u5f53\u524d\u540d\u5b57: " + contrastIncome.getName() + " \u6709\u591a\u4e2a\u5bf9\u5e94\u7684\u7ecf\u8425\u4e3b\u4f53");
                continue;
            }
            BusinessEntityInfo businessEntityInfo = (BusinessEntityInfo)businessEntityInfos.get(0);
            BusinessEntitySell businessEntitySell = this.businessEntitySellMapper.selectBusinessEntitySellByBusinessEntityInfoId(businessEntityInfo.getId(), Integer.valueOf(2024));
            if (Objects.nonNull(businessEntitySell)) {
                businessEntitySell.setYearTax(new BigDecimal(contrastIncome.getIncome()));
                System.out.println("\u4e3abusinessEntityInfo.getName() = " + businessEntityInfo.getName() + "\u66f4\u65b0\u4e86\u7a0e\u6536");
                this.businessEntitySellMapper.updateBusinessEntitySell(businessEntitySell);
                continue;
            }
            BusinessEntitySell entitySell = new BusinessEntitySell();
            entitySell.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            entitySell.setBusinessEntityInfoId(businessEntityInfo.getId());
            entitySell.setYear(Integer.valueOf(2024));
            entitySell.setYearTax(new BigDecimal(contrastIncome.getIncome()));
            System.out.println("\u4e3abusinessEntityInfo.getName() = " + businessEntityInfo.getName() + " \u521b\u5efa\u4e86\u65b0\u7684BusinessEntitySell: " + entitySell);
            this.businessEntitySellMapper.insertBusinessEntitySell(entitySell);
        }
        System.out.println("\u5904\u7406\u5b8c\u6210");
        return AjaxResult.success();
    }
}

