/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.house.Contrast;
import com.ruoyi.system.domain.house.vo.HouseResourcePage;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.mapper.house.ContrastMapper;
import com.ruoyi.system.mapper.house.HouseResourceMapper;
import java.util.List;
import java.util.Objects;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contrast"})
public class ContrastController
extends BaseController {
    private final ContrastMapper contrastMapper;
    private final GridRegionMapper gridRegionMapper;
    private final HouseResourceMapper houseResourceMapper;

    public ContrastController(ContrastMapper contrastMapper, GridRegionMapper gridRegionMapper, HouseResourceMapper houseResourceMapper) {
        this.contrastMapper = contrastMapper;
        this.gridRegionMapper = gridRegionMapper;
        this.houseResourceMapper = houseResourceMapper;
    }

    @PutMapping(value={"/start"})
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult start() {
        List contrasts = this.contrastMapper.selectAll();
        contrasts.parallelStream().forEach(x -> {
            if (StringUtils.hasText((String)x.getWgName())) {
                x.setWgName(x.getWgName().replaceAll(" ", ""));
            }
            if (StringUtils.hasText((String)x.getName())) {
                x.setName(x.getName().replaceAll(" ", ""));
            }
        });
        contrasts.forEach(contrast -> {
            System.out.println("\u5f53\u524did = " + contrast.getId());
            if (!StringUtils.hasText((String)contrast.getWgName())) {
                this.setFlag(contrast, "\u672a\u8bbe\u7f6e\u7ecf\u8425\u4e3b\u4f53\u540d\u79f0");
            } else if (!StringUtils.hasText((String)contrast.getName())) {
                this.setFlag(contrast, "\u7f51\u683c\u9519\u8bef");
            } else {
                GridRegion gridRegion = this.gridRegionMapper.selectByWgName(contrast.getWgName());
                if (Objects.isNull(gridRegion)) {
                    this.setFlag(contrast, "\u793e\u533a\u9519\u8bef");
                } else {
                    List list = this.houseResourceMapper.selectForContrast(gridRegion.getWgCode(), contrast.getName());
                    if (list.isEmpty()) {
                        this.setFlag(contrast, "\u8be5\u7f51\u683c\u4e0b\u6ca1\u6709\u8be5\u7ecf\u8425\u4e3b\u4f53");
                    } else if (list.size() > 1) {
                        this.setFlag(contrast, "\u8be5\u7f51\u683c\u4e0b\u6709\u591a\u4e2a\u540c\u6837\u540d\u5b57\u7684\u7ecf\u8425\u4e3b\u4f53");
                    } else {
                        String flag = "";
                        HouseResourcePage houseResourcePage = (HouseResourcePage)list.get(0);
                        if (Objects.isNull(contrast.getPrincipal()) || !houseResourcePage.getPrincipal().equals(contrast.getPrincipal())) {
                            flag = flag + "\u8054\u7cfb\u4eba\u4e0d\u4e00\u81f4\uff0c";
                        } else if (Objects.isNull(contrast.getPrincipalTel()) || !houseResourcePage.getPrincipalTel().equals(contrast.getPrincipalTel())) {
                            flag = flag + "\u8054\u7cfb\u7535\u8bdd\u4e0d\u4e00\u81f4\uff0c";
                        }
                        this.setFlag(contrast, flag);
                    }
                }
            }
        });
        System.out.println("\u5904\u7406\u7ed3\u675f");
        return AjaxResult.success();
    }

    private void setFlag(Contrast contrast, String flag) {
        contrast.setFlag(flag);
        this.contrastMapper.updateById(contrast);
    }
}

