/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridShop;
import com.ruoyi.system.domain.grid.GridShopStaff;
import com.ruoyi.system.domain.grid.vo.GridShopSearchParam;
import com.ruoyi.system.mapper.grid.GridShopMapper;
import com.ruoyi.system.service.grid.GridShopService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u5546\u94fa\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/grid/shop"})
public class ShopController {
    @Autowired
    GridShopService gridShopService;
    @Autowired
    GridShopMapper gridShopMapper;

    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody GridShop wsShop) throws Exception {
        return this.gridShopService.addGridShop(wsShop);
    }

    @PutMapping(value={"/update"})
    public AjaxResult update(@RequestBody GridShop wsShop) throws Exception {
        return this.gridShopService.updateGridShop(wsShop);
    }

    @DeleteMapping(value={"/deleteShop"})
    public AjaxResult batchRemove(@RequestBody Long[] ids) {
        return this.gridShopService.batchRemove(ids);
    }

    @PostMapping(value={"/addShopStaff"})
    public AjaxResult addShopStaff(@RequestBody List<GridShopStaff> wsShopStaffList) {
        return this.gridShopService.addWsStaff(wsShopStaffList);
    }

    @DeleteMapping(value={"/deleteShopStaff"})
    public AjaxResult deleteShopStaff(@RequestBody Long[] ids) {
        return AjaxResult.success((Object)this.gridShopService.deleteShopStaff(ids));
    }

    @GetMapping(value={"/ListGridShopPeople"})
    public AjaxResult ListGridPeople(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="shopId") Long shopId) {
        return this.gridShopService.ListGridPeople(pageNum, pageSize, shopId);
    }

    @GetMapping
    public AjaxResult ListGridShop(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="belongArea", required=false) String belongArea, @RequestParam(value="shopType", required=false) String shopType, @RequestParam(value="shopName", required=false) String shopName) {
        GridShop wsShop = new GridShop();
        wsShop.setPageNum(Integer.valueOf(pageNum));
        wsShop.setPageSize(Integer.valueOf(pageSize));
        wsShop.setWgCode(wgCode);
        wsShop.setShopType(shopType);
        wsShop.setShopName(shopName);
        wsShop.setBelongArea(belongArea);
        return this.gridShopService.ListGridShop(wsShop);
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getById(@PathVariable(value="id") Long id) throws Exception {
        return AjaxResult.success((Object)this.gridShopService.getGridShopById(id));
    }

    @PostMapping(value={"/importExcel"})
    public AjaxResult dealImportExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="createBy") String createBy) {
        return this.gridShopService.dealImportExcel(file, createBy);
    }

    @GetMapping(value={"/statistic/GridShopNum"})
    public AjaxResult countAll(@RequestParam(value="wgCode", required=false) String wgCode) {
        return AjaxResult.success((Object)this.gridShopService.countAll(wgCode));
    }

    @ApiOperation(value="\u6240\u6709\u5546\u94fa\u5217\u8868")
    @GetMapping(value={"/allShopList"})
    public AjaxResult getShopList(@RequestParam(value="wgCode") String wgCode) {
        GridShopSearchParam param = new GridShopSearchParam();
        if (StringUtils.isNotBlank((CharSequence)wgCode)) {
            param.setWgCodeLikes(Arrays.asList(wgCode));
        }
        return AjaxResult.success((Object)this.gridShopService.getAllShopList(param));
    }

    @GetMapping(value={"/saveLabel"})
    public AjaxResult saveLabel(@RequestParam(value="id") String id, @RequestParam(value="label") String label) {
        return AjaxResult.success((Object)this.gridShopMapper.insertLabelById(id, label));
    }

    @GetMapping(value={"/selectLabel"})
    public AjaxResult selectLabel(@RequestParam(value="id") String id) {
        return AjaxResult.success((String)this.gridShopMapper.selectLabelById(id));
    }
}

