/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.alibaba.fastjson2.JSON;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.uuid.IdUtils;
import com.ruoyi.common.zqt.ZQTImportExcelUtil;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.GridRegionUserExample;
import com.ruoyi.system.domain.grid.vo.GridDxbVO;
import com.ruoyi.system.domain.system.SysUserRole;
import com.ruoyi.system.domain.task.TkCommonTaskExample;
import com.ruoyi.system.mapper.grid.GridRegionUserMapper;
import com.ruoyi.system.mapper.system.SysUserRoleMapper;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.grid.GridRegionUserFacadeService;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.task.TkCommonTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u7f51\u5173\u5173\u8054\u4eba\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/grid/region/user"})
public class RegionUserController {
    @Autowired
    private GridRegionUserFacadeService gridRegionUserFacadeService;
    @Autowired
    private GridRegionUserService gridRegionUserService;
    @Autowired
    private GridRegionUserMapper gridRegionUserMapper;
    @Autowired
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private TkCommonTaskService tkCommonTaskService;
    @Autowired
    private GridRegionService gridRegionService;
    @Autowired
    private ISysUserService sysUserService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public String list(@RequestParam(value="wgId") String wgId, @RequestParam(value="ylzd1") String ylzd1, @RequestParam(value="ylzd2") String ylzd2, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            AjaxResult result = new AjaxResult();
            this.gridRegionUserFacadeService.getRoles(ylzd1, ylzd2, wgId, pageNum, pageSize, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public String insert(@RequestBody GridRegionUser body) {
        try {
            return this.gridRegionUserFacadeService.commit(body, "insert");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    @ResponseBody
    public String delete(@RequestBody GridRegionUser body) {
        try {
            return this.gridRegionUserFacadeService.commit(body, "delete");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    @ResponseBody
    public String update(@RequestBody GridRegionUser body) {
        try {
            return this.gridRegionUserFacadeService.commit(body, "update");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"hqsyerwg"}, method={RequestMethod.GET})
    @ResponseBody
    public String hqsyerwg(@RequestParam(value="parentId") String parentId) {
        try {
            AjaxResult result = new AjaxResult();
            this.gridRegionUserFacadeService.getHqsyerwg(parentId, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u7f51\u683c\u5bf9\u8c61Excel", notes="\u5c06\u7f51\u683c\u5bf9\u8c61Excel\u5bfc\u5165\u6570\u636e\u5e93")
    @RequestMapping(value={"importExcel"}, method={RequestMethod.POST})
    public AjaxResult readExcel(MultipartFile file, @RequestParam String wgLx, @RequestParam String wgId, @RequestParam String userName, @RequestParam String memberClass) {
        HSSFWorkbook workbook;
        ArrayList<SysUserRole> roleUserList;
        ArrayList<GridRegionUser> list;
        String msg;
        block31: {
            msg = "";
            list = new ArrayList<GridRegionUser>();
            roleUserList = new ArrayList<SysUserRole>();
            InputStream is = null;
            workbook = null;
            String fileName = file.getOriginalFilename();
            if (file == null) {
                return AjaxResult.error((int)400, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            try {
                is = file.getInputStream();
                if ("xls".equals(ZQTImportExcelUtil.getPostFix((String)fileName))) {
                    workbook = new HSSFWorkbook(is);
                    break block31;
                }
                if ("xlsx".equals(ZQTImportExcelUtil.getPostFix((String)fileName))) {
                    workbook = new XSSFWorkbook(is);
                    break block31;
                }
                return AjaxResult.error((int)400, (String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
                return AjaxResult.error((int)400, (String)"\u7cfb\u7edf\u9519\u8bef");
            }
        }
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            if (sheet == null) continue;
            for (int j = 1; j <= sheet.getLastRowNum(); ++j) {
                SysUser sysUser;
                String username;
                Row row = sheet.getRow(j);
                if (row == null || memberClass == null) continue;
                if ("3".equals(wgLx)) {
                    SysUserRole sysUserRole = new SysUserRole();
                    if (ZQTImportExcelUtil.getValue((Cell)row.getCell(0)) == null) {
                        msg = msg + "\u7b2c" + j + "\u884c\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a";
                    } else {
                        username = ZQTImportExcelUtil.getValue((Cell)row.getCell(0)).trim();
                        sysUser = this.sysUserService.selectUserByUserName(username);
                        if (sysUser == null) {
                            msg = msg + "\u7b2c" + j + "\u884c\u4e0d\u5b58\u5728\u8be5\u7528\u6237\n";
                            continue;
                        }
                        sysUserRole.setUserId(sysUser.getUserId());
                    }
                    roleUserList.add(sysUserRole);
                    continue;
                }
                GridRegionUser gridRegionUser = new GridRegionUser();
                if (ZQTImportExcelUtil.getValue((Cell)row.getCell(0)) == null) {
                    msg = msg + "\u7b2c" + j + "\u884c\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\n";
                } else {
                    username = ZQTImportExcelUtil.getValue((Cell)row.getCell(0)).trim();
                    sysUser = this.sysUserService.selectUserByUserName(username);
                    if (sysUser == null) {
                        msg = msg + "\u7b2c" + j + "\u884c\u4e0d\u5b58\u5728\u8be5\u7528\u6237\n";
                        continue;
                    }
                    gridRegionUser.setUserId(sysUser.getUserId());
                }
                if (ZQTImportExcelUtil.getValue((Cell)row.getCell(1)) == null) {
                    msg = msg + "\u7b2c" + j + "\u884c\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\n";
                } else {
                    gridRegionUser.setYlzd1(ZQTImportExcelUtil.getValue((Cell)row.getCell(1)).trim());
                }
                if (ZQTImportExcelUtil.getValue((Cell)row.getCell(2)) == null) {
                    msg = msg + "\u7b2c" + j + "\u884c\u7f51\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\n";
                } else {
                    gridRegionUser.setWgId(ZQTImportExcelUtil.getValue((Cell)row.getCell(2)).trim());
                }
                list.add(gridRegionUser);
            }
        }
        if (msg.length() == 0) {
            int records = 0;
            boolean countActivity = false;
            int temp = 0;
            try {
                if ("3".equals(wgLx)) {
                    for (SysUserRole sysUserRole : roleUserList) {
                        SysUserRole sysUserRole2 = this.sysUserRoleMapper.getByRoleIdAndUserId(sysUserRole.getUserId(), wgId);
                        if (sysUserRole2 != null) {
                            SysUserRole deleteRole = new SysUserRole();
                            deleteRole.setRoleId(Long.valueOf(Long.parseLong(wgId)));
                            deleteRole.setUserId(sysUserRole.getUserId());
                            this.sysUserRoleMapper.deleteUserRoleInfo(deleteRole);
                        }
                        sysUserRole.setRoleId(Long.valueOf(Long.parseLong(wgId)));
                        temp = this.sysUserRoleMapper.insertSysRole(sysUserRole);
                        if (temp == 1) {
                            ++records;
                            continue;
                        }
                        msg = msg + "\u7b2c" + records + 1 + "\u6761\u6570\u636e\u5bfc\u5165\u51fa\u9519\uff1a";
                    }
                } else {
                    for (GridRegionUser gridRegionUser : list) {
                        GridRegionUserExample example = new GridRegionUserExample();
                        GridRegionUserExample.Criteria criteria = example.createCriteria();
                        criteria.andIsValidEqualTo("1").andWgIdEqualTo(gridRegionUser.getWgId()).andUserIdEqualTo(gridRegionUser.getUserId());
                        List bsWgxxUsers = this.gridRegionUserFacadeService.getRolesForExample(example);
                        if (bsWgxxUsers.isEmpty()) {
                            String id = UUID.randomUUID().toString();
                            gridRegionUser.setId(id);
                            gridRegionUser.setYlzd2(wgLx);
                            gridRegionUser.setCreateTime(DateUtils.getTime());
                            gridRegionUser.setCreateBy(userName);
                            gridRegionUser.setUpdateTime(DateUtils.getTime());
                            gridRegionUser.setUpdateBy(userName);
                            gridRegionUser.setIsValid("1");
                            temp = this.gridRegionUserService.insertSelective((Object)gridRegionUser);
                        } else {
                            gridRegionUser.setId(((GridRegionUser)bsWgxxUsers.get(0)).getId());
                            gridRegionUser.setUpdateTime(DateUtils.getTime());
                            gridRegionUser.setUpdateBy(userName);
                            temp = this.gridRegionUserService.updateByPrimaryKeySelective((Object)gridRegionUser);
                        }
                        if (temp == 1) {
                            ++records;
                            continue;
                        }
                        msg = msg + "\u7b2c" + records + 1 + "\u6761\u6570\u636e\u5bfc\u5165\u51fa\u9519\uff1a";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return AjaxResult.error((int)400, (String)msg);
            }
            msg = "\u5bfc\u5165" + records + "\u6761\u6570\u636e";
            return AjaxResult.success((String)"success", (Object)msg);
        }
        return AjaxResult.error((int)400, (String)msg);
    }

    @RequestMapping(value={"/wgIdToUser"}, method={RequestMethod.GET})
    @ResponseBody
    public String wgIdToUser(@RequestParam(value="wgCode") String wgCode) {
        try {
            AjaxResult result = new AjaxResult();
            GridRegionUserExample example = new GridRegionUserExample();
            example.createCriteria().andWgIdEqualTo(wgCode).andIsValidEqualTo("1");
            List regionUsers = this.gridRegionUserFacadeService.get(example, null);
            ArrayList<String> list = new ArrayList<String>();
            if (!regionUsers.isEmpty()) {
                for (GridRegionUser bsWgxxUser : regionUsers) {
                    list.add(bsWgxxUser.getUserId());
                }
                SysUser userParam = new SysUser();
                userParam.setDelFlag("0");
                userParam.setStatus("0");
                userParam.setUserIds(list);
                List sysUsers = this.sysUserService.selectUserList(userParam);
                result.buildSuccess("success", (Object)sysUsers);
                return JSON.toJSONString((Object)result);
            }
            result.buildSuccess("success", list);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getWgxxByName"}, method={RequestMethod.GET})
    @ResponseBody
    public String getWgxxByName(@RequestParam(value="wgCode") String wgCode, @RequestParam(value="name") String name) {
        try {
            AjaxResult result = new AjaxResult();
            GridRegionUserExample example = new GridRegionUserExample();
            GridRegionUserExample.Criteria criteria = example.createCriteria();
            if (!StringUtils.isNotEmpty((CharSequence)wgCode)) {
                result.buildError(400, "wgCode\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                criteria.andYlzd1Like("%" + name + "%");
            }
            if ("zswg".equals(wgCode)) {
                criteria.andIsValidEqualTo("1").andYlzd2EqualTo("2");
            } else {
                criteria.andIsValidEqualTo("1").andWgIdLike(wgCode + "%");
            }
            this.gridRegionUserFacadeService.getRegionUserByExample(example, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/getRegionUserByWgIdList"}, method={RequestMethod.POST})
    @ResponseBody
    public String getRegionUserByWgIdList(@RequestBody GridDxbVO wgdxbVO) {
        try {
            AjaxResult result = new AjaxResult();
            if (wgdxbVO.getWgCodeList() == null || wgdxbVO.getWgCodeList().length == 0) {
                result.buildError(400, "\u7f51\u683ccode\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            GridRegionUserExample example = new GridRegionUserExample();
            GridRegionUserExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo("1");
            if (StringUtils.isNotEmpty((CharSequence)wgdxbVO.getName())) {
                criteria.andYlzd1Like("%" + wgdxbVO.getName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)wgdxbVO.getUserId())) {
                criteria.andUserIdEqualTo(wgdxbVO.getUserId());
            }
            List<String> list = Arrays.asList(wgdxbVO.getWgCodeList());
            criteria.andWgIdIn(list);
            criteria.andIsValidEqualTo("1");
            this.gridRegionUserFacadeService.getRegionUserByExample(example, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getRegionUserNumByBaseId"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRegionUserNumByBaseId() {
        try {
            AjaxResult result = new AjaxResult();
            this.gridRegionUserFacadeService.getRegionUserNumByBaseId(result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/getRegionUserNumByBaseIdBysjwg"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRegionUserNumByBaseIdBysjwg() {
        try {
            AjaxResult result = new AjaxResult();
            this.gridRegionUserFacadeService.getRegionUserNumByBaseIdBysjwg(result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/getAllRegionUserNum"}, method={RequestMethod.GET})
    @ResponseBody
    public String getAllRegionUserNum() {
        try {
            AjaxResult result = new AjaxResult();
            this.gridRegionUserFacadeService.getAllRegionUserNum(result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/getWgxxBaseInfoByBaseId"}, method={RequestMethod.GET})
    @ResponseBody
    public String getWgxxBaseInfoByBaseId(@RequestParam String wgCode) {
        try {
            AjaxResult result = new AjaxResult();
            Map wgs = this.listWgNamesAndIds(null, wgCode);
            ArrayList wgIds = (ArrayList)wgs.get("wgIds");
            ArrayList wgNames = (ArrayList)wgs.get("wgNames");
            if (CollectionUtils.isEmpty((Collection)wgNames)) {
                wgNames.add("");
            }
            if (CollectionUtils.isEmpty((Collection)wgIds)) {
                wgIds.add("");
            }
            this.gridRegionUserFacadeService.getRegionUserNumByBaseId(result);
            Map map = (Map)result.get((Object)"data");
            map.put("ZongZhi", 0);
            TkCommonTaskExample tkCommonTaskExample = new TkCommonTaskExample();
            TkCommonTaskExample.Criteria tkCommonTaskCr = tkCommonTaskExample.createCriteria();
            tkCommonTaskCr.andWgCodeIn((List)wgIds);
            tkCommonTaskCr.andStandby1EqualTo("0");
            int wgCount = this.tkCommonTaskService.countByExample((Object)tkCommonTaskExample);
            map.put("wangGe", wgCount);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> listWgNamesAndIds(String wgName, String WgCode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> wgNames = new ArrayList<String>();
        ArrayList<String> wgIds = new ArrayList<String>();
        wgNames.add("");
        wgIds.add("");
        resultMap.put("wgNames", wgNames);
        resultMap.put("wgIds", wgIds);
        GridRegionExample fGridRegionExample = new GridRegionExample();
        GridRegionExample.Criteria fBsWgCr = fGridRegionExample.createCriteria();
        fBsWgCr.andWgCodeEqualTo(WgCode);
        GridRegion fWg = (GridRegion)this.gridRegionService.selectFirstByExample((Object)fGridRegionExample);
        if (null == fWg) {
            return resultMap;
        }
        wgNames.add(fWg.getWgName());
        wgIds.add(fWg.getWgCode());
        GridRegionExample gridRegionExample = new GridRegionExample();
        GridRegionExample.Criteria bsWgCr = gridRegionExample.createCriteria();
        bsWgCr.andWgParentIdEqualTo(fWg.getWgCode());
        List secBsWgs = this.gridRegionService.selectByExample((Object)gridRegionExample);
        for (GridRegion gridRegion : secBsWgs) {
            wgNames.add(gridRegion.getWgName());
            wgIds.add(gridRegion.getWgCode());
        }
        GridRegionExample thirdGridRegionExample = new GridRegionExample();
        GridRegionExample.Criteria thirdBsWgCr = thirdGridRegionExample.createCriteria();
        thirdBsWgCr.andWgParentIdIn(wgIds);
        List thirdBsWgs = this.gridRegionService.selectByExample((Object)thirdGridRegionExample);
        for (GridRegion gridRegion : thirdBsWgs) {
            wgNames.add(gridRegion.getWgName());
            wgIds.add(gridRegion.getWgCode());
        }
        resultMap.put("wgNames", wgNames);
        resultMap.put("wgIds", wgIds);
        return resultMap;
    }

    @ApiOperation(value="\u4fdd\u5b58\u7f51\u683c\u6743\u9650")
    @PostMapping(value={"/saveBatch"})
    @Transactional
    public AjaxResult saveBatch(@RequestBody List<GridRegionUser> body) {
        if (CollectionUtils.isEmpty(body) || StringUtils.isBlank((CharSequence)body.get(0).getUserId())) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        String userId = body.get(0).getUserId();
        GridRegionUserExample example = new GridRegionUserExample();
        GridRegionUserExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(userId);
        this.gridRegionUserMapper.deleteByExample(example);
        if (StringUtils.isNotBlank((CharSequence)body.get(0).getWgId())) {
            GridRegion gridRegion = this.gridRegionService.getWgByCode(body.get(0).getWgId());
            String level = gridRegion.getLevel();
            body.forEach(e -> {
                GridRegion region = this.gridRegionService.getWgByCode(e.getWgId());
                if (!region.getLevel().equals(level)) {
                    throw new ServiceException("\u5fc5\u987b\u7ed1\u5b9a\u76f8\u540c\u5c42\u7ea7\u7684\u7f51\u683c\uff01");
                }
                e.setId(IdUtils.simpleUUID());
                e.setIsValid("1");
                this.gridRegionUserMapper.insertSelective(e);
            });
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u7528\u6237\u6743\u9650\u5217\u8868")
    @GetMapping(value={"/userRegionList"})
    public AjaxResult getUserRegionList(@RequestParam(value="userId") String userId) {
        GridRegionUserExample example = new GridRegionUserExample();
        GridRegionUserExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(userId);
        return AjaxResult.success((Object)this.gridRegionUserService.selectByExample((Object)example));
    }
}

