/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.zqt.ZQTImportExcelUtil;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionDetail;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.GridRegionUserExample;
import com.ruoyi.system.domain.grid.vo.GridDxbVO;
import com.ruoyi.system.domain.grid.vo.GridTreeNode;
import com.ruoyi.system.domain.video.ext.Position;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.service.grid.GridRegionFacadeService;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.grid.GridRegionUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u7f51\u683c\u4fe1\u606f\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/grid/region"})
public class RegionController
extends BaseController {
    @Autowired
    private GridRegionFacadeService gridRegionFacadeService;
    @Autowired
    private GridRegionService gridRegionService;
    @Autowired
    private GridRegionMapper gridRegionMapper;
    @Autowired
    private GridRegionUserService gridRegionUserService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public String list(@RequestParam(value="wgName", required=false) String wgName, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="wgType") String wgType, @RequestParam(value="level", required=false) String level, @RequestParam(value="wgPurpose", required=false) String wgPurpose, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            AjaxResult result = new AjaxResult();
            SysUser user = SecurityUtils.getLoginUser().getUser();
            GridRegionUserExample example = new GridRegionUserExample();
            GridRegionUserExample.Criteria criteria = example.createCriteria();
            criteria.andUserIdEqualTo(user.getUserId());
            criteria.andIsValidEqualTo("1");
            List relationship = this.gridRegionUserService.selectByExample((Object)example);
            String region = relationship.stream().map(GridRegionUser::getWgId).collect(Collectors.joining(","));
            List<String> regions = Arrays.asList(region.split(","));
            ArrayList<String> regionList = new ArrayList<String>();
            if (regions.get(0).equals("320282001")) {
                regionList.add("320282001");
            } else {
                regionList.addAll(regions);
            }
            if (wgType.equals("0")) {
                this.gridRegionFacadeService.getRolesWhereTypeZero(wgName, wgCode, wgType, level, wgPurpose, pageNum, pageSize, result);
            } else {
                this.gridRegionFacadeService.getRoles(wgName, wgCode, wgType, level, wgPurpose, pageNum, pageSize, result, regionList);
            }
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/treeNode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getGridTreeNode(@RequestParam(value="wgName", required=false) String wgName, @RequestParam(value="wgType") String wgType, @RequestParam(value="isShow", required=false) String isShow) {
        try {
            GridTreeNode treeNode = this.gridRegionFacadeService.getTreeNode(wgName, wgType, isShow);
            return AjaxResult.success((Object)treeNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @GetMapping(value={"/levelTree"})
    @ResponseBody
    public AjaxResult getLevelTree(@RequestParam(value="isShow", required=false) String isShow) {
        return AjaxResult.success((Object)this.gridRegionFacadeService.getLevelTreeNode("wgType", isShow));
    }

    @RequestMapping(value={"/roleNode"}, method={RequestMethod.GET})
    @ResponseBody
    public String roleNode(@RequestParam(value="wgType") String wgType) {
        try {
            GridTreeNode treeNode = this.gridRegionFacadeService.getTreeNode("", wgType, "");
            return JSON.toJSONString((Object)treeNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    @ResponseBody
    public String delete(@RequestBody GridRegion body) {
        try {
            return this.gridRegionFacadeService.commit(body, "delete");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public String insert(@RequestBody GridRegion body) {
        try {
            String level = body.getLevel();
            if (level.equals("1") || level.equals("2")) {
                body.setStatus("1");
            } else {
                body.setStatus(level);
            }
            body.setPosition(Integer.valueOf(this.gridRegionMapper.selectMaxPosition() + 1));
            return this.gridRegionFacadeService.commit(body, "insert");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    @ResponseBody
    public String update(@RequestBody GridRegion body) {
        try {
            return this.gridRegionFacadeService.commit(body, "update");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/autoGenerationWgcode"}, method={RequestMethod.GET})
    @ResponseBody
    public String autoGenerationWgcode(@RequestParam(value="parentCode") String parentCode) {
        try {
            String wgcode = this.gridRegionFacadeService.autoGenerationWgcode(parentCode);
            return JSON.toJSONString((Object)wgcode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u7f51\u683c\u4fe1\u606fExcel", notes="\u5c06\u7f51\u683c\u4fe1\u606fExcel\u5bfc\u5165\u6570\u636e\u5e93")
    @RequestMapping(value={"importExcel"}, method={RequestMethod.POST})
    public AjaxResult readExcel(MultipartFile file, @RequestParam String wgType, @RequestParam String userName, @RequestParam String memberClass) {
        HSSFWorkbook workbook;
        ArrayList<GridRegion> list;
        String msg;
        block24: {
            msg = "";
            list = new ArrayList<GridRegion>();
            InputStream is = null;
            workbook = null;
            String fileName = file.getOriginalFilename();
            if (file == null) {
                return AjaxResult.error((int)400, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            try {
                is = file.getInputStream();
                if ("xls".equals(ZQTImportExcelUtil.getPostFix((String)fileName))) {
                    workbook = new HSSFWorkbook(is);
                    break block24;
                }
                if ("xlsx".equals(ZQTImportExcelUtil.getPostFix((String)fileName))) {
                    workbook = new XSSFWorkbook(is);
                    break block24;
                }
                return AjaxResult.error((int)400, (String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                msg = msg + e.getMessage();
            }
            catch (IOException e) {
                e.printStackTrace();
                msg = msg + e.getMessage();
                return AjaxResult.error((int)400, (String)("\u7cfb\u7edf\u9519\u8bef" + msg));
            }
        }
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            if (sheet == null) continue;
            for (int j = 1; j <= sheet.getLastRowNum(); ++j) {
                Row row = sheet.getRow(j);
                if (row == null || memberClass == null || !memberClass.equals("\u7f51\u683c\u4fe1\u606f")) continue;
                GridRegion bsRegion = new GridRegion();
                if (StringUtils.isEmpty((CharSequence)ZQTImportExcelUtil.getValue((Cell)row.getCell(0)))) {
                    msg = msg + "\u7b2c" + j + "\u884c\u7f51\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\n";
                } else {
                    bsRegion.setWgCode(ZQTImportExcelUtil.getValue((Cell)row.getCell(0)));
                }
                if (StringUtils.isEmpty((CharSequence)ZQTImportExcelUtil.getValue((Cell)row.getCell(1)))) {
                    msg = msg + "\u7b2c" + j + "\u884c\u7f51\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n";
                } else {
                    bsRegion.setWgName(ZQTImportExcelUtil.getValue((Cell)row.getCell(1)));
                }
                if (ZQTImportExcelUtil.getValue((Cell)row.getCell(2)) != null) {
                    bsRegion.setWgParentId("".equals(ZQTImportExcelUtil.getValue((Cell)row.getCell(2))) ? null : ZQTImportExcelUtil.getValue((Cell)row.getCell(2)));
                }
                if (ZQTImportExcelUtil.getValue((Cell)row.getCell(3)) != null) {
                    bsRegion.setWgArea(ZQTImportExcelUtil.getValue((Cell)row.getCell(3)));
                }
                bsRegion.setWgCoordinate(ZQTImportExcelUtil.getValue((Cell)row.getCell(4)));
                bsRegion.setWgCentreCoordinate(ZQTImportExcelUtil.getValue((Cell)row.getCell(5)));
                if (ZQTImportExcelUtil.getValue((Cell)row.getCell(6)) != null) {
                    bsRegion.setYlzd2(ZQTImportExcelUtil.getValue((Cell)row.getCell(6)));
                }
                if (StringUtils.isEmpty((CharSequence)ZQTImportExcelUtil.getValue((Cell)row.getCell(7)))) {
                    msg = msg + "\u7b2c" + j + "\u884c\u7f51\u683c\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\n";
                } else {
                    bsRegion.setLevel(ZQTImportExcelUtil.getValue((Cell)row.getCell(7)));
                }
                list.add(bsRegion);
            }
        }
        if (msg.length() == 0) {
            int records = 0;
            boolean countActivity = false;
            int temp = 0;
            try {
                for (GridRegion member : list) {
                    List wgxxbList = this.gridRegionFacadeService.getRolesForExample(wgType, member.getWgCode());
                    if (wgxxbList.isEmpty()) {
                        String id = UUID.randomUUID().toString();
                        member.setId(id);
                        member.setWgType(wgType);
                        member.setCreateTime(DateUtils.getTime());
                        member.setCreateBy(userName);
                        member.setUpdateTime(DateUtils.getTime());
                        member.setUpdateBy(userName);
                        member.setIsValid("1");
                        temp = this.gridRegionService.insertSelective((Object)member);
                    } else {
                        member.setId(((GridRegion)wgxxbList.get(0)).getId());
                        member.setUpdateTime(DateUtils.getDate());
                        member.setUpdateBy(userName);
                        temp = this.gridRegionService.updateByPrimaryKeySelective((Object)member);
                    }
                    if (temp == 1) {
                        ++records;
                        continue;
                    }
                    msg = msg + "\u7b2c" + records + 1 + "\u6761\u6570\u636e\u5bfc\u5165\u51fa\u9519\uff1a";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                msg = msg + e.getMessage();
                return AjaxResult.error((int)400, (String)msg);
            }
            msg = "\u5bfc\u5165" + records + "\u6761\u6570\u636e";
            return AjaxResult.success((String)"success", (Object)msg);
        }
        return AjaxResult.error((int)400, (String)msg);
    }

    @RequestMapping(value={"/getTreeNode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getTreeNode(@RequestParam(value="wgType") String wgType, @RequestParam(value="isShow", required=false) String isShow) {
        SysUser sysUser = this.getLoginUser().getUser();
        List<Object> wgCodeList = new ArrayList();
        if (wgType.equals("1")) {
            List list = this.gridRegionUserService.getPermissionWgCodes(sysUser.getUserId());
            if (CollectionUtils.isEmpty((Collection)list)) {
                return AjaxResult.success((Object)new GridTreeNode());
            }
            wgCodeList = list.stream().map(GridRegionUser::getWgId).collect(Collectors.toList());
        }
        return AjaxResult.success((Object)this.gridRegionFacadeService.treeNode(wgType, wgCodeList, isShow));
    }

    @RequestMapping(value={"/getRegionList"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRegionList(@RequestParam(value="wgType") String wgType, @RequestParam(value="wgCode") String wgCode) {
        try {
            AjaxResult result = new AjaxResult();
            GridRegionExample example = new GridRegionExample();
            GridRegionExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo("1");
            if (StringUtils.isNotEmpty((CharSequence)wgType)) {
                criteria.andWgTypeEqualTo(wgType);
            }
            if (StringUtils.isNotEmpty((CharSequence)wgCode)) {
                criteria.andWgParentIdEqualTo(wgCode);
            }
            this.gridRegionFacadeService.getRegionListByExample(example, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getRegionListByWgCode"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRegionListByWgCode(@RequestParam(value="wgType") String wgType, @RequestParam(value="wgCode") String wgCode) {
        try {
            AjaxResult result = new AjaxResult();
            this.gridRegionFacadeService.getRegionListForTreeNode(wgCode, wgType, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getRegionByWgcode"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRegionByWgcode(@RequestParam(value="wgCode") String wgCode) {
        try {
            AjaxResult result = new AjaxResult();
            GridRegionExample example = new GridRegionExample();
            GridRegionExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo("1");
            if (!StringUtils.isNotEmpty((CharSequence)wgCode)) {
                result.buildError(400, "wgCode\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            criteria.andWgCodeEqualTo(wgCode);
            this.gridRegionFacadeService.getRegionListByExample(example, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getRegionByWgId"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRegionByWgId(@RequestParam(value="wgId") String wgId) {
        try {
            AjaxResult result = new AjaxResult();
            GridRegionExample example = new GridRegionExample();
            GridRegionExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo("1");
            if (!StringUtils.isNotEmpty((CharSequence)wgId)) {
                result.buildError(400, "wgCode\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            criteria.andIdEqualTo(wgId);
            this.gridRegionFacadeService.getRegionListByExample(example, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getRegionByWgmj"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRegionByWgmj(@RequestParam(value="wgCode") String wgCode) {
        try {
            AjaxResult result = new AjaxResult();
            GridRegionExample example = new GridRegionExample();
            GridRegionExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo("1");
            criteria.andWgTypeEqualTo("1");
            if (!StringUtils.isNotEmpty((CharSequence)wgCode)) {
                result.buildError(400, "wgCode\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            criteria.andWgCodeLike("%" + wgCode + "%");
            this.gridRegionFacadeService.getRegionListByWgmj(example, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getCurrentRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public String getCurrentRegion(@RequestParam(value="wgType") String wgType) {
        try {
            AjaxResult result = new AjaxResult();
            if (!StringUtils.isNotEmpty((CharSequence)wgType)) {
                result.buildError(400, "wgType\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            GridRegionExample example = new GridRegionExample();
            GridRegionExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo("1");
            if ("2".equals(wgType)) {
                criteria.andWgTypeEqualTo(wgType);
            } else {
                criteria.andWgTypeEqualTo(wgType).andWgParentIdIsNull();
            }
            this.gridRegionFacadeService.getRegionListByExample(example, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getChildRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public String getChildRegion(@RequestParam(value="wgType") String wgType, @RequestParam(value="wgCode") String wgCode, @RequestParam(value="dxlx") String dxlx, @RequestParam(value="qylx") String qylx) {
        try {
            AjaxResult result = new AjaxResult();
            if (!StringUtils.isNotEmpty((CharSequence)wgType)) {
                result.buildError(400, "wgType\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            if (!StringUtils.isNotEmpty((CharSequence)dxlx)) {
                result.buildError(400, "dxlx\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            GridRegionExample example = new GridRegionExample();
            GridRegionExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo("1");
            if ("2".equals(wgType)) {
                criteria.andWgTypeEqualTo(wgType);
            } else {
                criteria.andWgTypeEqualTo(wgType).andWgParentIdEqualTo(wgCode);
            }
            this.gridRegionFacadeService.getChildRegion(example, dxlx, qylx, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/countRoleUserByWgcode"}, method={RequestMethod.GET})
    @ResponseBody
    public String countRoleUserByWgcode(@RequestParam(value="wgCode") String wgCode) {
        try {
            AjaxResult result = new AjaxResult();
            if (!StringUtils.isNotEmpty((CharSequence)wgCode)) {
                result.buildError(400, "wgCode\u4e0d\u80fd\u4e3a\u7a7a");
                return JSON.toJSONString((Object)result);
            }
            this.gridRegionFacadeService.countRoleUserByWgcode(wgCode, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/selectThirdGridNameByBaseId"}, method={RequestMethod.GET})
    @ResponseBody
    public String selectThirdGridNameByBaseId(Integer pageNum, Integer pageSize) {
        try {
            AjaxResult result = new AjaxResult();
            this.gridRegionFacadeService.selectThirdGridNameByBaseId(result, pageNum, pageSize);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getWsTreeNode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getWsTreeNode(@RequestParam(value="wgType") String wgType, String isShow, @RequestParam(value="isAll", required=false) String isAll) {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        GridRegionUserExample example = new GridRegionUserExample();
        GridRegionUserExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(user.getUserId());
        criteria.andIsValidEqualTo("1");
        List relationship = this.gridRegionUserService.selectByExample((Object)example);
        String region = relationship.stream().map(GridRegionUser::getWgId).collect(Collectors.joining(","));
        List<String> regions = Arrays.asList(region.split(","));
        ArrayList<String> regionList = new ArrayList<String>();
        if (!regions.get(0).equals("320282001")) {
            regionList.add("320282001");
        }
        regionList.addAll(regions);
        if (wgType.equals("0")) {
            return AjaxResult.success((Object)this.gridRegionFacadeService.getWsTreeNodeIncludeTwoPointFive(null, null, null, regionList));
        }
        List<Object> wgCodeList = new ArrayList();
        if (StringUtils.isBlank((CharSequence)isAll) && wgType.equals("1")) {
            List list = this.gridRegionUserService.getPermissionWgCodes("1");
            if (CollectionUtils.isEmpty((Collection)list)) {
                return AjaxResult.success();
            }
            wgCodeList = list.stream().map(GridRegionUser::getWgId).collect(Collectors.toList());
        }
        return AjaxResult.success((Object)this.gridRegionFacadeService.getWsTreeNode(wgType, wgCodeList, isShow, regions));
    }

    @RequestMapping(value={"/getWsSecondRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public String getWsSecondRegion(@RequestParam(value="wgType") String wgType) {
        try {
            AjaxResult result = new AjaxResult();
            GridRegionExample example = new GridRegionExample();
            example.createCriteria().andWgTypeEqualTo(wgType).andIsValidEqualTo("1").andLevelEqualTo("2");
            List gridRegionList = this.gridRegionService.selectByExample((Object)example);
            ArrayList ret = new ArrayList();
            gridRegionList.forEach(gridRegion -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", gridRegion.getId());
                map.put("wgCode", gridRegion.getWgCode());
                map.put("wgName", gridRegion.getWgName());
                map.put("level", gridRegion.getLevel());
                ret.add(map);
            });
            result.buildSuccess("success", ret);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getWsParentRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public String getWsParentRegion(String wgType, String wgCode) {
        try {
            AjaxResult result = new AjaxResult();
            GridRegionExample example = new GridRegionExample();
            GridRegionExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((CharSequence)wgType)) {
                criteria.andWgTypeEqualTo(wgType);
            }
            if (StringUtils.isNotEmpty((CharSequence)wgCode)) {
                criteria.andWgParentIdEqualTo(wgCode);
            }
            criteria.andIsValidEqualTo("1");
            List gridRegionList = this.gridRegionService.selectByExample((Object)example);
            ArrayList ret = new ArrayList();
            if (gridRegionList.size() > 0) {
                gridRegionList.forEach(gridRegion -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", gridRegion.getId());
                    map.put("wgCode", gridRegion.getWgCode());
                    map.put("wgName", gridRegion.getWgName());
                    map.put("level", gridRegion.getLevel());
                    ret.add(map);
                });
            }
            result.buildSuccess("success", ret);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getAreaList"}, method={RequestMethod.GET})
    @ResponseBody
    public String getAreaList(@RequestParam(value="wgName", required=false) String wgName, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="pageNum", required=false) Integer pageNum, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        try {
            AjaxResult result = new AjaxResult();
            this.gridRegionFacadeService.getAreaList(wgName, wgCode, pageNum, pageSize, result);
            return JSON.toJSONString((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getThirdWgList"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getThirdWgList(@RequestBody GridDxbVO wgdxbVO) {
        List result = this.gridRegionFacadeService.getThirdWgList(wgdxbVO.getWgCodeList());
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/getObjList"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getObjList(@RequestBody GridDxbVO wgdxbVO) {
        PageInfo result = this.gridRegionFacadeService.getObjList(wgdxbVO);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/getHouseObjList"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getHouseObjList(@RequestBody GridDxbVO wgdxbVO) {
        PageInfo result = this.gridRegionFacadeService.getHouseObjList(wgdxbVO);
        return AjaxResult.success((Object)result);
    }

    @RequestMapping(value={"/getZsWgInfoList"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getZsWgInfoList() {
        GridRegionExample example = new GridRegionExample();
        example.createCriteria().andIsValidEqualTo("1").andYlzd2EqualTo("1");
        List gridRegionList = this.gridRegionMapper.selectByExample(example);
        ArrayList result = new ArrayList();
        gridRegionList.forEach(gridRegion -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("wgName", gridRegion.getWgName());
            map.put("wgCode", gridRegion.getWgCode());
            map.put("id", gridRegion.getId());
            result.add(map);
        });
        return AjaxResult.success(result);
    }

    @RequestMapping(value={"/getThirdRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getThirdRegion(@RequestParam(value="wgType", required=false) String wgType, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="pageNum", required=false) Integer pageNum, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="name", required=false) String name) {
        List<Object> wgCodeLikes = new ArrayList();
        if (!StringUtils.isBlank((CharSequence)wgCode)) {
            wgCodeLikes = Arrays.asList(wgCode.split(","));
        }
        ArrayList<GridTreeNode> treeNodeList = new ArrayList<GridTreeNode>();
        List gridRegionList = this.gridRegionMapper.getSecondOrThirdRegion(wgType, wgCodeLikes, null, "2");
        for (GridRegion gridRegion : gridRegionList) {
            ArrayList<String> parent = new ArrayList<String>();
            parent.add(gridRegion.getWgCode());
            List children = this.gridRegionMapper.getSecondOrThirdRegion(wgType, parent, name, "3");
            GridTreeNode treeNode = new GridTreeNode();
            BeanUtils.copyProperties((Object)gridRegion, (Object)treeNode);
            treeNode.setName(gridRegion.getWgName());
            treeNode.setId(gridRegion.getId());
            treeNode.setCode(gridRegion.getWgCode());
            treeNode.setParentId(gridRegion.getWgParentId());
            for (GridRegion child : children) {
                GridTreeNode childTreeNode = new GridTreeNode();
                BeanUtils.copyProperties((Object)child, (Object)childTreeNode);
                childTreeNode.setName(child.getWgName());
                childTreeNode.setId(child.getId());
                childTreeNode.setCode(child.getWgCode());
                childTreeNode.setParentId(child.getWgParentId());
                treeNode.getChild().add(childTreeNode);
            }
            treeNodeList.add(treeNode);
        }
        return AjaxResult.success(treeNodeList);
    }

    @RequestMapping(value={"/getOneOrTwoRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getOneOrTwoRegion(@RequestParam(value="level", required=false) String level, @RequestParam(value="pageNum", required=false) Integer pageNum, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        if (level.equals("1")) {
            GridRegionExample example = new GridRegionExample();
            GridRegionExample.Criteria criteria = example.createCriteria();
            criteria.andIsValidEqualTo("1");
            criteria.andLevelEqualTo("1");
            criteria.andWgTypeEqualTo("1");
            List gridRegionList = this.gridRegionMapper.selectByExample(example);
            return AjaxResult.success((Object)gridRegionList);
        }
        SysUser user = SecurityUtils.getLoginUser().getUser();
        GridRegionUserExample example = new GridRegionUserExample();
        GridRegionUserExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(user.getUserId());
        criteria.andIsValidEqualTo("1");
        List relationship = this.gridRegionUserService.selectByExample((Object)example);
        String region = relationship.stream().map(GridRegionUser::getWgId).collect(Collectors.joining(","));
        List<String> regions = Arrays.asList(region.split(","));
        ArrayList<String> regionList = new ArrayList<String>(regions);
        if (regionList.size() == 1 && ((String)regionList.get(0)).equals("320282001")) {
            return AjaxResult.success((Object)this.gridRegionMapper.getAllLevelTwoByType(null));
        }
        return AjaxResult.success((Object)this.gridRegionMapper.getAllLevelTwoByType(regionList));
    }

    @RequestMapping(value={"/getTwoThreeRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getTwoThreeRegion(@RequestParam(value="wgType", required=false) String wgType, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="pageNum", required=false) Integer pageNum, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        GridRegionExample example = new GridRegionExample();
        GridRegionExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andWgTypeEqualTo(wgType);
        criteria.andWgCodeEqualTo(wgCode);
        List gridRegionList = this.gridRegionMapper.selectByExample(example);
        return AjaxResult.success((Object)gridRegionList);
    }

    @RequestMapping(value={"/deleteTreeNode"}, method={RequestMethod.DELETE})
    @ResponseBody
    public AjaxResult deleteTreeNode(@RequestParam(value="id", required=false) String id, @RequestParam(value="wgCode", required=false) String wgCode) {
        GridRegionExample example1 = new GridRegionExample();
        GridRegionExample.Criteria criteria1 = example1.createCriteria();
        criteria1.andIsValidEqualTo("1");
        criteria1.andWgParentIdEqualTo(wgCode);
        if (this.gridRegionMapper.countByFourthCode(wgCode) > 0) {
            throw new RuntimeException("\u5f53\u524d\u83dc\u5355\u5b58\u5728\u623f\u6e90\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        GridRegionExample example = new GridRegionExample();
        GridRegionExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andIdEqualTo(id);
        this.gridRegionMapper.deleteByExample(example);
        this.gridRegionMapper.deleteByExample(example1);
        return AjaxResult.success();
    }

    @RequestMapping(value={"/changeName"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult changeName(@RequestParam(value="id", required=false) String id, @RequestParam(value="name", required=false) String name) {
        return AjaxResult.success((Object)this.gridRegionMapper.changeTreeNodeName(id, name));
    }

    @RequestMapping(value={"/getFourByThreeId"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getFourByThreeId(@RequestParam(value="id", required=false) String id, @RequestParam(value="wgType", required=false) String wgType) {
        if (id == null || id.isEmpty()) {
            return AjaxResult.success();
        }
        String code = this.gridRegionMapper.getWgCodeById(id);
        if (code == null) {
            return AjaxResult.success((String)"id\u4e0d\u5b58\u5728");
        }
        GridRegionExample example1 = new GridRegionExample();
        GridRegionExample.Criteria criteria1 = example1.createCriteria();
        criteria1.andWgParentIdEqualTo(code);
        criteria1.andWgTypeEqualTo(wgType);
        return AjaxResult.success((Object)this.gridRegionMapper.selectByExample(example1));
    }

    @RequestMapping(value={"/changeNameByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult changeNameByCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="name", required=false) String name) {
        return AjaxResult.success((Object)this.gridRegionMapper.changeTreeNodeNameByCode(id, name));
    }

    @RequestMapping(value={"/getRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getRegion(@RequestParam(value="wgCode") String wgCode) {
        HashMap<String, List> res = new HashMap<String, List>();
        List type1 = this.gridRegionService.getGridRegionMapByWgCodeAndWgType(wgCode, "1");
        List type4 = this.gridRegionService.getGridRegionMapByWgCodeAndWgType(wgCode, "4");
        List type5 = this.gridRegionService.getGridRegionMapByWgCodeAndWgType(wgCode, "5");
        List type6 = this.gridRegionService.getGridRegionMapByWgCodeAndWgType(wgCode, "6");
        List type7 = this.gridRegionService.getGridRegionMapByWgCodeAndWgType(wgCode, "7");
        res.put("1", type1);
        res.put("4", type4);
        res.put("5", type5);
        res.put("6", type6);
        res.put("7", type7);
        return AjaxResult.success(res);
    }

    @RequestMapping(value={"/getRegionDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getRegionDetail(@RequestParam(value="id") String id) {
        return AjaxResult.success((String)this.gridRegionMapper.getRegionDetail(id));
    }

    @RequestMapping(value={"/updateRegionDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult updateRegionDetail(@RequestBody GridRegionDetail gridRegionDetail) {
        return AjaxResult.success((Object)this.gridRegionMapper.updateRegionDetail(gridRegionDetail.getId(), gridRegionDetail.getDetail()));
    }

    @RequestMapping(value={"/getRegionJzArea"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getRegionJzArea(@RequestParam(value="id") String id) {
        return AjaxResult.success((String)this.gridRegionMapper.getRegionJzArea(id));
    }

    @RequestMapping(value={"/updateRegionJzArea"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult updateRegionJzArea(@RequestBody GridRegionDetail gridRegionDetail) {
        return AjaxResult.success((Object)this.gridRegionMapper.updateRegionJzArea(gridRegionDetail.getId(), gridRegionDetail.getJzArea()));
    }

    @RequestMapping(value={"/getFourRegionList"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getFourRegionList(@RequestParam(value="wgCode") String wgCode) {
        return AjaxResult.success((Object)this.gridRegionMapper.getFourRegionList(wgCode));
    }

    @PostMapping(value={"/position"})
    public AjaxResult getVideoPosition(@RequestBody Position position) {
        int i;
        List<String> list = Arrays.asList(position.getIds());
        int[] index_now = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            int position_now;
            String channelId = list.get(i);
            index_now[i] = position_now = this.gridRegionMapper.positionById(channelId);
        }
        Arrays.sort(index_now);
        for (i = 0; i < list.size(); ++i) {
            this.gridRegionMapper.position(list.get(i), index_now[i]);
        }
        return AjaxResult.success();
    }

    @RequestMapping(value={"/exchangePosition"}, method={RequestMethod.GET})
    @ResponseBody
    public void exchangePosition() {
        List wgCode = this.gridRegionMapper.getAllWgCode();
        for (String code : wgCode) {
            this.gridRegionMapper.initPositionVariable();
            this.gridRegionMapper.updatePositionByWgCodes(code);
        }
    }

    @RequestMapping(value={"/addRegion"}, method={RequestMethod.POST})
    @ResponseBody
    public String addRegion(@RequestBody GridRegion body) {
        try {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            String date = now.format(formatter);
            body.setWgCode(body.getWgParentId() + date);
            String level = body.getLevel();
            if (level.equals("1") || level.equals("2")) {
                body.setStatus("1");
            } else {
                body.setStatus(level);
            }
            body.setPosition(Integer.valueOf(this.gridRegionMapper.selectMaxPosition() + 1));
            return this.gridRegionFacadeService.commit(body, "insert");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"));
        }
    }

    @RequestMapping(value={"/getThreeByUser"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getThreeByUser(@RequestParam(value="wgType", required=false) String wgType, @RequestParam(value="wgName", required=false) String wgName, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        AjaxResult result = new AjaxResult();
        if (wgCode == null) {
            SysUser user = SecurityUtils.getLoginUser().getUser();
            GridRegionUserExample example = new GridRegionUserExample();
            GridRegionUserExample.Criteria criteria = example.createCriteria();
            criteria.andUserIdEqualTo(user.getUserId());
            criteria.andIsValidEqualTo("1");
            List relationship = this.gridRegionUserService.selectByExample((Object)example);
            String region = relationship.stream().map(GridRegionUser::getWgId).collect(Collectors.joining(","));
            List<String> regions = Arrays.asList(region.split(","));
            ArrayList<String> regionList = new ArrayList<String>();
            List gridRegions = new ArrayList();
            PageHelper.startPage((int)pageNum, (int)pageSize);
            if (regions.get(0).equals("320282001")) {
                gridRegions = this.gridRegionMapper.getAllLevelThree(null, wgType, wgName);
            } else {
                regionList.addAll(regions);
                gridRegions = this.gridRegionMapper.getAllLevelThree(regionList, wgType, wgName);
            }
            for (GridRegion gridRegion : gridRegions) {
                gridRegion.setWgParentName(this.gridRegionMapper.getWgNameByCode(gridRegion.getWgParentId()));
            }
            PageInfo pageInfo = new PageInfo(gridRegions);
            return AjaxResult.success((Object)pageInfo);
        }
        ArrayList<String> regions = new ArrayList<String>();
        regions.add(wgCode);
        ArrayList<String> regionList = new ArrayList<String>();
        regionList.addAll(regions);
        List gridRegions = new ArrayList();
        gridRegions = this.gridRegionMapper.getAllLevelThree(regions, wgType, wgName);
        for (GridRegion gridRegion : gridRegions) {
            gridRegion.setWgParentName(this.gridRegionMapper.getWgNameByCode(gridRegion.getWgParentId()));
        }
        PageInfo pageInfo = new PageInfo(gridRegions);
        return AjaxResult.success((Object)pageInfo);
    }

    @RequestMapping(value={"/getAllTwoRegion"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult getAllTwoRegion() {
        GridRegionExample example = new GridRegionExample();
        GridRegionExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andLevelEqualTo("2");
        criteria.andWgTypeEqualTo("1");
        List gridRegionList = this.gridRegionMapper.selectByExample(example);
        return AjaxResult.success((Object)gridRegionList);
    }
}

