/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridPeople;
import com.ruoyi.system.domain.grid.vo.GridPeopleSearchParam;
import com.ruoyi.system.domain.grid.vo.PeopleBindParam;
import com.ruoyi.system.service.grid.GridPeopleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u4eba\u53e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/grid/people"})
public class PeopleController {
    @Autowired
    private GridPeopleService gridPeopleService;

    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public AjaxResult list(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="rklxCode", required=false) String rklxCode, @RequestParam(value="rkbqCode", required=false) String rkbqCode, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="sex", required=false) String sex, @RequestParam(value="value", required=false) String value) {
        try {
            GridPeople wsPeople = new GridPeople();
            wsPeople.setRklxCode(rklxCode);
            wsPeople.setRkbqCode(rkbqCode);
            wsPeople.setWgCode(wgCode);
            wsPeople.setSex(sex);
            PageHelper.startPage((int)pageNum, (int)pageSize);
            return AjaxResult.success((Object)this.gridPeopleService.page(wsPeople, value));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody GridPeople wsPeople) {
        return this.gridPeopleService.add(wsPeople);
    }

    @PostMapping(value={"/edit"})
    public AjaxResult edit(@RequestBody GridPeople wsPeople) {
        return this.gridPeopleService.edit(wsPeople);
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return this.gridPeopleService.detail(id);
    }

    @GetMapping(value={"/delete"})
    public AjaxResult delete(@RequestParam(value="id") String id) {
        return this.gridPeopleService.delete(id);
    }

    @GetMapping(value={"/detailByIdCard"})
    public AjaxResult detailByIdCard(@RequestParam(value="idCard") String idCard) {
        return this.gridPeopleService.detailByIdCard(idCard);
    }

    @GetMapping(value={"/peopleToHousePage"})
    public AjaxResult peopleToHousePage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="peopleId") String peopleId) {
        return this.gridPeopleService.peopleToHousePage(peopleId, pageNum, pageSize);
    }

    @GetMapping(value={"/peopleToCompanyPage"})
    public AjaxResult peopleToCompanyPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="peopleId") String peopleId) {
        return this.gridPeopleService.peopleToCompanyPage(peopleId, pageNum, pageSize);
    }

    @GetMapping(value={"/peopleToShopPage"})
    public AjaxResult peopleToShopPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="peopleId") String peopleId) {
        return this.gridPeopleService.peopleToShopPage(peopleId, pageNum, pageSize);
    }

    @GetMapping(value={"/peopleInfoPage"})
    public AjaxResult peopleInfoPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="peopleId") String peopleId, @RequestParam(value="type") String type) {
        if ("1".equals(type)) {
            return this.gridPeopleService.peopleToHousePage(peopleId, pageNum, pageSize);
        }
        if ("2".equals(type)) {
            return this.gridPeopleService.peopleToCompanyPage(peopleId, pageNum, pageSize);
        }
        if ("3".equals(type)) {
            return this.gridPeopleService.peopleToShopPage(peopleId, pageNum, pageSize);
        }
        return AjaxResult.success(null);
    }

    @PostMapping(value={"/peopleBind"})
    public AjaxResult peopleBind(@RequestBody PeopleBindParam peopleBindParam) {
        return this.gridPeopleService.peopleBind(peopleBindParam);
    }

    @PostMapping(value={"import"}, headers={"content-type=multipart/form-data"})
    public AjaxResult importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="createId") String createId) {
        return this.gridPeopleService.importExcel(file, createId);
    }

    @ApiOperation(value="\u6240\u6709\u4eba\u53e3\u5217\u8868")
    @GetMapping(value={"/allPeopleList"})
    public AjaxResult getPeopleList(@RequestParam(value="wgCode") String wgCode) {
        GridPeopleSearchParam param = new GridPeopleSearchParam();
        if (StringUtils.isNotBlank((CharSequence)wgCode)) {
            param.setWgCodeLikes(Arrays.asList(wgCode.split(",")));
        }
        return AjaxResult.success((Object)this.gridPeopleService.getAllPeople(param));
    }
}

