/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.IdcardUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.common.zqt.ZQTPageUtil;
import com.ruoyi.system.domain.grid.GridPendingPeople;
import com.ruoyi.system.domain.grid.GridPendingPeopleExample;
import com.ruoyi.system.domain.grid.GridPeople;
import com.ruoyi.system.domain.grid.GridPeopleExample;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.GridWgLog;
import com.ruoyi.system.domain.grid.ext.GridPendingPeopleExt;
import com.ruoyi.system.service.grid.GridPendingPeopleService;
import com.ruoyi.system.service.grid.GridPeopleService;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.grid.GridWgLogService;
import com.ruoyi.system.service.system.ISysUserService;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u5f85\u8ba4\u9886\u4eba\u53e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/grid/pendingPeople"})
public class PendingPeopleController {
    @Autowired
    private GridPendingPeopleService gridPendingPeopleService;
    @Autowired
    private GridPeopleService gridPeopleService;
    @Autowired
    private GridRegionService gridRegionService;
    @Autowired
    private GridWgLogService gridWgLogService;
    @Autowired
    private ISysUserService sysUserService;

    @GetMapping(value={"/list"})
    public AjaxResult list(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="wgCode") String wgCode, @RequestParam(value="level") String level, @RequestParam(value="value", required=false) String value) {
        try {
            GridPendingPeopleExample ex = new GridPendingPeopleExample();
            GridPendingPeopleExample.Criteria ca = ex.createCriteria();
            GridPendingPeopleExample.Criteria ca1 = ex.createCriteria();
            ca.andStatusEqualTo("0");
            ca1.andStatusEqualTo("0");
            if ("3".equals(level)) {
                GridRegionExample example = new GridRegionExample();
                GridRegionExample.Criteria criteria = example.createCriteria();
                criteria.andIsValidEqualTo("1");
                criteria.andWgCodeEqualTo(wgCode);
                criteria.andLevelEqualTo("3");
                GridRegion bs = (GridRegion)this.gridRegionService.selectFirstByExample((Object)example);
                if (bs != null) {
                    wgCode = bs.getWgParentId();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)wgCode)) {
                ca.andWgCodeLike(wgCode + "%");
                ca1.andWgCodeLike(wgCode + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)value)) {
                ca.andPersonNameLike("%" + value + "%");
                ca1.andIdCardLike("%" + value + "%");
            }
            ex.or(ca1);
            ex.setOrderByClause(" create_time desc, person_name");
            PageHelper.startPage((int)pageNum, (int)pageSize);
            List peopleList = this.gridPendingPeopleService.selectByExample((Object)ex);
            List peopleExtList = BeanCopyUtil.bathToBean((Collection)peopleList, GridPendingPeopleExt.class);
            for (GridPendingPeopleExt p : peopleExtList) {
                this.gridPendingPeopleService.selectGridPendingPeopleExt(p);
            }
            PageInfo pageInfo = ZQTPageUtil.build((List)peopleList, (List)peopleExtList);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody GridPendingPeople wsPendingPeople) {
        Validator.validateNotEmpty((Object)wsPendingPeople.getIdCard(), (String)"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Validator.validateNotEmpty((Object)wsPendingPeople.getPhone(), (String)"\u624b\u673a\u53f7\u4e3a\u4e0d\u80fd\u7a7a");
        String ID_18 = wsPendingPeople.getIdCard();
        boolean valid = IdcardUtil.isValidCard((String)ID_18);
        if (!valid) {
            return AjaxResult.error((int)400, (String)"\u8be5\u4eba\u5458\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u5408\u6cd5");
        }
        GridPendingPeopleExample ex = new GridPendingPeopleExample();
        GridPendingPeopleExample.Criteria ca = ex.createCriteria();
        ca.andStatusEqualTo("1");
        ca.andIdCardEqualTo(wsPendingPeople.getIdCard());
        int count = this.gridPendingPeopleService.countByExample((Object)ex);
        if (count > 0) {
            return AjaxResult.error((int)400, (String)"\u8be5\u4eba\u5458\u8eab\u4efd\u8bc1\u4fe1\u606f\u5df2\u7ecf\u767b\u8bb0");
        }
        GridPendingPeopleExample ex1 = new GridPendingPeopleExample();
        GridPendingPeopleExample.Criteria ca1 = ex1.createCriteria();
        ca1.andStatusEqualTo("1");
        ca1.andPhoneEqualTo(wsPendingPeople.getPhone());
        int count1 = this.gridPendingPeopleService.countByExample((Object)ex1);
        if (count1 > 0) {
            return AjaxResult.error((int)400, (String)"\u8be5\u4eba\u5458\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u767b\u8bb0");
        }
        wsPendingPeople.setBirthday(IdcardUtil.getYearByIdCard((String)ID_18) + "-" + IdcardUtil.getMonthByIdCard((String)ID_18) + "-" + IdcardUtil.getDayByIdCard((String)ID_18));
        if (StringUtils.isBlank((CharSequence)wsPendingPeople.getSex())) {
            wsPendingPeople.setSex(IdcardUtil.getGenderByIdCard((String)ID_18) == 1 ? "\u7537" : "\u5973");
        }
        if (StringUtils.isNotBlank((CharSequence)wsPendingPeople.getId())) {
            wsPendingPeople.setStatus("0");
            wsPendingPeople.setUpdateTime(DateUtil.formatDateTime((Date)new Date()));
            this.gridPendingPeopleService.updateByPrimaryKeySelective((Object)wsPendingPeople);
        } else {
            wsPendingPeople.setId(IdUtil.fastSimpleUUID());
            wsPendingPeople.setCreateTime(DateUtil.formatDateTime((Date)new Date()));
            wsPendingPeople.setStatus("0");
            this.gridPendingPeopleService.insertSelective((Object)wsPendingPeople);
        }
        this.gridPendingPeopleService.sendMessage(wsPendingPeople.getPersonName(), wsPendingPeople.getWgCode());
        return AjaxResult.success(null);
    }

    @GetMapping(value={"/agree"})
    public AjaxResult agree(@RequestParam(value="id") String id, @RequestParam(value="wgCode") String wgCode, @RequestParam(value="createId") String createId, @RequestParam(value="rklxCode", required=false) String rklxCode, @RequestParam(value="rkbqCode", required=false) String rkbqCode) {
        GridPendingPeople wsPendingPeople = (GridPendingPeople)this.gridPendingPeopleService.selectByPrimaryKey(id);
        GridPeopleExample ex = new GridPeopleExample();
        GridPeopleExample.Criteria ca = ex.createCriteria();
        ca.andIdCardEqualTo(wsPendingPeople.getIdCard());
        ca.andIsValidEqualTo(Byte.valueOf("1"));
        int count = this.gridPeopleService.countByExample((Object)ex);
        if (count > 0) {
            return AjaxResult.error((int)400, (String)"\u8be5\u4eba\u5458\u8eab\u4efd\u8bc1\u4fe1\u606f\u5df2\u5728\u4eba\u53e3\u4fe1\u606f\u5e93\u4e2d");
        }
        GridPeopleExample ex1 = new GridPeopleExample();
        GridPeopleExample.Criteria ca1 = ex1.createCriteria();
        ca1.andPhoneEqualTo(wsPendingPeople.getPhone());
        ca1.andIsValidEqualTo(Byte.valueOf("1"));
        int count1 = this.gridPeopleService.countByExample((Object)ex1);
        if (count1 > 0) {
            return AjaxResult.error((int)400, (String)"\u8be5\u4eba\u5458\u624b\u673a\u53f7\u7801\u5df2\u5728\u4eba\u53e3\u4fe1\u606f\u5e93\u4e2d");
        }
        GridPeople wsPeople = (GridPeople)BeanCopyUtil.toBean((Object)wsPendingPeople, GridPeople.class);
        wsPeople.setId(IdUtil.fastSimpleUUID());
        wsPeople.setCreateTime(DateUtil.formatDateTime((Date)new Date()));
        wsPeople.setWgCode(wgCode);
        wsPeople.setCreateId(createId);
        wsPeople.setRklxCode(rklxCode);
        wsPeople.setRkbqCode(rkbqCode);
        this.gridPeopleService.insertSelective((Object)wsPeople);
        wsPendingPeople.setStatus("1");
        this.gridPendingPeopleService.updateByPrimaryKeySelective((Object)wsPendingPeople);
        GridWgLog wsWgLog = new GridWgLog();
        wsWgLog.setCreateId(createId);
        SysUser sysUser = this.sysUserService.selectUserById(createId);
        wsWgLog.setCreateName(sysUser != null ? sysUser.getNickName() : "");
        wsWgLog.setCreateWgCode(wsPeople.getWgCode());
        wsWgLog.setObjectName(wsPeople.getPersonName());
        wsWgLog.setType("1");
        wsWgLog.setOperate("insert");
        wsWgLog.setObjectId(wsPeople.getId());
        this.gridWgLogService.add(wsWgLog);
        return AjaxResult.success(null);
    }

    @GetMapping(value={"/reject"})
    public AjaxResult reject(@RequestParam(value="id") String id, @RequestParam(value="createId") String createId) {
        GridPendingPeople wsPendingPeople = (GridPendingPeople)this.gridPendingPeopleService.selectByPrimaryKey(id);
        wsPendingPeople.setStatus("2");
        wsPendingPeople.setCreateId(createId);
        this.gridPendingPeopleService.updateByPrimaryKeySelective((Object)wsPendingPeople);
        return AjaxResult.success(null);
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        GridPendingPeople wsPendingPeople = (GridPendingPeople)this.gridPendingPeopleService.selectByPrimaryKey(id);
        GridPendingPeopleExt wsPendingPeopleExt = (GridPendingPeopleExt)BeanCopyUtil.toBean((Object)wsPendingPeople, GridPendingPeopleExt.class);
        if (wsPendingPeopleExt != null) {
            this.gridPendingPeopleService.selectGridPendingPeopleExt(wsPendingPeopleExt);
        }
        return AjaxResult.success((Object)wsPendingPeopleExt);
    }

    @GetMapping(value={"/detail"})
    public AjaxResult detailPhone(@RequestParam(value="phone") String phone) {
        GridPendingPeopleExample ex = new GridPendingPeopleExample();
        GridPendingPeopleExample.Criteria ca = ex.createCriteria();
        ca.andPhoneEqualTo(phone);
        GridPendingPeople wsPendingPeople = (GridPendingPeople)this.gridPendingPeopleService.selectFirstByExample((Object)ex);
        GridPendingPeopleExt wsPendingPeopleExt = (GridPendingPeopleExt)BeanCopyUtil.toBean((Object)wsPendingPeople, GridPendingPeopleExt.class);
        if (wsPendingPeopleExt != null) {
            this.gridPendingPeopleService.selectGridPendingPeopleExt(wsPendingPeopleExt);
        }
        return AjaxResult.success((Object)wsPendingPeopleExt);
    }
}

