/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridInterview;
import com.ruoyi.system.service.grid.GridInterviewService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u4f01\u4e1a/\u5546\u94fa\u5b89\u5168\u8d70\u8bbf\u65e5\u5fd7"})
@RestController
@RequestMapping(value={"/api/grid/interview"})
public class InterviewController {
    @Autowired
    private GridInterviewService gridInterviewService;

    @GetMapping(value={"/page"})
    public AjaxResult interviewPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="cid") String cid) {
        try {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            PageInfo pageInfo = new PageInfo(this.gridInterviewService.interviewPage(cid));
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @PostMapping(value={"/add"})
    public AjaxResult interviewAdd(@RequestBody GridInterview wsInterview) {
        return AjaxResult.success((String)this.gridInterviewService.interviewAdd(wsInterview));
    }

    @PostMapping(value={"/edit"})
    public AjaxResult interviewEdit(@RequestBody GridInterview wsInterview) {
        this.gridInterviewService.edit(wsInterview);
        return AjaxResult.success(null);
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult interviewDetail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.gridInterviewService.detail(id));
    }

    @GetMapping(value={"/delete"})
    public AjaxResult interviewDelete(@RequestParam(value="ids") String ids) {
        this.gridInterviewService.delete(ids);
        return AjaxResult.success(null);
    }

    @GetMapping(value={"/count"})
    public AjaxResult interviewCount(@RequestParam(value="type") String type, @RequestParam(value="id") String id) {
        return AjaxResult.success((Object)this.gridInterviewService.count(type, id));
    }

    @GetMapping(value={"/pending"})
    public AjaxResult pending(@RequestParam(value="type") String type, @RequestParam(value="id") String id) {
        long a = this.gridInterviewService.pending(type, id);
        if (a > 0L) {
            return AjaxResult.success((Object)true);
        }
        return AjaxResult.success((Object)false);
    }
}

