/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridHouse;
import com.ruoyi.system.domain.grid.GridHouseInterview;
import com.ruoyi.system.domain.grid.GridHousePeople;
import com.ruoyi.system.domain.grid.vo.GridHouseSearchParam;
import com.ruoyi.system.service.grid.GridHouseInterviewService;
import com.ruoyi.system.service.grid.GridHousePeopleService;
import com.ruoyi.system.service.grid.GridHouseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u623f\u5c4b\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/grid/house"})
public class HouseController {
    @Autowired
    private GridHouseService gridHouseService;
    @Autowired
    private GridHousePeopleService gridHousePeopleService;
    @Autowired
    private GridHouseInterviewService gridHouseInterviewService;

    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public AjaxResult list(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="fwlxCode", required=false) String fwlxCode, @RequestParam(value="fwztCode", required=false) String fwztCode, @RequestParam(value="houseName", required=false) String houseName, @RequestParam(value="value", required=false) String value) {
        try {
            GridHouseSearchParam wsHouse = new GridHouseSearchParam();
            if (StringUtils.isNotBlank((CharSequence)wgCode)) {
                wsHouse.setWgCodeLikes(Arrays.asList(wgCode.split(",")));
            }
            wsHouse.setFwlxCode(fwlxCode);
            wsHouse.setFwztCode(fwztCode);
            wsHouse.setHouseName(houseName);
            PageHelper.startPage((int)pageNum, (int)pageSize);
            PageInfo pageInfo = this.gridHouseService.page(wsHouse, value);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody GridHouse wsHouse) {
        return this.gridHouseService.add(wsHouse);
    }

    @PostMapping(value={"/edit"})
    public AjaxResult edit(@RequestBody GridHouse wsHouse) {
        return this.gridHouseService.edit(wsHouse);
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return this.gridHouseService.detail(id);
    }

    @GetMapping(value={"/delete"})
    public AjaxResult delete(@RequestParam(value="id") String id) {
        return this.gridHouseService.delete(id);
    }

    @GetMapping(value={"/houseToPeoplePage"})
    public AjaxResult houseToPeoplePage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="houseId") String houseId) {
        try {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            PageInfo pageInfo = this.gridHouseService.houseToPeoplePage(houseId);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/houseBindPeople"})
    public AjaxResult houseBindPeople(@RequestBody GridHousePeople wsHousePeople) {
        return this.gridHouseService.houseBindPeople(wsHousePeople);
    }

    @GetMapping(value={"/houseUnbindPeople"})
    public AjaxResult houseUnbindPeople(@RequestParam(value="id") String id) {
        this.gridHousePeopleService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }

    @PostMapping(value={"import"}, headers={"content-type=multipart/form-data"})
    public AjaxResult importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="createId") String createId) {
        return this.gridHouseService.importExcel(file, createId);
    }

    @GetMapping(value={"/interview/page"})
    public AjaxResult interviewPage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="houseId") String houseId) {
        try {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            PageInfo pageInfo = new PageInfo(this.gridHouseInterviewService.interviewPage(houseId));
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/interview/add"})
    public AjaxResult interviewAdd(@RequestBody GridHouseInterview wsHouseInterview) {
        return AjaxResult.success((String)this.gridHouseInterviewService.interviewAdd(wsHouseInterview));
    }

    @GetMapping(value={"interview/detail/{id}"})
    public AjaxResult interviewDetail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.gridHouseInterviewService.detail(id));
    }

    @ApiOperation(value="\u6240\u6709\u623f\u5c4b\u5217\u8868")
    @GetMapping(value={"/allHouseList"})
    public AjaxResult getHouseList() {
        return AjaxResult.success((Object)this.gridHouseService.getAllHouseList());
    }
}

