/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.ext.GridGroupExt;
import com.ruoyi.system.service.grid.GridGroupLandService;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u96c6\u56e2\u4e0e\u7ecf\u6d4e\u5730\u5757\u5173\u8054"})
@RestController
@RequestMapping(value={"/api/grid/group/land"})
public class GroupLandController {
    @Autowired
    private GridGroupLandService gridGroupLandService;

    @GetMapping(value={"/page"})
    public AjaxResult page(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="groupName", required=false) String groupName) {
        return AjaxResult.success((Object)this.gridGroupLandService.page(pageNo, pageSize, groupName));
    }

    @PostMapping(value={"/saveOrUpdate"})
    public AjaxResult saveOrUpdate(@RequestBody GridGroupExt wsGroupExt) {
        return this.gridGroupLandService.saveOrUpdate(wsGroupExt);
    }

    @GetMapping(value={"/detail"})
    public AjaxResult detail(@RequestParam(value="id") String id) {
        return AjaxResult.success((Object)this.gridGroupLandService.detail(id));
    }

    @GetMapping(value={"/delete"})
    public AjaxResult delete(@RequestParam(value="id") String id) {
        this.gridGroupLandService.delete(id);
        return AjaxResult.success((String)"success");
    }

    @PostMapping(value={"/sumlandAreaTotal"})
    public AjaxResult sumlandAreaTotal(@RequestBody List<String> landIds) {
        return AjaxResult.success((String)this.gridGroupLandService.sumlandAreaTotal(landIds));
    }

    @PostMapping(value={"/getRelatedCompanyList"})
    public AjaxResult getRelatedCompanyList(@RequestBody List<String> landIds) {
        return AjaxResult.success((Object)this.gridGroupLandService.getRelatedCompanyList(landIds));
    }

    @GetMapping(value={"bigScreen/permuSort/list"})
    public AjaxResult permuSortList(@RequestParam(value="year", required=false) String year) {
        return AjaxResult.success((Object)this.gridGroupLandService.permuSortList(year));
    }
}

