/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.enums.GridRegionSearchParam;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.service.grid.GridCompanyService;
import com.ruoyi.system.service.grid.GridHouseService;
import com.ruoyi.system.service.grid.GridPeopleService;
import com.ruoyi.system.service.grid.GridShopService;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u7f51\u683c\u5bf9\u8c61\u91c7\u96c6"})
@RestController
@RequestMapping(value={"/api/grid/object"})
public class GridObjectController {
    @Autowired
    private GridPeopleService gridPeopleService;
    @Autowired
    private GridHouseService gridHouseService;
    @Autowired
    private GridCompanyService gridCompanyService;
    @Autowired
    private GridShopService gridShopService;
    @Autowired
    private GridRegionMapper gridRegionMapper;

    @GetMapping(value={"/infoWithType"})
    public AjaxResult infoWithType(@RequestParam(value="wgCode", required=false) String wgCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List peopleList = this.gridPeopleService.countGridPeople(wgCode);
        map.put("people", peopleList);
        map.put("peopleAllNum", this.gridPeopleService.countAll(wgCode));
        map.put("peopleRkbq", this.gridPeopleService.countGridPeopleByRkbq(wgCode));
        map.put("specialPeopleNum", this.gridPeopleService.countSpecialPeople(wgCode) != null ? this.gridPeopleService.countSpecialPeople(wgCode) : 0);
        int houseAllNum = this.gridHouseService.countAll(wgCode);
        List houseList = this.gridHouseService.countGridHouse(wgCode);
        map.put("house", houseList);
        map.put("houseAllNum", houseAllNum);
        List houseFwztList = this.gridHouseService.countGridHouseByFwzt(wgCode);
        map.put("houseFwzt", houseFwztList);
        BigDecimal houseAllCount = new BigDecimal(houseAllNum);
        for (Map mapH : houseFwztList) {
            if (houseAllNum != 0) {
                BigDecimal percent = new BigDecimal(String.valueOf(mapH.get("number"))).divide(houseAllCount, 3, 4).stripTrailingZeros();
                NumberFormat perFormat = NumberFormat.getPercentInstance(Locale.CHINA);
                perFormat.setMinimumFractionDigits(0);
                mapH.put("percent", perFormat.format(percent));
                continue;
            }
            mapH.put("percent", "0%");
        }
        List companyList = this.gridCompanyService.countGridCompany(wgCode);
        map.put("company", companyList);
        map.put("companyAllNum", this.gridCompanyService.countAll(wgCode));
        List shopList = this.gridShopService.countGridShop(wgCode);
        map.put("shop", shopList);
        map.put("shopAllNum", this.gridShopService.countAll(wgCode));
        GridRegionSearchParam param = new GridRegionSearchParam();
        param.setLevel("4");
        if (StringUtils.isNotBlank((CharSequence)wgCode)) {
            List<String> wgCodes = Arrays.asList(wgCode.split(","));
            param.setWgCodeLikes(wgCodes);
        }
        int wgCount = this.gridRegionMapper.countByParams(param);
        map.put("wgCount", wgCount);
        return AjaxResult.success(map);
    }

    @GetMapping(value={"/info"})
    public AjaxResult info(@RequestParam(value="wgCode", required=false) String wgCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("peopleAllNum", this.gridPeopleService.countAll(wgCode));
        map.put("houseAllNum", this.gridHouseService.countAll(wgCode));
        map.put("companyAllNum", this.gridCompanyService.countAll(wgCode));
        map.put("shopAllNum", this.gridShopService.countAll(wgCode));
        return AjaxResult.success(map);
    }

    @GetMapping(value={"/basicInfo"})
    public AjaxResult basicInfo(@RequestParam(value="wgCode", required=false) String wgCode) {
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "\u4eba\u53e3\u603b\u6570");
        map.put("number", this.gridPeopleService.countAll(wgCode));
        list.add(map);
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("name", "\u4f4f\u5b85\u603b\u6570");
        map1.put("number", this.gridHouseService.countAll(wgCode));
        list.add(map1);
        List peopleList = this.gridPeopleService.countGridPeople(wgCode);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "\u6237\u7c4d\u4eba\u53e3");
        map2.put("number", (String)((Map)peopleList.get(0)).get("number"));
        list.add(map2);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("name", "\u975e\u6237\u7c4d\u4eba\u53e3");
        map3.put("number", (String)((Map)peopleList.get(1)).get("number"));
        list.add(map3);
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        map4.put("name", "\u7279\u6b8a\u4eba\u53e3");
        map4.put("number", this.gridPeopleService.countSpecialPeople(wgCode) != null ? this.gridPeopleService.countSpecialPeople(wgCode) : 0);
        list.add(map4);
        return AjaxResult.success(list);
    }

    @GetMapping(value={"/countWsPeopleRklxByGrid"})
    public AjaxResult countWsPeopleRklxByGrid(@RequestParam(value="wgCode", required=false) String wgCode) {
        return AjaxResult.success((Object)this.gridPeopleService.countGridPeopleRklxByGrid(wgCode));
    }

    @GetMapping(value={"/infoWithGrid"})
    public AjaxResult infoWithGrid() {
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("peopleGrid", this.gridPeopleService.countGridPeopleByGrid());
        map.put("houseGrid", this.gridHouseService.countGridHouseByGrid());
        map.put("companyGrid", this.gridCompanyService.countGridCompanyByGrid());
        map.put("shopGrid", this.gridShopService.countGridShopByGrid());
        return AjaxResult.success(map);
    }
}

