/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.alibaba.fastjson2.JSON;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridItemLib;
import com.ruoyi.system.service.grid.GridItemLibFacadeService;
import com.ruoyi.system.service.grid.GridItemLibService;
import io.swagger.annotations.Api;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u4e8b\u9879\u5e93"})
@RestController
@RequestMapping(value={"/api/grid/itemLib"})
public class GridItemLibController {
    @Autowired
    private GridItemLibFacadeService gridItemLibFacadeService;
    @Autowired
    private GridItemLibService gridItemLibService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public String list(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, String sxfl, String sxmc) {
        AjaxResult result = new AjaxResult();
        this.gridItemLibFacadeService.getRoles(sxfl, sxmc, Integer.valueOf(pageNum), Integer.valueOf(pageSize), result);
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public String add(@RequestBody GridItemLib lib) {
        lib.setId(UUID.randomUUID().toString());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        lib.setCreateTime(df.format(new Date()));
        int result = this.gridItemLibService.insert((Object)lib);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)lib));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"fail"));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public String delete(@RequestParam String id) {
        int result = this.gridItemLibService.deleteByStringPrimaryKey(id);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)id));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"fail"));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public String update(@RequestBody GridItemLib lib) {
        int result = this.gridItemLibService.updateByPrimaryKeySelective((Object)lib);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)lib));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"fail"));
    }

    @RequestMapping(value={"/countSxfl"}, method={RequestMethod.GET})
    @ResponseBody
    public String countSxfl() {
        AjaxResult result = new AjaxResult();
        this.gridItemLibFacadeService.countSxfl(result);
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(value={"/countBySxfl"}, method={RequestMethod.GET})
    @ResponseBody
    public String countBySxfl() {
        AjaxResult result = new AjaxResult();
        this.gridItemLibFacadeService.countBySxfl(result);
        return JSON.toJSONString((Object)result);
    }
}

