/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.alibaba.fastjson2.JSON;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridItemDaily;
import com.ruoyi.system.domain.grid.GridItemDailyExample;
import com.ruoyi.system.service.grid.GridItemDailyFacadeService;
import com.ruoyi.system.service.grid.GridItemDailyService;
import io.swagger.annotations.Api;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u65e5\u5e38\u4e8b\u9879"})
@RestController
@RequestMapping(value={"/api/grid/itemDaily"})
public class GridItemDailyController {
    @Autowired
    private GridItemDailyFacadeService gridItemDailyFacadeService;
    @Autowired
    private GridItemDailyService gridItemDailyService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public String list(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="sxbm") String sxbm, @RequestParam(value="sxmc") String sxmc) {
        AjaxResult result = new AjaxResult();
        this.gridItemDailyFacadeService.getRoles(sxbm, sxmc, Integer.valueOf(pageNum), Integer.valueOf(pageSize), result);
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(value={"/list_search"}, method={RequestMethod.GET})
    @ResponseBody
    public String listSearch(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="sxbm") String sxbm, @RequestParam(value="sxmc") String sxmc, @RequestParam(value="sjfl") String sjfl) {
        AjaxResult result = new AjaxResult();
        this.gridItemDailyFacadeService.getSearch(sjfl, sxbm, sxmc, Integer.valueOf(pageNum), Integer.valueOf(pageSize), result);
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public String add(@RequestBody GridItemDaily itemDaily) {
        itemDaily.setId(UUID.randomUUID().toString());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        itemDaily.setCreateTime(df.format(new Date()));
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        criteria.andSjflIsNull();
        int count = this.gridItemDailyService.countByExample((Object)example);
        if (count == 0 || StringUtils.isNotEmpty((CharSequence)itemDaily.getSjfl())) {
            int result = this.gridItemDailyService.insert((Object)itemDaily);
            if (result == 1) {
                return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)itemDaily));
            }
            return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"fail"));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)300, (String)"\u5df2\u5b58\u5728\u6839\u8282\u70b9\uff01"));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public String delete(@RequestParam String id) {
        int result = this.gridItemDailyService.deleteByStringPrimaryKey(id);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)id));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"fail"));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public String update(@RequestBody GridItemDaily itemDaily) {
        int result = this.gridItemDailyService.updateByPrimaryKeySelective((Object)itemDaily);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)itemDaily));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"fail"));
    }

    @RequestMapping(value={"/treeNode"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> treeNode(@RequestParam(value="sxbm", required=false) String sxbm) {
        try {
            List str = this.gridItemDailyFacadeService.getTreeNode(sxbm);
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/getSxbm"}, method={RequestMethod.GET})
    @ResponseBody
    public String getSxbm(@RequestParam(value="sxbm") String sxbm) {
        String code = this.gridItemDailyFacadeService.getSxbm(sxbm);
        String name = this.gridItemDailyFacadeService.getSxmc(sxbm);
        return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)(code + ":" + name)));
    }

    @RequestMapping(value={"/addList"}, method={RequestMethod.GET})
    @ResponseBody
    public String addList(@RequestParam(value="createBy") String createBy) {
        int num = this.gridItemDailyFacadeService.rcsxbAddList(createBy);
        if (num == 1) {
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)"\u5bfc\u5165\u6210\u529f"));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"\u5bfc\u5165\u5931\u8d25"));
    }

    @RequestMapping(value={"/drsxList"}, method={RequestMethod.GET})
    @ResponseBody
    public String drsxList(@RequestParam(value="sxbm") String sxbm, @RequestParam(value="createBy") String createBy, @RequestParam(value="drnr") String drnr) {
        drnr = drnr.replaceAll("\"", "");
        drnr = drnr.replaceAll("\\]", "");
        String[] nums = (drnr = drnr.replaceAll("\\[", "")).split(",");
        int result = this.gridItemDailyFacadeService.rcsxdr(sxbm, createBy, nums);
        if (result == 1) {
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)"\u5bfc\u5165\u6210\u529f"));
        }
        return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)"\u5bfc\u5165\u5931\u8d25"));
    }

    @RequestMapping(value={"/delXjSxbm"}, method={RequestMethod.GET})
    @ResponseBody
    public String delXjSxbm(@RequestParam(value="sxbm") String sxbm) {
        List GridItemDaily2 = this.gridItemDailyFacadeService.DelXjSxbm(sxbm);
        int num = 0;
        if (GridItemDaily2.size() > 0) {
            num = 1;
        }
        return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)num));
    }

    @RequestMapping(value={"/dw/rcsxList"}, method={RequestMethod.GET})
    @ResponseBody
    public String getDwRcsxList(@RequestParam(value="sxbm", required=false) String sxbm) {
        try {
            AjaxResult result = new AjaxResult();
            List str = this.gridItemDailyFacadeService.getDwItemDailyList(sxbm, result);
            return JSON.toJSONString((Object)AjaxResult.success((String)"success", (Object)str));
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString((Object)AjaxResult.error((int)400, (String)e.toString()));
        }
    }

    @GetMapping(value={"/eventLevelTree"})
    @ResponseBody
    public AjaxResult getEventLevelTree(String sxbm) {
        return AjaxResult.success((Object)this.gridItemDailyFacadeService.getRcsxLevelTreeList(sxbm));
    }
}

