/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.vo.GridCompanySafeCheckExt;
import com.ruoyi.system.domain.grid.vo.GridCompanySafeCheckParam;
import com.ruoyi.system.service.grid.GridCompanySafeCheckService;
import io.swagger.annotations.Api;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7efc\u5408\u6267\u6cd5-\u4f01\u4e1a\u68c0\u67e5"})
@RestController
@RequestMapping(value={"/api/company/safeCheck"})
public class GridCompanySafeCheckController {
    @Autowired
    GridCompanySafeCheckService wsCompanySafeCheckService;

    @GetMapping(value={"/page"})
    public AjaxResult page(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="wgCode", required=false) String wgCode, @RequestParam(name="companyId", required=false) String companyId, @RequestParam(name="companyName", required=false) String companyName, @RequestParam(name="companyType", required=false) String companyType, @RequestParam(name="checkUserId", required=false) String checkUserId, @RequestParam(name="creditCode", required=false) String creditCode, @RequestParam(name="checkStatus", required=false) String checkStatus, @RequestParam(name="startTime", required=false) String startTime, @RequestParam(name="endTime", required=false) String endTime, @RequestParam(name="checkType", required=false) String checkType) {
        GridCompanySafeCheckParam param = new GridCompanySafeCheckParam();
        param.setWgCode(wgCode);
        param.setCompanyName(companyName);
        param.setCompanyType(companyType);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setCompanyId(companyId);
        param.setCheckUserId(checkUserId);
        param.setCreditCode(creditCode);
        param.setCheckStatus(checkStatus);
        param.setCheckType(checkType);
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.pageInfos(param, pageNo, pageSize));
    }

    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody GridCompanySafeCheckExt checkExt) {
        this.wsCompanySafeCheckService.save(checkExt);
        return AjaxResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @PostMapping(value={"/update"})
    public AjaxResult update(@RequestBody GridCompanySafeCheckExt checkExt) {
        this.wsCompanySafeCheckService.update(checkExt);
        return AjaxResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.detail(id));
    }

    @GetMapping(value={"/delete/{id}"})
    public AjaxResult delete(@PathVariable(value="id") String id) {
        this.wsCompanySafeCheckService.delete(id);
        return AjaxResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/countThirtyNum"})
    public AjaxResult countThirtyNum(@RequestParam(name="companyId") String companyId) {
        if (StringUtils.isBlank((String)companyId)) {
            throw new RuntimeException("\u67e5\u8be2\u5931\u8d25\uff1a\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.countThirthNum(companyId));
    }

    @GetMapping(value={"/countSafeCheck"})
    public AjaxResult countSafeCheck(@RequestParam(name="wgCode") String wgCode) {
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.countSafeCheckInfo(wgCode));
    }

    @GetMapping(value={"/countCompanyCheckInfo"})
    public AjaxResult countCompanyCheckInfo(@RequestParam(name="wgCode") String wgCode) {
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.countCompanyCheckInfo(wgCode));
    }

    @GetMapping(value={"/countCountryCheckInfo"})
    public AjaxResult countCountryCheckInfo(@RequestParam(name="wgCode") String wgCode) {
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.countCountryCheckInfo(wgCode));
    }

    @GetMapping(value={"/countSevenDayCheckInfo"})
    public AjaxResult countSevenDayCheckInfo(@RequestParam(name="wgCode") String wgCode) {
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.countSevenDayCheckInfo(wgCode));
    }

    @GetMapping(value={"/count/pageInfo"})
    public AjaxResult countPageInfo(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="15") Integer pageSize, @RequestParam(name="wgCode", required=false) String wgCode, @RequestParam(name="searchName", required=false) String searchName, @RequestParam(name="startTime", required=false) String startTime, @RequestParam(name="endTime", required=false) String endTime) {
        GridCompanySafeCheckParam param = new GridCompanySafeCheckParam();
        param.setWgId(wgCode);
        param.setSearchName(searchName);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.countPageInfo(param, pageNo, pageSize));
    }

    @GetMapping(value={"/count/pointPageInfo"})
    public AjaxResult countPageInfo(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="15") Integer pageSize, @RequestParam(name="longitude", required=false) String longitude, @RequestParam(name="latitude", required=false) String latitude) {
        GridCompanySafeCheckParam param = new GridCompanySafeCheckParam();
        param.setClockLongitude(longitude);
        param.setClockLatitude(latitude);
        return AjaxResult.success((Object)this.wsCompanySafeCheckService.countPointPageInfo(param, pageNo, pageSize));
    }
}

